/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.google.calendar.common;

import com.google.api.client.util.DateTime;
import com.google.api.services.calendar.model.Event;
import com.google.api.services.calendar.model.EventAttendee;
import com.google.api.services.calendar.model.EventDateTime;
import com.google.api.services.calendar.model.EventReminder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.bonitasoft.connectors.google.calendar.common.CalendarConnector;

public abstract class BuildEventConnector
extends CalendarConnector {
    public static final String INPUT_START_TIME = "startTime";
    public static final String INPUT_SOURCE_URL = "sourceUrl";
    public static final String INPUT_SOURCE_TITLE = "sourceTitle";
    public static final String INPUT_REMINDER_USE_DEFAULT = "reminderUseDefault";
    public static final String INPUT_REMINDER_OVERRIDES = "reminderOverrides";
    public static final String INPUT_RECURRENCE = "recurrence";
    public static final String INPUT_ORIGINAL_START_TIME_ZONE = "originalStartTimeZone";
    public static final String INPUT_ORIGINAL_START_TIME = "originalStartTime";
    public static final String INPUT_LOCATION = "location";
    public static final String INPUT_GUESTS_CAN_SEE_OTHER_GUESTS = "guestsCanSeeOtherGuests";
    public static final String INPUT_GUESTS_CAN_INVITE_OTHERS = "guestsCanInviteOthers";
    public static final String INPUT_GADGET_WIDTH = "gadgetWidth";
    public static final String INPUT_GADGET_TYPE = "gadgetType";
    public static final String INPUT_GADGET_TITLE = "gadgetTitle";
    public static final String INPUT_GADGET_ICON_LINK = "gadgetIconLink";
    public static final String INPUT_SEQUENCE = "sequence";
    public static final String INPUT_ORIGINAL_START_DATE = "originalStartDate";
    public static final String INPUT_GADGET_LINK = "gadgetLink";
    public static final String INPUT_GADGET_HEIGHT = "gadgetHeight";
    public static final String INPUT_START_TIME_ZONE = "startTimeZone";
    public static final String INPUT_STATUS = "status";
    public static final String INPUT_SUMMARY = "summary";
    public static final String INPUT_TRANSPARENCY = "transparency";
    public static final String INPUT_GADGET_DISPLAY = "gadgetDisplay";
    public static final String INPUT_GADGET_PREFERENCES = "gadgetPreferences";
    public static final String INPUT_VISIBILITY = "visibility";
    public static final String INPUT_END_TIME_ZONE = "endTimeZone";
    public static final String INPUT_END_TIME = "endTime";
    public static final String INPUT_DESCRIPTION = "description";
    public static final String INPUT_COLOR_ID = "colorId";
    public static final String INPUT_ATTENDEES_EMAILS = "attendeesEmails";
    public static final String INPUT_ANYONE_CAN_ADD_SELF = "anyoneCanAddSelf";
    public static final String INPUT_END_DATE = "endDate";
    public static final String INPUT_START_DATE = "startDate";
    public static final String INPUT_ALL_DAY = "allDay";
    private static final List<String> AVAILABLE_TZ_IDS = Arrays.asList(TimeZone.getAvailableIDs());
    private static final DateTimeFormatter RFC3339_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZone(ZoneId.of("UTC"));
    private static final String DATE_TIME_FORMAT_ERROR_PATTERN = "%s format is invalid. It must be like %s and it is now %s";
    private static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd";
    private static final String TIME_FORMAT_PATTERN = "HH:ss";
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private final SimpleDateFormat timeFormat = new SimpleDateFormat("HH:ss");

    protected List<String> checkStartDate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.getStartDate() != null && this.isDateFormatKO(this.dateFormat, this.getStartDate())) {
            errors.add(String.format(DATE_TIME_FORMAT_ERROR_PATTERN, "Start Date", DATE_FORMAT_PATTERN, this.getStartDate()));
        }
        if (this.getStartTime() != null && this.isDateFormatKO(this.timeFormat, this.getStartTime())) {
            errors.add(String.format(DATE_TIME_FORMAT_ERROR_PATTERN, "Start Time", TIME_FORMAT_PATTERN, this.getStartTime()));
        }
        if (this.getStartTime() != null && (this.getStartTimeZone() == null || this.getStartTimeZone().isEmpty())) {
            errors.add("Start Timezone must be specified when Start Time is specified");
            return errors;
        }
        if (this.getStartTimeZone() != null && !AVAILABLE_TZ_IDS.contains(this.getStartTimeZone())) {
            errors.add("Specified Start Timezone is not supported. It is now: " + this.getStartTimeZone() + " and should be one of: " + AVAILABLE_TZ_IDS.toString());
            return errors;
        }
        if (this.getStartDate() != null) {
            this.buildEventDateTime(this.getStartDate(), this.getStartTime(), this.getStartTimeZone());
        }
        return errors;
    }

    protected List<String> checkEndDate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.getEndDate() != null && this.isDateFormatKO(this.dateFormat, this.getEndDate())) {
            errors.add(String.format(DATE_TIME_FORMAT_ERROR_PATTERN, "End Date", DATE_FORMAT_PATTERN, this.getEndDate()));
        }
        if (this.getEndTime() != null && this.isDateFormatKO(this.timeFormat, this.getEndTime())) {
            errors.add(String.format(DATE_TIME_FORMAT_ERROR_PATTERN, "End Time", TIME_FORMAT_PATTERN, this.getEndTime()));
        }
        if (this.getEndTime() != null && (this.getEndTimeZone() == null || this.getEndTimeZone().isEmpty())) {
            errors.add("End Timezone must be specified when End Time is specified");
            return errors;
        }
        if (this.getEndTimeZone() != null && !AVAILABLE_TZ_IDS.contains(this.getEndTimeZone())) {
            errors.add("Specified End Timezone is not supported. It is now: " + this.getEndTimeZone() + " and should be one of: " + AVAILABLE_TZ_IDS.toString());
            return errors;
        }
        if (this.getEndDate() != null) {
            this.buildEventDateTime(this.getEndDate(), this.getEndTime(), this.getEndTimeZone());
        }
        return errors;
    }

    protected void buildEvent(Event event) {
        event.setStart(this.getStartDate() != null ? this.buildEventDateTime(this.getStartDate(), this.getStartTime(), this.getStartTimeZone()) : null);
        event.setEnd(this.getEndDate() != null ? this.buildEventDateTime(this.getEndDate(), this.getEndTime(), this.getEndTimeZone()) : null);
        event.setSummary(this.getSummary());
        event.setDescription(this.getDescription());
        event.setLocation(this.getLocation());
        event.setAnyoneCanAddSelf(this.getAnyoneCanAddSelf());
        event.setColorId(this.getColorId());
        if (this.getGadgetTitle() != null) {
            this.createGadget(event);
        }
        event.setGuestsCanInviteOthers(this.getGuestsCanInviteOthers());
        event.setGuestsCanSeeOtherGuests(this.getGuestsCanSeeOtherGuests());
        event.setId(this.getId());
        event.setSequence(this.getSequence());
        if (this.getSourceTitle() != null) {
            Event.Source source = new Event.Source();
            source.setTitle(this.getSourceTitle());
            source.setUrl(this.getSourceUrl());
            event.setSource(source);
        }
        event.setStatus(this.getStatus());
        event.setTransparency(this.getTransparency());
        event.setVisibility(this.getVisibility());
        if (this.getOriginalStartDate() != null) {
            event.setOriginalStartTime(this.buildEventDateTime(this.getOriginalStartDate(), this.getOriginalStartTime(), this.getOriginalStartTimeZone()));
        }
        event.setRecurrence(this.getRecurrence());
        if (this.getAttendeesEmails() != null) {
            this.addAttendees(event);
        }
        if (this.getReminderUseDefault() != null || this.getReminderOverrides() != null) {
            this.setReminders(event);
        }
    }

    private void setReminders(Event event) {
        Event.Reminders reminders = new Event.Reminders();
        if (this.getReminderUseDefault() != null) {
            reminders.setUseDefault(this.getReminderUseDefault());
        } else {
            reminders.setUseDefault(Boolean.valueOf(this.getReminderOverrides() == null));
        }
        if (this.getReminderOverrides() != null) {
            ArrayList<EventReminder> overrides = new ArrayList<EventReminder>();
            for (String override : this.getReminderOverrides()) {
                String[] overrideSplit = override.split(":");
                String method = overrideSplit[0];
                Integer minutes = Integer.valueOf(overrideSplit[1]);
                EventReminder eventReminder = new EventReminder();
                eventReminder.setMethod(method);
                eventReminder.setMinutes(minutes);
                overrides.add(eventReminder);
            }
            reminders.setOverrides(overrides);
        }
        event.setReminders(reminders);
    }

    private void addAttendees(Event event) {
        ArrayList<EventAttendee> attendees = new ArrayList<EventAttendee>();
        for (String attendeeEmail : this.getAttendeesEmails()) {
            EventAttendee eventAttendee = new EventAttendee();
            eventAttendee.setEmail(attendeeEmail);
            attendees.add(eventAttendee);
        }
        event.setAttendees(attendees);
    }

    private void createGadget(Event event) {
        Event.Gadget gadget = new Event.Gadget();
        gadget.setTitle(this.getGadgetTitle());
        gadget.setLink(this.getGadgetLink());
        gadget.setIconLink(this.getGadgetIconLink());
        gadget.setType(this.getGadgetType());
        if (this.getGadgetPreferences() != null) {
            gadget.setPreferences(this.getGadgetPreferences());
        }
        if (this.getGadgetWidth() != null) {
            gadget.setWidth(this.getGadgetWidth());
        }
        if (this.getGadgetHeight() != null) {
            gadget.setHeight(this.getGadgetHeight());
        }
        if (this.getGadgetDisplay() != null) {
            gadget.setDisplay(this.getGadgetDisplay());
        }
        event.setGadget(gadget);
    }

    protected ZonedDateTime getDate(ZoneId zoneId, String date, String time) {
        int year = Integer.parseInt(date.substring(0, 4));
        int month = Integer.parseInt(date.substring(5, 7));
        int day = Integer.parseInt(date.substring(8, 10));
        int hours = Integer.parseInt(time.substring(0, 2));
        int minutes = Integer.parseInt(time.substring(3, 5));
        return ZonedDateTime.of(year, month, day, hours, minutes, 0, 0, zoneId);
    }

    protected EventDateTime buildEventDateTime(String date, String dateTime, String timeZone) {
        EventDateTime edt = new EventDateTime();
        if (this.getAllDay() != null && this.getAllDay().booleanValue()) {
            edt.setDate(new DateTime(date));
        } else {
            ZonedDateTime localDate = this.getDate(ZoneId.of(timeZone), date, dateTime);
            edt.setDateTime(DateTime.parseRfc3339((String)localDate.format(RFC3339_FORMATTER)));
        }
        return edt;
    }

    protected boolean isDateFormatKO(SimpleDateFormat simpleDateFormat, String stringToParse) {
        try {
            simpleDateFormat.parse(stringToParse);
            return false;
        }
        catch (ParseException e) {
            return true;
        }
    }

    protected Boolean getAllDay() {
        return (Boolean)this.getInputParameter(INPUT_ALL_DAY);
    }

    protected String getStartDate() {
        return (String)this.getInputParameter(INPUT_START_DATE);
    }

    protected String getEndDate() {
        return (String)this.getInputParameter(INPUT_END_DATE);
    }

    protected Boolean getAnyoneCanAddSelf() {
        return (Boolean)this.getInputParameter(INPUT_ANYONE_CAN_ADD_SELF);
    }

    protected List<String> getAttendeesEmails() {
        return (List)this.getInputParameter(INPUT_ATTENDEES_EMAILS);
    }

    protected String getColorId() {
        return (String)this.getInputParameter(INPUT_COLOR_ID);
    }

    protected String getDescription() {
        return (String)this.getInputParameter(INPUT_DESCRIPTION);
    }

    protected String getEndTime() {
        return (String)this.getInputParameter(INPUT_END_TIME);
    }

    protected String getEndTimeZone() {
        return (String)this.getInputParameter(INPUT_END_TIME_ZONE);
    }

    protected String getGadgetDisplay() {
        return (String)this.getInputParameter(INPUT_GADGET_DISPLAY);
    }

    protected Integer getGadgetHeight() {
        return (Integer)this.getInputParameter(INPUT_GADGET_HEIGHT);
    }

    protected String getGadgetIconLink() {
        return (String)this.getInputParameter(INPUT_GADGET_ICON_LINK);
    }

    protected String getGadgetLink() {
        return (String)this.getInputParameter(INPUT_GADGET_LINK);
    }

    protected Map<String, String> getGadgetPreferences() {
        return this.getGadgetPreferencesAsMap();
    }

    protected String getGadgetTitle() {
        return (String)this.getInputParameter(INPUT_GADGET_TITLE);
    }

    protected String getGadgetType() {
        return (String)this.getInputParameter(INPUT_GADGET_TYPE);
    }

    protected Integer getGadgetWidth() {
        return (Integer)this.getInputParameter(INPUT_GADGET_WIDTH);
    }

    protected Boolean getGuestsCanInviteOthers() {
        return (Boolean)this.getInputParameter(INPUT_GUESTS_CAN_INVITE_OTHERS);
    }

    protected Boolean getGuestsCanSeeOtherGuests() {
        return (Boolean)this.getInputParameter(INPUT_GUESTS_CAN_SEE_OTHER_GUESTS);
    }

    protected String getLocation() {
        return (String)this.getInputParameter(INPUT_LOCATION);
    }

    protected String getOriginalStartDate() {
        return (String)this.getInputParameter(INPUT_ORIGINAL_START_DATE);
    }

    protected String getOriginalStartTime() {
        return (String)this.getInputParameter(INPUT_ORIGINAL_START_TIME);
    }

    protected String getOriginalStartTimeZone() {
        return (String)this.getInputParameter(INPUT_ORIGINAL_START_TIME_ZONE);
    }

    protected List<String> getRecurrence() {
        return (List)this.getInputParameter(INPUT_RECURRENCE);
    }

    protected List<String> getReminderOverrides() {
        return (List)this.getInputParameter(INPUT_REMINDER_OVERRIDES);
    }

    protected Boolean getReminderUseDefault() {
        return (Boolean)this.getInputParameter(INPUT_REMINDER_USE_DEFAULT);
    }

    protected Integer getSequence() {
        return (Integer)this.getInputParameter(INPUT_SEQUENCE);
    }

    protected String getSourceTitle() {
        return (String)this.getInputParameter(INPUT_SOURCE_TITLE);
    }

    protected String getSourceUrl() {
        return (String)this.getInputParameter(INPUT_SOURCE_URL);
    }

    protected String getStartTime() {
        return (String)this.getInputParameter(INPUT_START_TIME);
    }

    protected String getStartTimeZone() {
        return (String)this.getInputParameter(INPUT_START_TIME_ZONE);
    }

    protected String getStatus() {
        return (String)this.getInputParameter(INPUT_STATUS);
    }

    protected String getSummary() {
        return (String)this.getInputParameter(INPUT_SUMMARY);
    }

    protected String getTransparency() {
        return (String)this.getInputParameter(INPUT_TRANSPARENCY);
    }

    protected String getVisibility() {
        return (String)this.getInputParameter(INPUT_VISIBILITY);
    }

    private Map<String, String> getGadgetPreferencesAsMap() {
        List inputPreferences = (List)this.getInputParameter(INPUT_GADGET_PREFERENCES);
        HashMap<String, String> result = new HashMap<String, String>();
        if (inputPreferences != null) {
            for (List rows : inputPreferences) {
                if (rows.size() != 2) continue;
                Object keyContent = rows.get(0);
                Object valueContent = rows.get(1);
                if (keyContent == null || valueContent == null) continue;
                String key = keyContent.toString();
                String value = valueContent.toString();
                result.put(key, value);
            }
        }
        return result;
    }
}

