/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bonitasoft.engine.api.NoSessionRequired;
import org.bonitasoft.engine.api.internal.ServerAPI;
import org.bonitasoft.engine.api.internal.ServerWrappedException;
import org.bonitasoft.engine.session.Session;

public class ClientInterceptor
implements InvocationHandler,
Serializable {
    private static final Level LOG_LEVEL = Level.FINEST;
    private static final long serialVersionUID = -6284726148297940515L;
    private final ServerAPI api;
    private final String interfaceName;
    private final Session session;
    private static final Logger LOGGER = Logger.getLogger(ClientInterceptor.class.getName());

    public ClientInterceptor(String interfaceName, ServerAPI api, Session session) {
        this.api = api;
        this.interfaceName = interfaceName;
        this.session = session;
    }

    public ClientInterceptor(String interfaceName, ServerAPI api) {
        this(interfaceName, api, null);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Class<?>[] parameterTypes = method.getParameterTypes();
            ArrayList<String> classNameParameters = new ArrayList<String>();
            for (Class<?> parameterType : parameterTypes) {
                classNameParameters.add(parameterType.getName());
            }
            if (LOGGER.isLoggable(LOG_LEVEL)) {
                LOGGER.log(LOG_LEVEL, "Calling method " + method.getName() + " on API " + this.api.getClass().getName());
            }
            Map<String, Serializable> options = new HashMap();
            if (method.isAnnotationPresent(NoSessionRequired.class)) {
                options = Collections.emptyMap();
            } else {
                options = new HashMap();
                options.put("session", this.session);
            }
            Object object = this.api.invokeMethod(options, this.interfaceName, method.getName(), classNameParameters, args);
            if (LOGGER.isLoggable(LOG_LEVEL)) {
                LOGGER.log(LOG_LEVEL, "Quitting method " + method.getName() + " on API " + this.api.getClass().getName());
            }
            return object;
        }
        catch (ServerWrappedException e) {
            if (LOGGER.isLoggable(LOG_LEVEL)) {
                LOGGER.log(LOG_LEVEL, "Quitting method " + method.getName() + " on API " + this.api.getClass().getName() + " with exception " + e.getMessage());
            }
            Throwable cause = e.getCause();
            throw cause;
        }
        catch (RemoteException e) {
            if (LOGGER.isLoggable(LOG_LEVEL)) {
                LOGGER.log(LOG_LEVEL, "Quitting method " + method.getName() + " on API " + this.api.getClass().getName() + " with exception " + e.getMessage());
            }
            Throwable cause = e.getCause();
            throw cause;
        }
    }
}

