/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.bar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipOutputStream;
import org.bonitasoft.engine.bpm.bar.ActorMappingContribution;
import org.bonitasoft.engine.bpm.bar.BusinessArchive;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveContribution;
import org.bonitasoft.engine.bpm.bar.ClasspathContribution;
import org.bonitasoft.engine.bpm.bar.ConnectorContribution;
import org.bonitasoft.engine.bpm.bar.DocumentsResourcesContribution;
import org.bonitasoft.engine.bpm.bar.ExternalResourceContribution;
import org.bonitasoft.engine.bpm.bar.InvalidBusinessArchiveFormatException;
import org.bonitasoft.engine.bpm.bar.ProcessDefinitionBARContribution;
import org.bonitasoft.engine.bpm.bar.UserFilterContribution;
import org.bonitasoft.engine.io.IOUtil;

public class BusinessArchiveFactory {
    private static final List<BusinessArchiveContribution> contributions = new ArrayList<BusinessArchiveContribution>();

    public static BusinessArchive readBusinessArchive(InputStream inputStream) throws IOException, InvalidBusinessArchiveFormatException {
        File barFolder = File.createTempFile("tempBusinessArchive", "tmp");
        barFolder.delete();
        barFolder.mkdir();
        IOUtil.unzipToFolder(inputStream, barFolder);
        BusinessArchive businessArchive = new BusinessArchive();
        try {
            for (BusinessArchiveContribution contribution : contributions) {
                if (contribution.readFromBarFolder(businessArchive, barFolder) || !contribution.isMandatory()) continue;
                throw new InvalidBusinessArchiveFormatException("Invalid format, can't read '" + contribution.getName() + "' from the BAR file");
            }
            BusinessArchive i$ = businessArchive;
            return i$;
        }
        catch (InvalidBusinessArchiveFormatException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidBusinessArchiveFormatException("Invalid format, can't read the BAR file", e);
        }
        finally {
            IOUtil.deleteDir(barFolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BusinessArchive readBusinessArchive(File barOrFolder) throws InvalidBusinessArchiveFormatException, IOException {
        if (!barOrFolder.exists()) {
            throw new FileNotFoundException("the file does not exists: " + barOrFolder.getAbsolutePath());
        }
        if (barOrFolder.isDirectory()) {
            BusinessArchive businessArchive = new BusinessArchive();
            for (BusinessArchiveContribution contribution : contributions) {
                if (contribution.readFromBarFolder(businessArchive, barOrFolder) || !contribution.isMandatory()) continue;
                throw new InvalidBusinessArchiveFormatException("Invalid format, can't read " + contribution.getName() + " from the BAR file");
            }
            return businessArchive;
        }
        FileInputStream inputStream = new FileInputStream(barOrFolder);
        try {
            BusinessArchive businessArchive = BusinessArchiveFactory.readBusinessArchive(inputStream);
            return businessArchive;
        }
        finally {
            inputStream.close();
        }
    }

    public static void writeBusinessArchiveToFolder(BusinessArchive businessArchive, File folderPath) throws IOException {
        if (folderPath.exists()) {
            if (!folderPath.isDirectory()) {
                throw new IOException("unable to create Business archive on a file " + folderPath);
            }
        } else {
            folderPath.mkdir();
        }
        for (BusinessArchiveContribution contribution : contributions) {
            contribution.saveToBarFolder(businessArchive, folderPath);
        }
    }

    public static void writeBusinessArchiveToFile(BusinessArchive businessArchive, File businessArchiveFile) throws IOException {
        File tempFile = File.createTempFile("businessArchiveFolder", "tmp");
        tempFile.delete();
        tempFile.mkdir();
        BusinessArchiveFactory.writeBusinessArchiveToFolder(businessArchive, tempFile);
        BusinessArchiveFactory.zipBarFolder(businessArchiveFile, tempFile);
        IOUtil.deleteDir(tempFile);
    }

    public static String businessArchiveFolderToFile(File destFile, String folderPath) throws IOException {
        BusinessArchiveFactory.zipBarFolder(destFile, new File(folderPath));
        return destFile.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipBarFolder(File businessArchiveFile, File folder) throws FileNotFoundException, IOException {
        if (businessArchiveFile.exists()) {
            throw new IOException("The destination file already exists " + businessArchiveFile.getAbsolutePath());
        }
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(businessArchiveFile));
        try {
            IOUtil.zipDir(folder.getAbsolutePath(), zos, folder.getAbsolutePath());
        }
        finally {
            zos.close();
        }
    }

    static {
        contributions.add(new ProcessDefinitionBARContribution());
        contributions.add(new ConnectorContribution());
        contributions.add(new ExternalResourceContribution());
        contributions.add(new ActorMappingContribution());
        contributions.add(new UserFilterContribution());
        contributions.add(new DocumentsResourcesContribution());
        contributions.add(new ClasspathContribution());
    }
}

