/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.bar;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import org.bonitasoft.engine.bpm.bar.BusinessArchive;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveContribution;

public abstract class GenericFileContribution
implements BusinessArchiveContribution {
    public abstract String getFileName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean readFromBarFolder(BusinessArchive businessArchive, File barFolder) throws IOException {
        File file = new File(barFolder, this.getFileName());
        if (!file.exists()) {
            return false;
        }
        FileChannel ch = null;
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            ch = fin.getChannel();
            int size = (int)ch.size();
            MappedByteBuffer buf = ch.map(FileChannel.MapMode.READ_ONLY, 0L, size);
            byte[] bytes = new byte[size];
            buf.get(bytes);
            businessArchive.addResource(this.getFileName(), bytes);
        }
        finally {
            if (fin != null) {
                fin.close();
            }
            if (ch != null) {
                ch.close();
            }
        }
        ch = null;
        fin = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveToBarFolder(BusinessArchive businessArchive, File barFolder) throws IOException {
        Map<String, byte[]> resources = businessArchive.getResources(this.getFileName());
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        for (Map.Entry<String, byte[]> entry : resources.entrySet()) {
            byte[] value = entry.getValue();
            if (value != null) {
                try {
                    fos = new FileOutputStream(new File(barFolder, entry.getKey()));
                    bos = new BufferedOutputStream(fos);
                    bos.write(value);
                }
                finally {
                    if (bos != null) {
                        bos.close();
                    } else if (fos != null) {
                        fos.close();
                    }
                }
            }
            fos = null;
            bos = null;
        }
    }
}

