/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.bar.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.bpm.connector.ConnectorDefinition;
import org.bonitasoft.engine.bpm.data.DataDefinition;
import org.bonitasoft.engine.bpm.document.DocumentDefinition;
import org.bonitasoft.engine.bpm.flownode.ActivityDefinition;
import org.bonitasoft.engine.bpm.flownode.EndEventDefinition;
import org.bonitasoft.engine.bpm.flownode.GatewayDefinition;
import org.bonitasoft.engine.bpm.flownode.IntermediateCatchEventDefinition;
import org.bonitasoft.engine.bpm.flownode.IntermediateThrowEventDefinition;
import org.bonitasoft.engine.bpm.flownode.StartEventDefinition;
import org.bonitasoft.engine.bpm.flownode.TransitionDefinition;
import org.bonitasoft.engine.bpm.flownode.impl.FlowElementContainerDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.FlowNodeDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.TransitionDefinitionImpl;
import org.bonitasoft.engine.io.xml.ElementBinding;

public class FlowElementBinding
extends ElementBinding {
    private final List<ActivityDefinition> activities = new ArrayList<ActivityDefinition>();
    private final List<GatewayDefinition> gateways = new ArrayList<GatewayDefinition>();
    private final List<TransitionDefinition> transitions = new ArrayList<TransitionDefinition>();
    private final List<StartEventDefinition> startEvents = new ArrayList<StartEventDefinition>();
    private final List<IntermediateCatchEventDefinition> intermediateCatchEvents = new ArrayList<IntermediateCatchEventDefinition>();
    private final List<EndEventDefinition> endEvents = new ArrayList<EndEventDefinition>();
    private final List<IntermediateThrowEventDefinition> intermediateThrowEvents = new ArrayList<IntermediateThrowEventDefinition>();
    private final List<DataDefinition> dataDefinitions = new ArrayList<DataDefinition>();
    private final List<DocumentDefinition> documentDefinitions = new ArrayList<DocumentDefinition>();
    private final List<ConnectorDefinition> connectors = new ArrayList<ConnectorDefinition>();

    @Override
    public void setChildObject(String name, Object value) {
        if ("automaticTask".equals(name) || "userTask".equals(name) || "manualTask".equals(name) || "callActivity".equals(name) || "subProcess".equals(name) || "receiveTask".equals(name) || "sendTask".equals(name)) {
            this.activities.add((ActivityDefinition)value);
        } else if ("connector".equals(name)) {
            this.connectors.add((ConnectorDefinition)value);
        } else if ("dataDefinition".equals(name)) {
            this.dataDefinitions.add((DataDefinition)value);
        } else if ("xmlDataDefinition".equals(name)) {
            this.dataDefinitions.add((DataDefinition)value);
        } else if ("textDataDefinition".equals(name)) {
            this.dataDefinitions.add((DataDefinition)value);
        } else if ("documentDefinition".equals(name)) {
            this.documentDefinitions.add((DocumentDefinition)value);
        } else if ("gateway".equals(name)) {
            this.gateways.add((GatewayDefinition)value);
        } else if ("transition".equals(name)) {
            this.transitions.add((TransitionDefinition)value);
        } else if ("startEvent".equals(name)) {
            this.startEvents.add((StartEventDefinition)value);
        } else if ("intermediateCatchEvent".equals(name)) {
            this.intermediateCatchEvents.add((IntermediateCatchEventDefinition)value);
        } else if ("intermediateThrowEvent".equals(name)) {
            this.intermediateThrowEvents.add((IntermediateThrowEventDefinition)value);
        } else if ("endEvent".equals(name)) {
            this.endEvents.add((EndEventDefinition)value);
        }
    }

    @Override
    public Object getObject() {
        FlowElementContainerDefinitionImpl container = new FlowElementContainerDefinitionImpl();
        for (TransitionDefinition transition : this.transitions) {
            container.addTransition(transition);
        }
        for (ActivityDefinition activity : this.activities) {
            container.addActivity(activity);
        }
        for (GatewayDefinition gateway : this.gateways) {
            container.addGateway(gateway);
        }
        for (ConnectorDefinition connector : this.connectors) {
            container.addConnector(connector);
        }
        for (DataDefinition dataDefinition : this.dataDefinitions) {
            container.addDataDefinition(dataDefinition);
        }
        for (DocumentDefinition documentDefinition : this.documentDefinitions) {
            container.addDocumentDefinition(documentDefinition);
        }
        for (StartEventDefinition startEvent : this.startEvents) {
            container.addStartEvent(startEvent);
        }
        for (IntermediateCatchEventDefinition intermediateCatchEvent : this.intermediateCatchEvents) {
            container.addIntermediateCatchEvent(intermediateCatchEvent);
        }
        for (IntermediateThrowEventDefinition intermediateThrowEvent : this.intermediateThrowEvents) {
            container.addIntermediateThrowEvent(intermediateThrowEvent);
        }
        for (EndEventDefinition endEvent : this.endEvents) {
            container.addEndEvent(endEvent);
        }
        this.addTransitionOnFlowNodes(container);
        return container;
    }

    @Override
    public String getElementTag() {
        return "flowElements";
    }

    private void addTransitionOnFlowNodes(FlowElementContainerDefinitionImpl container) {
        block0: for (TransitionDefinition transition : this.transitions) {
            long target;
            FlowNodeDefinitionImpl targetNode;
            long source = transition.getSource();
            FlowNodeDefinitionImpl sourceNode = (FlowNodeDefinitionImpl)container.getFlowNode(source);
            if (sourceNode != null) {
                TransitionDefinition defaultTransition = sourceNode.getDefaultTransition();
                if (defaultTransition != null && ((TransitionDefinitionImpl)defaultTransition).getId() == ((TransitionDefinitionImpl)transition).getId()) {
                    sourceNode.setDefaultTransition(transition);
                } else {
                    List<TransitionDefinition> outgoingTransitionsForSourceNode = sourceNode.getOutgoingTransitions();
                    for (TransitionDefinition transitionRef : outgoingTransitionsForSourceNode) {
                        if (((TransitionDefinitionImpl)transitionRef).getId() != ((TransitionDefinitionImpl)transition).getId()) continue;
                        int indexOfSTransitionRef = outgoingTransitionsForSourceNode.indexOf(transitionRef);
                        sourceNode.removeOutgoingTransition(transitionRef);
                        sourceNode.addOutgoingTransition(indexOfSTransitionRef, transition);
                        break;
                    }
                }
            }
            if ((targetNode = (FlowNodeDefinitionImpl)container.getFlowNode(target = transition.getTarget())) == null) continue;
            List<TransitionDefinition> incomingTransitionsForTargetNode = targetNode.getIncomingTransitions();
            for (TransitionDefinition transitionRef : incomingTransitionsForTargetNode) {
                if (((TransitionDefinitionImpl)transitionRef).getId() != ((TransitionDefinitionImpl)transition).getId()) continue;
                int indexOfSTransitionRef = incomingTransitionsForTargetNode.indexOf(transitionRef);
                targetNode.removeIncomingTransition(transitionRef);
                targetNode.addIncomingTransition(indexOfSTransitionRef, transition);
                continue block0;
            }
        }
    }

    @Override
    public void setAttributes(Map<String, String> attributes) {
    }

    @Override
    public void setChildElement(String name, String value, Map<String, String> attributes) {
    }
}

