/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.process.impl;

import java.io.Serializable;
import java.util.Date;
import org.bonitasoft.engine.bpm.connector.ConnectorEvent;
import org.bonitasoft.engine.bpm.flownode.impl.ActivityDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.FlowElementContainerDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.StandardLoopCharacteristics;
import org.bonitasoft.engine.bpm.process.impl.BoundaryEventDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.ConnectorDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.DataDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.DescriptionBuilder;
import org.bonitasoft.engine.bpm.process.impl.FlowElementContainerBuilder;
import org.bonitasoft.engine.bpm.process.impl.MultiInstanceLoopCharacteristicsBuilder;
import org.bonitasoft.engine.bpm.process.impl.ProcessDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.TextDataDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.XMLDataDefinitionBuilder;
import org.bonitasoft.engine.expression.Expression;
import org.bonitasoft.engine.operation.LeftOperand;
import org.bonitasoft.engine.operation.Operation;
import org.bonitasoft.engine.operation.OperationBuilder;
import org.bonitasoft.engine.operation.OperatorType;

public class ActivityDefinitionBuilder
extends FlowElementContainerBuilder
implements DescriptionBuilder {
    private final ActivityDefinitionImpl activity;

    public ActivityDefinitionBuilder(FlowElementContainerDefinitionImpl container, ProcessDefinitionBuilder processDefinitionBuilder, ActivityDefinitionImpl activity) {
        super(container, processDefinitionBuilder);
        this.activity = activity;
        this.getContainer().addActivity(activity);
    }

    ActivityDefinitionImpl getActivity() {
        return this.activity;
    }

    @Override
    public DataDefinitionBuilder addIntegerData(String name, Expression defaultValue) {
        String className = Integer.class.getName();
        return new DataDefinitionBuilder(this.getProcessBuilder(), this.getContainer(), this.activity, name, className, defaultValue);
    }

    @Override
    public DataDefinitionBuilder addLongData(String name, Expression defaultValue) {
        String className = Long.class.getName();
        return new DataDefinitionBuilder(this.getProcessBuilder(), this.getContainer(), this.activity, name, className, defaultValue);
    }

    @Override
    public DataDefinitionBuilder addShortTextData(String name, Expression defaultValue) {
        String className = String.class.getName();
        return new TextDataDefinitionBuilder(this.getProcessBuilder(), this.getContainer(), this.activity, name, className, defaultValue);
    }

    @Override
    public TextDataDefinitionBuilder addLongTextData(String name, Expression defaultValue) {
        String className = String.class.getName();
        return new TextDataDefinitionBuilder(this.getProcessBuilder(), this.getContainer(), this.activity, name, className, defaultValue).isLongText();
    }

    @Override
    public DataDefinitionBuilder addDoubleData(String name, Expression defaultValue) {
        String className = Double.class.getName();
        return new DataDefinitionBuilder(this.getProcessBuilder(), this.getContainer(), this.activity, name, className, defaultValue);
    }

    @Override
    public DataDefinitionBuilder addDateData(String name, Expression defaultValue) {
        String className = Date.class.getName();
        return new DataDefinitionBuilder(this.getProcessBuilder(), this.getContainer(), this.activity, name, className, defaultValue);
    }

    @Override
    public XMLDataDefinitionBuilder addXMLData(String name, Expression defaultValue) {
        String className = String.class.getName();
        return new XMLDataDefinitionBuilder(this.getProcessBuilder(), this.getContainer(), this.activity, name, className, defaultValue);
    }

    @Override
    public DataDefinitionBuilder addBlobData(String name, Expression defaultValue) {
        String className = Serializable.class.getName();
        return new DataDefinitionBuilder(this.getProcessBuilder(), this.getContainer(), this.activity, name, className, defaultValue);
    }

    @Override
    public DataDefinitionBuilder addBooleanData(String name, Expression defaultValue) {
        String className = Boolean.class.getName();
        return new DataDefinitionBuilder(this.getProcessBuilder(), this.getContainer(), this.activity, name, className, defaultValue);
    }

    @Override
    public DataDefinitionBuilder addData(String name, String className, Expression defaultValue) {
        return new DataDefinitionBuilder(this.getProcessBuilder(), this.getContainer(), this.activity, name, className, defaultValue);
    }

    @Override
    public ConnectorDefinitionBuilder addConnector(String name, String connectorId, String version, ConnectorEvent activationEvent) {
        return new ConnectorDefinitionBuilder(this.getProcessBuilder(), this.getContainer(), name, connectorId, version, activationEvent, this.activity);
    }

    @Override
    public ActivityDefinitionBuilder addDescription(String description) {
        this.activity.setDescription(description);
        return this;
    }

    public ActivityDefinitionBuilder addDisplayDescription(Expression displayDescription) {
        this.activity.setDisplayDescription(displayDescription);
        return this;
    }

    public ActivityDefinitionBuilder addDisplayName(Expression displayName) {
        this.activity.setDisplayName(displayName);
        return this;
    }

    public ActivityDefinitionBuilder addDisplayDescriptionAfterCompletion(Expression displayDescriptionAfterCompletion) {
        this.activity.setDisplayDescriptionAfterCompletion(displayDescriptionAfterCompletion);
        return this;
    }

    public ActivityDefinitionBuilder addOperation(LeftOperand leftOperand, OperatorType type, String operator, String operatorInputType, Expression rightOperand) {
        this.activity.addOperation(new OperationBuilder().createNewInstance().setRightOperand(rightOperand).setType(type).setOperator(operator).setOperatorInputType(operatorInputType).setLeftOperand(leftOperand).done());
        if (rightOperand == null) {
            this.getProcessBuilder().addError("operation on activity " + this.activity.getName() + " has no expression in right operand");
        }
        return this;
    }

    public ActivityDefinitionBuilder addOperation(Operation operation) {
        this.activity.addOperation(operation);
        if (operation.getRightOperand() == null) {
            this.getProcessBuilder().addError("operation on activity " + this.activity.getName() + " has no expression in right operand");
        }
        return this;
    }

    public ActivityDefinitionBuilder addLoop(boolean testBefore, Expression condition) {
        StandardLoopCharacteristics loopCharacteristics = new StandardLoopCharacteristics(condition, testBefore);
        this.activity.setLoopCharacteristics(loopCharacteristics);
        return this;
    }

    public ActivityDefinitionBuilder addLoop(boolean testBefore, Expression condition, Expression loopMax) {
        StandardLoopCharacteristics loopCharacteristics = new StandardLoopCharacteristics(condition, testBefore, loopMax);
        this.activity.setLoopCharacteristics(loopCharacteristics);
        return this;
    }

    public BoundaryEventDefinitionBuilder addBoundaryEvent(String name, boolean interrupting) {
        return new BoundaryEventDefinitionBuilder(this.getProcessBuilder(), this.getContainer(), this.activity, name, interrupting);
    }

    public BoundaryEventDefinitionBuilder addBoundaryEvent(String name) {
        return new BoundaryEventDefinitionBuilder(this.getProcessBuilder(), this.getContainer(), this.activity, name, true);
    }

    public MultiInstanceLoopCharacteristicsBuilder addMultiInstance(boolean isSequential, Expression loopCardinality) {
        return new MultiInstanceLoopCharacteristicsBuilder(this.getProcessBuilder(), this.activity, isSequential, loopCardinality);
    }

    public MultiInstanceLoopCharacteristicsBuilder addMultiInstance(boolean isSequential, String loopDataInput) {
        return new MultiInstanceLoopCharacteristicsBuilder(this.getProcessBuilder(), this.activity, isSequential, loopDataInput);
    }
}

