/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.process.impl;

import org.bonitasoft.engine.bpm.flownode.impl.FlowElementContainerDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.SendTaskDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.ThrowMessageEventTriggerDefinitionImpl;
import org.bonitasoft.engine.bpm.process.impl.ActivityDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.DataDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.ProcessDefinitionBuilder;
import org.bonitasoft.engine.expression.Expression;

public class SendTaskDefinitionBuilder
extends ActivityDefinitionBuilder {
    public SendTaskDefinitionBuilder(ProcessDefinitionBuilder processDefinitionBuilder, FlowElementContainerDefinitionImpl process, String taskName, String messageName, Expression targetProcess) {
        super(process, processDefinitionBuilder, new SendTaskDefinitionImpl(taskName, messageName, targetProcess));
        if (messageName == null || messageName.isEmpty()) {
            processDefinitionBuilder.addError("Message is not set on the send task " + taskName);
        }
    }

    public SendTaskDefinitionBuilder setTargetFlowNode(Expression targetFlowNode) {
        this.getActivity().setTargetFlowNode(targetFlowNode);
        return this;
    }

    public DataDefinitionBuilder addMessageContentExpression(Expression displayName, Expression messageContent) {
        String dataName = displayName.getContent();
        String className = messageContent.getReturnType();
        return new DataDefinitionBuilder(this.getProcessBuilder(), this.getContainer(), (ThrowMessageEventTriggerDefinitionImpl)this.getActivity().getMessageTrigger(), dataName, className, messageContent);
    }

    public SendTaskDefinitionBuilder addCorrelation(Expression correlationKey, Expression value) {
        SendTaskDefinitionImpl sendTask = this.getActivity();
        sendTask.addCorrelation(correlationKey, value);
        if (sendTask.getMessageTrigger().getCorrelations().size() > 5) {
            this.getProcessBuilder().addError("The limit of correlation keys are 5 on send task: " + sendTask.getName());
        }
        return this;
    }

    @Override
    SendTaskDefinitionImpl getActivity() {
        return (SendTaskDefinitionImpl)super.getActivity();
    }
}

