/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.exception;

import org.bonitasoft.engine.exception.BonitaException;

public class NotSerializableException
extends BonitaException {
    private static final long serialVersionUID = -5541516162117265707L;

    public NotSerializableException(String connectorDefinitionId, Throwable e) {
        super("Connector " + connectorDefinitionId + " executed successfully but output cannot be read correctly. See Bonita Engine log file for technical details.", e);
    }

    public NotSerializableException(String connectorDefinitionId, String connectorDefinitionVersion, String key, Object value) {
        super(NotSerializableException.createMessage(connectorDefinitionId, connectorDefinitionVersion, key, value));
    }

    private static String createMessage(String connectorDefinitionId, String connectorDefinitionVersion, String key, Object value) {
        StringBuilder stringBuilder = new StringBuilder("the connector ");
        stringBuilder.append(connectorDefinitionId);
        stringBuilder.append(' ');
        stringBuilder.append(connectorDefinitionVersion);
        stringBuilder.append(" have an unserializable output and was called directly from the api. name=");
        stringBuilder.append(key);
        stringBuilder.append(" value=");
        stringBuilder.append(value.toString());
        return stringBuilder.toString();
    }
}

