/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce;

import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.interfaces.DHKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import org.bouncycastle.jcajce.interfaces.DSTU4145Key;
import org.bouncycastle.jcajce.interfaces.DSTU4145PrivateKey;
import org.bouncycastle.jcajce.interfaces.DSTU4145PublicKey;
import org.bouncycastle.jcajce.interfaces.ECGOST3410PrivateKey;
import org.bouncycastle.jcajce.interfaces.ECGOST3410PublicKey;
import org.bouncycastle.jcajce.interfaces.GOST3410Key;
import org.bouncycastle.jcajce.interfaces.GOST3410PrivateKey;
import org.bouncycastle.jcajce.interfaces.GOST3410PublicKey;
import org.bouncycastle.jcajce.spec.DSTU4145ParameterSpec;
import org.bouncycastle.jcajce.spec.ECDomainParameterSpec;
import org.bouncycastle.jcajce.spec.GOST3410DomainParameterSpec;
import org.bouncycastle.jcajce.spec.GOST3410ParameterSpec;

public class ConsistentKeyPair {
    private PrivateKey privateKey;
    private PublicKey publicKey;

    public ConsistentKeyPair(final PublicKey publicKey, final PrivateKey privateKey) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ConsistentKeyPair.this.checkKeyPairForConsistency(publicKey, privateKey);
                return null;
            }
        });
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkKeyPairForConsistency(PublicKey publicKey, PrivateKey privateKey) {
        if (publicKey instanceof ECKey && privateKey instanceof ECKey) {
            ECPrivateKey eCPrivateKey = (ECPrivateKey)privateKey;
            ECPublicKey eCPublicKey = (ECPublicKey)publicKey;
            if (!(eCPrivateKey.getParams().getCurve().equals(eCPublicKey.getParams().getCurve()) && eCPrivateKey.getParams().getGenerator().equals(eCPublicKey.getParams().getGenerator()) && eCPrivateKey.getParams().getOrder().equals(eCPublicKey.getParams().getOrder()) && eCPrivateKey.getParams().getCofactor() == eCPublicKey.getParams().getCofactor())) {
                throw new IllegalArgumentException("EC keys do not have the same domain parameters");
            }
            ECDomainParameterSpec eCDomainParameterSpec = new ECDomainParameterSpec(eCPrivateKey.getParams());
            if (eCDomainParameterSpec.getDomainParameters().getG().multiply(eCPrivateKey.getS()).normalize().equals(eCDomainParameterSpec.getDomainParameters().getCurve().createPoint(eCPublicKey.getW().getAffineX(), eCPublicKey.getW().getAffineY()))) return;
            throw new IllegalArgumentException("EC public key not consistent with EC private key");
        }
        if (publicKey instanceof DHKey && privateKey instanceof DHKey) {
            DHPrivateKey dHPrivateKey = (DHPrivateKey)privateKey;
            DHPublicKey dHPublicKey = (DHPublicKey)publicKey;
            DHParameterSpec dHParameterSpec = dHPrivateKey.getParams();
            if (!dHParameterSpec.getG().equals(dHPublicKey.getParams().getG()) && !dHParameterSpec.getP().equals(dHPublicKey.getParams().getP())) {
                throw new IllegalArgumentException("DH keys do not have the same domain parameters");
            }
            if (dHParameterSpec.getG().modPow(dHPrivateKey.getX(), dHParameterSpec.getP()).equals(dHPublicKey.getY())) return;
            throw new IllegalArgumentException("DH public key not consistent with DH private key");
        }
        if (publicKey instanceof DSAKey && privateKey instanceof DSAKey) {
            DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)privateKey;
            DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
            DSAParams dSAParams = dSAPrivateKey.getParams();
            if (!(dSAParams.getG().equals(dSAPublicKey.getParams().getG()) || dSAParams.getP().equals(dSAPublicKey.getParams().getP()) || dSAParams.getQ().equals(dSAPublicKey.getParams().getQ()))) {
                throw new IllegalArgumentException("DSA keys do not have the same domain parameters");
            }
            if (dSAParams.getG().modPow(dSAPrivateKey.getX(), dSAParams.getP()).equals(dSAPublicKey.getY())) return;
            throw new IllegalArgumentException("DSA public key not consistent with DSA private key");
        }
        if (publicKey instanceof RSAKey && privateKey instanceof RSAKey) {
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)privateKey;
            RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
            if (!rSAPrivateKey.getModulus().equals(rSAPublicKey.getModulus())) {
                throw new IllegalArgumentException("RSA keys do not have the same modulus");
            }
            BigInteger bigInteger = BigInteger.valueOf(2L);
            if (bigInteger.modPow(rSAPrivateKey.getPrivateExponent(), rSAPrivateKey.getModulus()).modPow(rSAPublicKey.getPublicExponent(), rSAPrivateKey.getModulus()).equals(bigInteger)) return;
            throw new IllegalArgumentException("RSA public key not consistent with RSA private key");
        }
        if (publicKey instanceof GOST3410Key && privateKey instanceof GOST3410Key) {
            if (!((GOST3410Key)((Object)publicKey)).getParams().equals(((GOST3410Key)((Object)privateKey)).getParams())) {
                throw new IllegalArgumentException("GOST3410 parameters mismatch");
            }
            if (publicKey instanceof GOST3410PublicKey && privateKey instanceof GOST3410PrivateKey) {
                GOST3410PrivateKey gOST3410PrivateKey = (GOST3410PrivateKey)privateKey;
                GOST3410PublicKey gOST3410PublicKey = (GOST3410PublicKey)publicKey;
                GOST3410ParameterSpec gOST3410ParameterSpec = gOST3410PrivateKey.getParams();
                GOST3410DomainParameterSpec gOST3410DomainParameterSpec = (GOST3410DomainParameterSpec)gOST3410ParameterSpec.getDomainParametersSpec();
                if (gOST3410DomainParameterSpec.getA().modPow(gOST3410PrivateKey.getX(), gOST3410DomainParameterSpec.getP()).equals(gOST3410PublicKey.getY())) return;
                throw new IllegalArgumentException("GOST3410 public key not consistent with GOST3410 private key");
            }
            if (!(publicKey instanceof ECGOST3410PublicKey) || !(privateKey instanceof ECGOST3410PrivateKey)) throw new IllegalArgumentException("GOST3410 key pair inconsistent");
            ECGOST3410PrivateKey eCGOST3410PrivateKey = (ECGOST3410PrivateKey)privateKey;
            ECGOST3410PublicKey eCGOST3410PublicKey = (ECGOST3410PublicKey)publicKey;
            GOST3410ParameterSpec gOST3410ParameterSpec = eCGOST3410PrivateKey.getParams();
            ECDomainParameterSpec eCDomainParameterSpec = (ECDomainParameterSpec)gOST3410ParameterSpec.getDomainParametersSpec();
            ECDomainParameterSpec eCDomainParameterSpec2 = new ECDomainParameterSpec(eCDomainParameterSpec);
            if (eCDomainParameterSpec2.getDomainParameters().getG().multiply(eCGOST3410PrivateKey.getS()).normalize().equals(eCDomainParameterSpec2.getDomainParameters().getCurve().createPoint(eCGOST3410PublicKey.getW().getAffineX(), eCGOST3410PublicKey.getW().getAffineY()))) return;
            throw new IllegalArgumentException("ECGOST3410 public key not consistent with ECGOST3410 private key");
        }
        if (!(publicKey instanceof DSTU4145Key) || !(privateKey instanceof DSTU4145Key)) throw new IllegalArgumentException("Key pair inconsistent");
        DSTU4145PrivateKey dSTU4145PrivateKey = (DSTU4145PrivateKey)privateKey;
        DSTU4145PublicKey dSTU4145PublicKey = (DSTU4145PublicKey)publicKey;
        if (!dSTU4145PrivateKey.getParams().equals(dSTU4145PublicKey.getParams())) {
            throw new IllegalArgumentException("DSTU4145 keys do not have the same domain parameters");
        }
        DSTU4145ParameterSpec dSTU4145ParameterSpec = dSTU4145PrivateKey.getParams();
        ECDomainParameterSpec eCDomainParameterSpec = new ECDomainParameterSpec(dSTU4145ParameterSpec);
        if (eCDomainParameterSpec.getDomainParameters().getG().multiply(dSTU4145PrivateKey.getS()).negate().normalize().equals(eCDomainParameterSpec.getDomainParameters().getCurve().createPoint(dSTU4145PublicKey.getW().getAffineX(), dSTU4145PublicKey.getW().getAffineY()))) return;
        throw new IllegalArgumentException("DSTU4145 public key not consistent with DSTU4145 private key");
    }

    public PublicKey getPublic() {
        return this.publicKey;
    }

    public PrivateKey getPrivate() {
        return this.privateKey;
    }
}

