/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.crypto.Cipher;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedHelper;
import org.bouncycastle.cms.CMSSignerDigestMismatchException;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.CMSVerifierCertificateNotValidException;
import org.bouncycastle.cms.CounterSignatureDigestCalculator;
import org.bouncycastle.cms.DigOutputStream;
import org.bouncycastle.cms.IntDigestCalculator;
import org.bouncycastle.cms.SigOutputStream;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.RawContentVerifier;
import org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;
import org.bouncycastle.util.Arrays;

public class SignerInformation {
    private SignerId sid;
    private SignerInfo info;
    private AlgorithmIdentifier digestAlgorithm;
    private AlgorithmIdentifier encryptionAlgorithm;
    private final ASN1Set signedAttributeSet;
    private final ASN1Set unsignedAttributeSet;
    private CMSProcessable content;
    private byte[] signature;
    private ASN1ObjectIdentifier contentType;
    private IntDigestCalculator digestCalculator;
    private byte[] resultDigest;
    private SignatureAlgorithmIdentifierFinder sigAlgFinder;
    private AttributeTable signedAttributeValues;
    private AttributeTable unsignedAttributeValues;
    private boolean isCounterSignature;

    SignerInformation(SignerInfo signerInfo, ASN1ObjectIdentifier aSN1ObjectIdentifier, CMSProcessable cMSProcessable, IntDigestCalculator intDigestCalculator, SignatureAlgorithmIdentifierFinder signatureAlgorithmIdentifierFinder) {
        this.info = signerInfo;
        this.contentType = aSN1ObjectIdentifier;
        this.sigAlgFinder = signatureAlgorithmIdentifierFinder;
        this.isCounterSignature = aSN1ObjectIdentifier == null;
        SignerIdentifier signerIdentifier = signerInfo.getSID();
        if (signerIdentifier.isTagged()) {
            ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance((Object)signerIdentifier.getId());
            this.sid = new SignerId(aSN1OctetString.getOctets());
        } else {
            IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance((Object)signerIdentifier.getId());
            this.sid = new SignerId(issuerAndSerialNumber.getName(), issuerAndSerialNumber.getSerialNumber().getValue());
        }
        this.digestAlgorithm = signerInfo.getDigestAlgorithm();
        this.signedAttributeSet = signerInfo.getAuthenticatedAttributes();
        this.unsignedAttributeSet = signerInfo.getUnauthenticatedAttributes();
        this.encryptionAlgorithm = signerInfo.getDigestEncryptionAlgorithm();
        this.signature = signerInfo.getEncryptedDigest().getOctets();
        this.content = cMSProcessable;
        this.digestCalculator = intDigestCalculator;
    }

    public boolean isCounterSignature() {
        return this.isCounterSignature;
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.contentType;
    }

    private byte[] encodeObj(DEREncodable dEREncodable) throws IOException {
        if (dEREncodable != null) {
            return dEREncodable.getDERObject().getEncoded();
        }
        return null;
    }

    public SignerId getSID() {
        return this.sid;
    }

    public int getVersion() {
        return this.info.getVersion().getValue().intValue();
    }

    public AlgorithmIdentifier getDigestAlgorithmID() {
        return this.digestAlgorithm;
    }

    public String getDigestAlgOID() {
        return this.digestAlgorithm.getObjectId().getId();
    }

    public byte[] getDigestAlgParams() {
        try {
            return this.encodeObj(this.digestAlgorithm.getParameters());
        }
        catch (Exception exception) {
            throw new RuntimeException("exception getting digest parameters " + exception);
        }
    }

    public byte[] getContentDigest() {
        if (this.resultDigest == null) {
            throw new IllegalStateException("method can only be called after verify.");
        }
        return (byte[])this.resultDigest.clone();
    }

    public String getEncryptionAlgOID() {
        return this.encryptionAlgorithm.getObjectId().getId();
    }

    public byte[] getEncryptionAlgParams() {
        try {
            return this.encodeObj(this.encryptionAlgorithm.getParameters());
        }
        catch (Exception exception) {
            throw new RuntimeException("exception getting encryption parameters " + exception);
        }
    }

    public AttributeTable getSignedAttributes() {
        if (this.signedAttributeSet != null && this.signedAttributeValues == null) {
            this.signedAttributeValues = new AttributeTable(this.signedAttributeSet);
        }
        return this.signedAttributeValues;
    }

    public AttributeTable getUnsignedAttributes() {
        if (this.unsignedAttributeSet != null && this.unsignedAttributeValues == null) {
            this.unsignedAttributeValues = new AttributeTable(this.unsignedAttributeSet);
        }
        return this.unsignedAttributeValues;
    }

    public byte[] getSignature() {
        return (byte[])this.signature.clone();
    }

    public SignerInformationStore getCounterSignatures() {
        AttributeTable attributeTable = this.getUnsignedAttributes();
        if (attributeTable == null) {
            return new SignerInformationStore(new ArrayList(0));
        }
        ArrayList<SignerInformation> arrayList = new ArrayList<SignerInformation>();
        ASN1EncodableVector aSN1EncodableVector = attributeTable.getAll((DERObjectIdentifier)CMSAttributes.counterSignature);
        for (int i = 0; i < aSN1EncodableVector.size(); ++i) {
            Attribute attribute = (Attribute)aSN1EncodableVector.get(i);
            ASN1Set aSN1Set = attribute.getAttrValues();
            if (aSN1Set.size() < 1) {
                // empty if block
            }
            Enumeration enumeration = aSN1Set.getObjects();
            while (enumeration.hasMoreElements()) {
                SignerInfo signerInfo = SignerInfo.getInstance(enumeration.nextElement());
                String string = CMSSignedHelper.INSTANCE.getDigestAlgName(signerInfo.getDigestAlgorithm().getObjectId().getId());
                arrayList.add(new SignerInformation(signerInfo, null, null, new CounterSignatureDigestCalculator(string, null, this.getSignature()), new DefaultSignatureAlgorithmIdentifierFinder()));
            }
        }
        return new SignerInformationStore(arrayList);
    }

    public byte[] getEncodedSignedAttributes() throws IOException {
        if (this.signedAttributeSet != null) {
            return this.signedAttributeSet.getEncoded("DER");
        }
        return null;
    }

    private boolean doVerify(PublicKey publicKey, Provider provider) throws CMSException, NoSuchAlgorithmException {
        DERObjectIdentifier dERObjectIdentifier;
        String string = CMSSignedHelper.INSTANCE.getDigestAlgName(this.getDigestAlgOID());
        String string2 = CMSSignedHelper.INSTANCE.getEncryptionAlgName(this.getEncryptionAlgOID());
        String string3 = string + "with" + string2;
        Signature signature = CMSSignedHelper.INSTANCE.getSignatureInstance(string3, provider);
        MessageDigest messageDigest = CMSSignedHelper.INSTANCE.getDigestInstance(string, provider);
        try {
            if (this.digestCalculator != null) {
                this.resultDigest = this.digestCalculator.getDigest();
            } else {
                if (this.content != null) {
                    this.content.write(new DigOutputStream(messageDigest));
                } else if (this.signedAttributeSet == null) {
                    throw new CMSException("data not encapsulated in signature - use detached constructor.");
                }
                this.resultDigest = messageDigest.digest();
            }
        }
        catch (IOException iOException) {
            throw new CMSException("can't process mime object to create signature.", iOException);
        }
        DERObject dERObject = this.getSingleValuedSignedAttribute((DERObjectIdentifier)CMSAttributes.contentType, "content-type");
        if (dERObject == null) {
            if (!this.isCounterSignature && this.signedAttributeSet != null) {
                throw new CMSException("The content-type attribute type MUST be present whenever signed attributes are present in signed-data");
            }
        } else {
            if (this.isCounterSignature) {
                throw new CMSException("[For counter signatures,] the signedAttributes field MUST NOT contain a content-type attribute");
            }
            if (!(dERObject instanceof DERObjectIdentifier)) {
                throw new CMSException("content-type attribute value not of ASN.1 type 'OBJECT IDENTIFIER'");
            }
            dERObjectIdentifier = (DERObjectIdentifier)dERObject;
            if (!dERObjectIdentifier.equals((Object)this.contentType)) {
                throw new CMSException("content-type attribute value does not match eContentType");
            }
        }
        if ((dERObject = this.getSingleValuedSignedAttribute((DERObjectIdentifier)CMSAttributes.messageDigest, "message-digest")) == null) {
            if (this.signedAttributeSet != null) {
                throw new CMSException("the message-digest signed attribute type MUST be present when there are any signed attributes present");
            }
        } else {
            if (!(dERObject instanceof ASN1OctetString)) {
                throw new CMSException("message-digest attribute value not of ASN.1 type 'OCTET STRING'");
            }
            dERObjectIdentifier = (ASN1OctetString)dERObject;
            if (!Arrays.constantTimeAreEqual((byte[])this.resultDigest, (byte[])dERObjectIdentifier.getOctets())) {
                throw new CMSSignerDigestMismatchException("message-digest attribute value does not match calculated value");
            }
        }
        if ((dERObject = this.getSignedAttributes()) != null && dERObject.getAll((DERObjectIdentifier)CMSAttributes.counterSignature).size() > 0) {
            throw new CMSException("A countersignature attribute MUST NOT be a signed attribute");
        }
        dERObjectIdentifier = this.getUnsignedAttributes();
        if (dERObjectIdentifier != null) {
            ASN1EncodableVector aSN1EncodableVector = dERObjectIdentifier.getAll((DERObjectIdentifier)CMSAttributes.counterSignature);
            for (int i = 0; i < aSN1EncodableVector.size(); ++i) {
                Attribute attribute = (Attribute)aSN1EncodableVector.get(i);
                if (attribute.getAttrValues().size() >= 1) continue;
                throw new CMSException("A countersignature attribute MUST contain at least one AttributeValue");
            }
        }
        try {
            signature.initVerify(publicKey);
            if (this.signedAttributeSet == null) {
                if (this.digestCalculator != null) {
                    return this.verifyDigest(this.resultDigest, publicKey, this.getSignature(), provider);
                }
                if (this.content != null) {
                    this.content.write(new SigOutputStream(signature));
                }
            } else {
                signature.update(this.getEncodedSignedAttributes());
            }
            return signature.verify(this.getSignature());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key not appropriate to signature in message.", invalidKeyException);
        }
        catch (IOException iOException) {
            throw new CMSException("can't process mime object to create signature.", iOException);
        }
        catch (SignatureException signatureException) {
            throw new CMSException("invalid signature format in message: " + signatureException.getMessage(), signatureException);
        }
    }

    private boolean doVerify(SignerInformationVerifier signerInformationVerifier) throws CMSException {
        Object object;
        OutputStream outputStream;
        Object object2;
        String string = CMSSignedHelper.INSTANCE.getDigestAlgName(this.getDigestAlgOID());
        String string2 = CMSSignedHelper.INSTANCE.getEncryptionAlgName(this.getEncryptionAlgOID());
        String string3 = string + "with" + string2;
        try {
            if (this.digestCalculator != null) {
                this.resultDigest = this.digestCalculator.getDigest();
            } else {
                object2 = signerInformationVerifier.getDigestCalculator(this.getDigestAlgorithmID());
                if (this.content != null) {
                    outputStream = object2.getOutputStream();
                    this.content.write(outputStream);
                    outputStream.close();
                } else if (this.signedAttributeSet == null) {
                    throw new CMSException("data not encapsulated in signature - use detached constructor.");
                }
                this.resultDigest = object2.getDigest();
            }
        }
        catch (IOException iOException) {
            throw new CMSException("can't process mime object to create signature.", iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find algorithm: " + noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new CMSException("can't create digest calculator: " + operatorCreationException.getMessage(), operatorCreationException);
        }
        object2 = this.getSingleValuedSignedAttribute((DERObjectIdentifier)CMSAttributes.contentType, "content-type");
        if (object2 == null) {
            if (!this.isCounterSignature && this.signedAttributeSet != null) {
                throw new CMSException("The content-type attribute type MUST be present whenever signed attributes are present in signed-data");
            }
        } else {
            if (this.isCounterSignature) {
                throw new CMSException("[For counter signatures,] the signedAttributes field MUST NOT contain a content-type attribute");
            }
            if (!(object2 instanceof DERObjectIdentifier)) {
                throw new CMSException("content-type attribute value not of ASN.1 type 'OBJECT IDENTIFIER'");
            }
            outputStream = (DERObjectIdentifier)object2;
            if (!outputStream.equals(this.contentType)) {
                throw new CMSException("content-type attribute value does not match eContentType");
            }
        }
        if ((object2 = this.getSingleValuedSignedAttribute((DERObjectIdentifier)CMSAttributes.messageDigest, "message-digest")) == null) {
            if (this.signedAttributeSet != null) {
                throw new CMSException("the message-digest signed attribute type MUST be present when there are any signed attributes present");
            }
        } else {
            if (!(object2 instanceof ASN1OctetString)) {
                throw new CMSException("message-digest attribute value not of ASN.1 type 'OCTET STRING'");
            }
            outputStream = (ASN1OctetString)object2;
            if (!Arrays.constantTimeAreEqual((byte[])this.resultDigest, (byte[])outputStream.getOctets())) {
                throw new CMSSignerDigestMismatchException("message-digest attribute value does not match calculated value");
            }
        }
        if ((object2 = this.getSignedAttributes()) != null && object2.getAll((DERObjectIdentifier)CMSAttributes.counterSignature).size() > 0) {
            throw new CMSException("A countersignature attribute MUST NOT be a signed attribute");
        }
        outputStream = this.getUnsignedAttributes();
        if (outputStream != null) {
            object = outputStream.getAll((DERObjectIdentifier)CMSAttributes.counterSignature);
            for (int i = 0; i < object.size(); ++i) {
                Attribute attribute = (Attribute)object.get(i);
                if (attribute.getAttrValues().size() >= 1) continue;
                throw new CMSException("A countersignature attribute MUST contain at least one AttributeValue");
            }
        }
        try {
            object2 = signerInformationVerifier.getContentVerifier(this.sigAlgFinder.find(string3));
            outputStream = object2.getOutputStream();
            if (this.signedAttributeSet == null) {
                if (this.digestCalculator != null) {
                    if (object2 instanceof RawContentVerifier) {
                        object = (RawContentVerifier)object2;
                        if (string2.equals("RSA")) {
                            DigestInfo digestInfo = new DigestInfo(this.digestAlgorithm, this.resultDigest);
                            return object.verify(digestInfo.getDEREncoded(), this.getSignature());
                        }
                        return object.verify(this.resultDigest, this.getSignature());
                    }
                    throw new CMSException("verifier unable to process raw signature");
                }
                if (this.content != null) {
                    this.content.write(outputStream);
                }
            } else {
                outputStream.write(this.getEncodedSignedAttributes());
            }
            outputStream.close();
            return object2.verify(this.getSignature());
        }
        catch (IOException iOException) {
            throw new CMSException("can't process mime object to create signature.", iOException);
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new CMSException("can't create content verifier: " + operatorCreationException.getMessage(), operatorCreationException);
        }
    }

    private boolean isNull(DEREncodable dEREncodable) {
        return dEREncodable instanceof ASN1Null || dEREncodable == null;
    }

    private DigestInfo derDecode(byte[] byArray) throws IOException, CMSException {
        if (byArray[0] != 48) {
            throw new IOException("not a digest info object");
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        DigestInfo digestInfo = new DigestInfo((ASN1Sequence)aSN1InputStream.readObject());
        if (digestInfo.getEncoded().length != byArray.length) {
            throw new CMSException("malformed RSA signature");
        }
        return digestInfo;
    }

    private boolean verifyDigest(byte[] byArray, PublicKey publicKey, byte[] byArray2, Provider provider) throws NoSuchAlgorithmException, CMSException {
        String string = CMSSignedHelper.INSTANCE.getEncryptionAlgName(this.getEncryptionAlgOID());
        try {
            if (string.equals("RSA")) {
                Cipher cipher = CMSEnvelopedHelper.INSTANCE.createAsymmetricCipher("RSA/ECB/PKCS1Padding", provider);
                cipher.init(2, publicKey);
                DigestInfo digestInfo = this.derDecode(cipher.doFinal(byArray2));
                if (!digestInfo.getAlgorithmId().getObjectId().equals((Object)this.digestAlgorithm.getObjectId())) {
                    return false;
                }
                if (!this.isNull(digestInfo.getAlgorithmId().getParameters())) {
                    return false;
                }
                byte[] byArray3 = digestInfo.getDigest();
                return Arrays.constantTimeAreEqual((byte[])byArray, (byte[])byArray3);
            }
            if (string.equals("DSA")) {
                Signature signature = CMSSignedHelper.INSTANCE.getSignatureInstance("NONEwithDSA", provider);
                signature.initVerify(publicKey);
                signature.update(byArray);
                return signature.verify(byArray2);
            }
            throw new CMSException("algorithm: " + string + " not supported in base signatures.");
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CMSException("Exception processing signature: " + generalSecurityException, generalSecurityException);
        }
        catch (IOException iOException) {
            throw new CMSException("Exception decoding signature: " + iOException, iOException);
        }
    }

    public boolean verify(PublicKey publicKey, String string) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.verify(publicKey, CMSUtils.getProvider(string));
    }

    public boolean verify(PublicKey publicKey, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        this.getSigningTime();
        return this.doVerify(publicKey, provider);
    }

    public boolean verify(X509Certificate x509Certificate, String string) throws NoSuchAlgorithmException, NoSuchProviderException, CertificateExpiredException, CertificateNotYetValidException, CMSException {
        return this.verify(x509Certificate, CMSUtils.getProvider(string));
    }

    public boolean verify(X509Certificate x509Certificate, Provider provider) throws NoSuchAlgorithmException, CertificateExpiredException, CertificateNotYetValidException, CMSException {
        Time time = this.getSigningTime();
        if (time != null) {
            x509Certificate.checkValidity(time.getDate());
        }
        return this.doVerify(x509Certificate.getPublicKey(), provider);
    }

    public boolean verify(SignerInformationVerifier signerInformationVerifier) throws CMSException {
        X509CertificateHolder x509CertificateHolder;
        Time time = this.getSigningTime();
        if (signerInformationVerifier.hasAssociatedCertificate() && time != null && !(x509CertificateHolder = signerInformationVerifier.getAssociatedCertificate()).isValidOn(time.getDate())) {
            throw new CMSVerifierCertificateNotValidException("verifier not valid at signingTime");
        }
        return this.doVerify(signerInformationVerifier);
    }

    public SignerInfo toSignerInfo() {
        return this.info;
    }

    public SignerInfo toASN1Structure() {
        return this.info;
    }

    private DERObject getSingleValuedSignedAttribute(DERObjectIdentifier dERObjectIdentifier, String string) throws CMSException {
        AttributeTable attributeTable = this.getUnsignedAttributes();
        if (attributeTable != null && attributeTable.getAll(dERObjectIdentifier).size() > 0) {
            throw new CMSException("The " + string + " attribute MUST NOT be an unsigned attribute");
        }
        AttributeTable attributeTable2 = this.getSignedAttributes();
        if (attributeTable2 == null) {
            return null;
        }
        ASN1EncodableVector aSN1EncodableVector = attributeTable2.getAll(dERObjectIdentifier);
        switch (aSN1EncodableVector.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Attribute attribute = (Attribute)aSN1EncodableVector.get(0);
                ASN1Set aSN1Set = attribute.getAttrValues();
                if (aSN1Set.size() != 1) {
                    throw new CMSException("A " + string + " attribute MUST have a single attribute value");
                }
                return aSN1Set.getObjectAt(0).getDERObject();
            }
        }
        throw new CMSException("The SignedAttributes in a signerInfo MUST NOT include multiple instances of the " + string + " attribute");
    }

    private Time getSigningTime() throws CMSException {
        DERObject dERObject = this.getSingleValuedSignedAttribute((DERObjectIdentifier)CMSAttributes.signingTime, "signing-time");
        if (dERObject == null) {
            return null;
        }
        try {
            return Time.getInstance((Object)dERObject);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException("signing-time attribute value not a valid 'Time' structure");
        }
    }

    public static SignerInformation replaceUnsignedAttributes(SignerInformation signerInformation, AttributeTable attributeTable) {
        SignerInfo signerInfo = signerInformation.info;
        DERSet dERSet = null;
        if (attributeTable != null) {
            dERSet = new DERSet(attributeTable.toASN1EncodableVector());
        }
        return new SignerInformation(new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), (ASN1Set)dERSet), signerInformation.contentType, signerInformation.content, null, new DefaultSignatureAlgorithmIdentifierFinder());
    }

    public static SignerInformation addCounterSigners(SignerInformation signerInformation, SignerInformationStore signerInformationStore) {
        SignerInfo signerInfo = signerInformation.info;
        AttributeTable attributeTable = signerInformation.getUnsignedAttributes();
        ASN1EncodableVector aSN1EncodableVector = attributeTable != null ? attributeTable.toASN1EncodableVector() : new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        Iterator iterator = signerInformationStore.getSigners().iterator();
        while (iterator.hasNext()) {
            aSN1EncodableVector2.add((DEREncodable)((SignerInformation)iterator.next()).toSignerInfo());
        }
        aSN1EncodableVector.add((DEREncodable)new Attribute((DERObjectIdentifier)CMSAttributes.counterSignature, (ASN1Set)new DERSet(aSN1EncodableVector2)));
        return new SignerInformation(new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), (ASN1Set)new DERSet(aSN1EncodableVector)), signerInformation.contentType, signerInformation.content, null, new DefaultSignatureAlgorithmIdentifierFinder());
    }
}

