/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.math.BigInteger;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.selector.X509CertificateHolderSelector;
import org.bouncycastle.cms.RecipientId;

public class PKIXRecipientId
extends RecipientId {
    protected final X509CertificateHolderSelector baseSelector;

    protected PKIXRecipientId(int type, X509CertificateHolderSelector baseSelector) {
        super(type);
        this.baseSelector = baseSelector;
    }

    protected PKIXRecipientId(int type, X500Name issuer, BigInteger serialNumber, byte[] subjectKeyId) {
        this(type, new X509CertificateHolderSelector(issuer, serialNumber, subjectKeyId));
    }

    public X500Name getIssuer() {
        return this.baseSelector.getIssuer();
    }

    public BigInteger getSerialNumber() {
        return this.baseSelector.getSerialNumber();
    }

    public byte[] getSubjectKeyIdentifier() {
        return this.baseSelector.getSubjectKeyIdentifier();
    }

    @Override
    public Object clone() {
        return new PKIXRecipientId(this.getType(), this.baseSelector);
    }

    public int hashCode() {
        return this.baseSelector.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof PKIXRecipientId)) {
            return false;
        }
        PKIXRecipientId id = (PKIXRecipientId)o;
        return this.baseSelector.equals(id.baseSelector);
    }

    public boolean match(Object obj) {
        return this.baseSelector.match(obj);
    }
}

