/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.CryptoServiceProperties;
import org.bouncycastle.crypto.CryptoServicePurpose;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.SavableDigest;
import org.bouncycastle.crypto.digests.Utils;
import org.bouncycastle.util.Memoable;
import org.bouncycastle.util.dispose.NativeDisposer;
import org.bouncycastle.util.dispose.NativeReference;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class SHA224NativeDigest
implements SavableDigest {
    private final CryptoServicePurpose purpose;
    protected DigestRefWrapper nativeRef = null;

    SHA224NativeDigest(CryptoServicePurpose cryptoServicePurpose) {
        this.purpose = cryptoServicePurpose;
        this.nativeRef = new DigestRefWrapper(SHA224NativeDigest.makeNative());
        this.reset();
        CryptoServicesRegistrar.checkConstraints(this.cryptoServiceProperties());
    }

    SHA224NativeDigest() {
        this(CryptoServicePurpose.ANY);
    }

    SHA224NativeDigest(SHA224NativeDigest sHA224NativeDigest) {
        this(CryptoServicePurpose.ANY);
        byte[] byArray = sHA224NativeDigest.getEncodedState();
        SHA224NativeDigest.restoreFullState(this.nativeRef.getReference(), byArray, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SHA224NativeDigest restoreState(byte[] byArray, int n) {
        SHA224NativeDigest sHA224NativeDigest = this;
        synchronized (sHA224NativeDigest) {
            SHA224NativeDigest.restoreFullState(this.nativeRef.getReference(), byArray, n);
            return this;
        }
    }

    @Override
    public String getAlgorithmName() {
        return "SHA-224";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDigestSize() {
        SHA224NativeDigest sHA224NativeDigest = this;
        synchronized (sHA224NativeDigest) {
            return SHA224NativeDigest.getDigestSize(this.nativeRef.getReference());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(byte by) {
        SHA224NativeDigest sHA224NativeDigest = this;
        synchronized (sHA224NativeDigest) {
            SHA224NativeDigest.update(this.nativeRef.getReference(), by);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(byte[] byArray, int n, int n2) {
        SHA224NativeDigest sHA224NativeDigest = this;
        synchronized (sHA224NativeDigest) {
            SHA224NativeDigest.update(this.nativeRef.getReference(), byArray, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doFinal(byte[] byArray, int n) {
        SHA224NativeDigest sHA224NativeDigest = this;
        synchronized (sHA224NativeDigest) {
            return SHA224NativeDigest.doFinal(this.nativeRef.getReference(), byArray, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        SHA224NativeDigest sHA224NativeDigest = this;
        synchronized (sHA224NativeDigest) {
            SHA224NativeDigest.reset(this.nativeRef.getReference());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getByteLength() {
        SHA224NativeDigest sHA224NativeDigest = this;
        synchronized (sHA224NativeDigest) {
            return SHA224NativeDigest.getByteLength(this.nativeRef.getReference());
        }
    }

    @Override
    public Memoable copy() {
        return new SHA224NativeDigest(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset(Memoable memoable) {
        SHA224NativeDigest sHA224NativeDigest = this;
        synchronized (sHA224NativeDigest) {
            SHA224NativeDigest sHA224NativeDigest2 = (SHA224NativeDigest)memoable;
            SHA224NativeDigest.restoreFullState(this.nativeRef.getReference(), sHA224NativeDigest2.getEncodedState(), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getEncodedState() {
        SHA224NativeDigest sHA224NativeDigest = this;
        synchronized (sHA224NativeDigest) {
            int n = SHA224NativeDigest.encodeFullState(this.nativeRef.getReference(), null, 0);
            byte[] byArray = new byte[n];
            SHA224NativeDigest.encodeFullState(this.nativeRef.getReference(), byArray, 0);
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreFullState(byte[] byArray, int n) {
        SHA224NativeDigest sHA224NativeDigest = this;
        synchronized (sHA224NativeDigest) {
            SHA224NativeDigest.restoreFullState(this.nativeRef.getReference(), byArray, n);
        }
    }

    public String toString() {
        return "SHA224[Native]()";
    }

    static native long makeNative();

    static native void destroy(long var0);

    static native int getDigestSize(long var0);

    static native void update(long var0, byte var2);

    static native void update(long var0, byte[] var2, int var3, int var4);

    static native int doFinal(long var0, byte[] var2, int var3);

    static native void reset(long var0);

    static native int getByteLength(long var0);

    static native int encodeFullState(long var0, byte[] var2, int var3);

    static native void restoreFullState(long var0, byte[] var2, int var3);

    protected CryptoServiceProperties cryptoServiceProperties() {
        return Utils.getDefaultProperties(this, 224, this.purpose);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class DigestRefWrapper
    extends NativeReference {
        public DigestRefWrapper(long l) {
            super(l, "SHA224");
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class Disposer
    extends NativeDisposer {
        Disposer(long l) {
            super(l);
        }

        @Override
        protected void dispose(long l) {
            SHA224NativeDigest.destroy(l);
        }
    }
}

