/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509KeyManager;
import org.bouncycastle.jsse.BCX509Key;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.tls.TlsUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvX509Key
implements BCX509Key {
    private final PrivateKey privateKey;
    private final X509Certificate[] certificateChain;

    static ProvX509Key from(X509KeyManager x509KeyManager, String alias) {
        if (null == x509KeyManager) {
            throw new NullPointerException("'x509KeyManager' cannot be null");
        }
        if (null == alias) {
            return null;
        }
        PrivateKey privateKey = x509KeyManager.getPrivateKey(alias);
        if (null == privateKey) {
            return null;
        }
        Object[] certificateChain = x509KeyManager.getCertificateChain(alias);
        if (TlsUtils.isNullOrEmpty(certificateChain)) {
            return null;
        }
        if (JsseUtils.containsNull(certificateChain = (X509Certificate[])certificateChain.clone())) {
            return null;
        }
        return new ProvX509Key(privateKey, (X509Certificate[])certificateChain);
    }

    ProvX509Key(PrivateKey privateKey, X509Certificate[] certificateChain) {
        this.privateKey = privateKey;
        this.certificateChain = certificateChain;
    }

    public X509Certificate[] getCertificateChain() {
        return (X509Certificate[])this.certificateChain.clone();
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }
}

