/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.lang.ref.SoftReference;
import java.net.Socket;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.BCSNIHostName;
import org.bouncycastle.jsse.BCX509ExtendedKeyManager;
import org.bouncycastle.jsse.BCX509Key;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.KeyStoreUtil;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvAlgorithmChecker;
import org.bouncycastle.jsse.provider.ProvX509Key;
import org.bouncycastle.jsse.provider.ProvX509TrustManager;
import org.bouncycastle.jsse.provider.TransportData;
import org.bouncycastle.tls.TlsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvX509KeyManager
extends BCX509ExtendedKeyManager {
    private static final Logger LOG = Logger.getLogger(ProvX509KeyManager.class.getName());
    private static final boolean provKeyManagerCheckEKU = PropertyUtils.getBooleanSystemProperty("org.bouncycastle.jsse.keyManager.checkEKU", true);
    private final AtomicLong versions = new AtomicLong();
    private final boolean isInFipsMode;
    private final JcaJceHelper helper;
    private final List<KeyStore.Builder> builders;
    private final Map<String, SoftReference<KeyStore.PrivateKeyEntry>> cachedEntries = Collections.synchronizedMap(new LinkedHashMap<String, SoftReference<KeyStore.PrivateKeyEntry>>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, SoftReference<KeyStore.PrivateKeyEntry>> eldest) {
            return this.size() > 16;
        }
    });
    private static final Map<String, PublicKeyFilter> FILTERS_CLIENT = ProvX509KeyManager.createFiltersClient();
    private static final Map<String, PublicKeyFilter> FILTERS_SERVER = ProvX509KeyManager.createFiltersServer();

    private static void addFilter(Map<String, PublicKeyFilter> filters, String keyType) {
        String algorithm = keyType;
        ProvX509KeyManager.addFilter(filters, 0, algorithm, null, keyType);
    }

    private static void addFilter(Map<String, PublicKeyFilter> filters, Class<? extends PublicKey> clazz, String ... keyTypes) {
        ProvX509KeyManager.addFilter(filters, 0, null, clazz, keyTypes);
    }

    private static void addFilter(Map<String, PublicKeyFilter> filters, int keyUsageBit, String algorithm, Class<? extends PublicKey> clazz, String ... keyTypes) {
        PublicKeyFilter filter = new PublicKeyFilter(algorithm, clazz, keyUsageBit);
        for (String keyType : keyTypes) {
            if (null == filters.put(keyType.toUpperCase(Locale.ENGLISH), filter)) continue;
            throw new IllegalStateException("Duplicate keys in filters");
        }
    }

    private static void addFilterLegacyServer(Map<String, PublicKeyFilter> filters, String algorithm, int ... keyExchangeAlgorithms) {
        ProvX509KeyManager.addFilterLegacyServer(filters, 0, algorithm, keyExchangeAlgorithms);
    }

    private static void addFilterLegacyServer(Map<String, PublicKeyFilter> filters, int keyUsageBit, String algorithm, int ... keyExchangeAlgorithms) {
        ProvX509KeyManager.addFilterLegacyServer(filters, keyUsageBit, algorithm, null, keyExchangeAlgorithms);
    }

    private static void addFilterLegacyServer(Map<String, PublicKeyFilter> filters, Class<? extends PublicKey> clazz, int ... keyExchangeAlgorithms) {
        ProvX509KeyManager.addFilterLegacyServer(filters, 0, null, clazz, keyExchangeAlgorithms);
    }

    private static void addFilterLegacyServer(Map<String, PublicKeyFilter> filters, int keyUsageBit, String algorithm, Class<? extends PublicKey> clazz, int ... keyExchangeAlgorithms) {
        ProvX509KeyManager.addFilter(filters, keyUsageBit, algorithm, clazz, ProvX509KeyManager.getKeyTypesLegacyServer(keyExchangeAlgorithms));
    }

    private static Map<String, PublicKeyFilter> createFiltersClient() {
        HashMap<String, PublicKeyFilter> filters = new HashMap<String, PublicKeyFilter>();
        ProvX509KeyManager.addFilter(filters, "Ed25519");
        ProvX509KeyManager.addFilter(filters, "Ed448");
        ProvX509KeyManager.addFilter(filters, "RSA");
        ProvX509KeyManager.addFilter(filters, "RSASSA-PSS");
        ProvX509KeyManager.addFilter(filters, DSAPublicKey.class, "DSA");
        ProvX509KeyManager.addFilter(filters, ECPublicKey.class, "EC");
        return Collections.unmodifiableMap(filters);
    }

    private static Map<String, PublicKeyFilter> createFiltersServer() {
        HashMap<String, PublicKeyFilter> filters = new HashMap<String, PublicKeyFilter>();
        ProvX509KeyManager.addFilter(filters, "Ed25519");
        ProvX509KeyManager.addFilter(filters, "Ed448");
        ProvX509KeyManager.addFilter(filters, "RSA");
        ProvX509KeyManager.addFilter(filters, "RSASSA-PSS");
        ProvX509KeyManager.addFilterLegacyServer(filters, DSAPublicKey.class, 3, 22);
        ProvX509KeyManager.addFilterLegacyServer(filters, ECPublicKey.class, 17);
        ProvX509KeyManager.addFilterLegacyServer(filters, "RSA", 5, 19, 23);
        ProvX509KeyManager.addFilterLegacyServer(filters, 2, "RSA", 1);
        return Collections.unmodifiableMap(filters);
    }

    private static String[] getKeyTypesLegacyServer(int ... keyExchangeAlgorithms) {
        int count = keyExchangeAlgorithms.length;
        String[] keyTypes = new String[count];
        for (int i = 0; i < count; ++i) {
            keyTypes[i] = JsseUtils.getKeyTypeLegacyServer(keyExchangeAlgorithms[i]);
        }
        return keyTypes;
    }

    ProvX509KeyManager(boolean isInFipsMode, JcaJceHelper helper, List<KeyStore.Builder> builders) {
        this.isInFipsMode = isInFipsMode;
        this.helper = helper;
        this.builders = builders;
    }

    @Override
    public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        return this.chooseAlias(ProvX509KeyManager.getKeyTypes(keyTypes), issuers, TransportData.from(socket), false);
    }

    @Override
    public BCX509Key chooseClientKeyBC(String[] keyTypes, Principal[] issuers, Socket socket) {
        return this.chooseKeyBC(ProvX509KeyManager.getKeyTypes(keyTypes), issuers, TransportData.from(socket), false);
    }

    @Override
    public String chooseEngineClientAlias(String[] keyTypes, Principal[] issuers, SSLEngine engine) {
        return this.chooseAlias(ProvX509KeyManager.getKeyTypes(keyTypes), issuers, TransportData.from(engine), false);
    }

    @Override
    public BCX509Key chooseEngineClientKeyBC(String[] keyTypes, Principal[] issuers, SSLEngine engine) {
        return this.chooseKeyBC(ProvX509KeyManager.getKeyTypes(keyTypes), issuers, TransportData.from(engine), false);
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseAlias(ProvX509KeyManager.getKeyTypes(keyType), issuers, TransportData.from(engine), true);
    }

    @Override
    public BCX509Key chooseEngineServerKeyBC(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseKeyBC(ProvX509KeyManager.getKeyTypes(keyType), issuers, TransportData.from(engine), true);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.chooseAlias(ProvX509KeyManager.getKeyTypes(keyType), issuers, TransportData.from(socket), true);
    }

    @Override
    public BCX509Key chooseServerKeyBC(String keyType, Principal[] issuers, Socket socket) {
        return this.chooseKeyBC(ProvX509KeyManager.getKeyTypes(keyType), issuers, TransportData.from(socket), true);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        KeyStore.PrivateKeyEntry entry = this.getPrivateKeyEntry(alias);
        return null == entry ? null : (X509Certificate[])entry.getCertificateChain();
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.getAliases(ProvX509KeyManager.getKeyTypes(keyType), issuers, null, false);
    }

    @Override
    public BCX509Key getKeyBC(String alias) {
        KeyStore.PrivateKeyEntry entry = this.getPrivateKeyEntry(alias);
        if (null == entry) {
            return null;
        }
        PrivateKey privateKey = entry.getPrivateKey();
        if (null == privateKey) {
            return null;
        }
        Object[] certificateChain = JsseUtils.getX509CertificateChain(entry.getCertificateChain());
        if (TlsUtils.isNullOrEmpty(certificateChain)) {
            return null;
        }
        return new ProvX509Key(privateKey, (X509Certificate[])certificateChain);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        KeyStore.PrivateKeyEntry entry = this.getPrivateKeyEntry(alias);
        return null == entry ? null : entry.getPrivateKey();
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.getAliases(ProvX509KeyManager.getKeyTypes(keyType), issuers, null, true);
    }

    static KeyPurposeId getRequiredExtendedKeyUsage(boolean forServer) {
        return !provKeyManagerCheckEKU ? null : (forServer ? KeyPurposeId.id_kp_serverAuth : KeyPurposeId.id_kp_clientAuth);
    }

    private String chooseAlias(List<String> keyTypes, Principal[] issuers, TransportData transportData, boolean forServer) {
        Match bestMatch = this.getBestMatch(keyTypes, issuers, transportData, forServer);
        if (Match.NOTHING != bestMatch) {
            String alias = ProvX509KeyManager.getAlias(bestMatch, this.getNextVersionSuffix());
            LOG.fine("Found matching key, returning alias: " + alias);
            return alias;
        }
        LOG.fine("No matching key found");
        return null;
    }

    private BCX509Key chooseKeyBC(List<String> keyTypes, Principal[] issuers, TransportData transportData, boolean forServer) {
        Match bestMatch = this.getBestMatch(keyTypes, issuers, transportData, forServer);
        if (Match.NOTHING != bestMatch) {
            try {
                BCX509Key keyBC = this.createKeyBC(bestMatch.builderIndex, bestMatch.localAlias, bestMatch.cachedKeyStore, bestMatch.cachedCertificateChain);
                if (null != keyBC) {
                    LOG.fine("Found matching key, from alias: " + bestMatch.builderIndex + "." + bestMatch.localAlias);
                    return keyBC;
                }
            }
            catch (Exception e) {
                LOG.log(Level.FINER, "Failed to load private key", e);
            }
        }
        LOG.fine("No matching key found");
        return null;
    }

    private BCX509Key createKeyBC(int builderIndex, String localAlias, KeyStore keyStore, X509Certificate[] certificateChain) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyStore.Builder builder = this.builders.get(builderIndex);
        KeyStore.ProtectionParameter protectionParameter = builder.getProtectionParameter(localAlias);
        Key key = KeyStoreUtil.getKey(keyStore, localAlias, protectionParameter);
        if (key instanceof PrivateKey) {
            return new ProvX509Key((PrivateKey)key, certificateChain);
        }
        return null;
    }

    private String[] getAliases(List<String> keyTypes, Principal[] issuers, TransportData transportData, boolean forServer) {
        if (!this.builders.isEmpty() && !keyTypes.isEmpty()) {
            Set<Principal> uniqueIssuers = ProvX509KeyManager.getUniquePrincipals(issuers);
            BCAlgorithmConstraints algorithmConstraints = TransportData.getAlgorithmConstraints(transportData, true);
            Date atDate = new Date();
            String requestedHostName = ProvX509KeyManager.getRequestedHostName(transportData, forServer);
            List<Match> allMatches = null;
            int count = this.builders.size();
            for (int i = 0; i < count; ++i) {
                try {
                    List<Match> matches = this.getAliasesFromBuilder(i, keyTypes, uniqueIssuers, algorithmConstraints, forServer, atDate, requestedHostName);
                    allMatches = ProvX509KeyManager.addToAllMatches(allMatches, matches);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (null != allMatches && !allMatches.isEmpty()) {
                Collections.sort(allMatches);
                return ProvX509KeyManager.getAliases(allMatches, this.getNextVersionSuffix());
            }
        }
        return null;
    }

    private List<Match> getAliasesFromBuilder(int builderIndex, List<String> keyTypes, Set<Principal> uniqueIssuers, BCAlgorithmConstraints algorithmConstraints, boolean forServer, Date atDate, String requestedHostName) throws KeyStoreException {
        KeyStore.Builder builder = this.builders.get(builderIndex);
        KeyStore keyStore = builder.getKeyStore();
        List<Match> matches = null;
        Enumeration<String> en = keyStore.aliases();
        while (en.hasMoreElements()) {
            String localAlias = en.nextElement();
            Match match = this.getPotentialMatch(builderIndex, builder, keyStore, localAlias, Match.Quality.NONE, keyTypes, uniqueIssuers, algorithmConstraints, forServer, atDate, requestedHostName);
            if (null == match) continue;
            matches = ProvX509KeyManager.addToMatches(matches, match);
        }
        return matches;
    }

    private Match getBestMatch(List<String> keyTypes, Principal[] issuers, TransportData transportData, boolean forServer) {
        Match bestMatch = Match.NOTHING;
        if (!this.builders.isEmpty() && !keyTypes.isEmpty()) {
            Set<Principal> uniqueIssuers = ProvX509KeyManager.getUniquePrincipals(issuers);
            BCAlgorithmConstraints algorithmConstraints = TransportData.getAlgorithmConstraints(transportData, true);
            Date atDate = new Date();
            String requestedHostName = ProvX509KeyManager.getRequestedHostName(transportData, forServer);
            int count = this.builders.size();
            for (int i = 0; i < count; ++i) {
                try {
                    Match match = this.getBestMatchFromBuilder(i, keyTypes, uniqueIssuers, algorithmConstraints, forServer, atDate, requestedHostName);
                    if (match.compareTo(bestMatch) >= 0) continue;
                    bestMatch = match;
                    if (Match.Quality.OK != bestMatch.quality) continue;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return bestMatch;
    }

    private Match getBestMatchFromBuilder(int builderIndex, List<String> keyTypes, Set<Principal> uniqueIssuers, BCAlgorithmConstraints algorithmConstraints, boolean forServer, Date atDate, String requestedHostName) throws KeyStoreException {
        KeyStore.Builder builder = this.builders.get(builderIndex);
        KeyStore keyStore = builder.getKeyStore();
        Match bestMatch = Match.NOTHING;
        Enumeration<String> en = keyStore.aliases();
        while (en.hasMoreElements()) {
            String localAlias = en.nextElement();
            Match match = this.getPotentialMatch(builderIndex, builder, keyStore, localAlias, bestMatch.quality, keyTypes, uniqueIssuers, algorithmConstraints, forServer, atDate, requestedHostName);
            if (null == match) continue;
            bestMatch = match;
            if (Match.Quality.OK != bestMatch.quality) continue;
            break;
        }
        return bestMatch;
    }

    private String getNextVersionSuffix() {
        return "." + this.versions.incrementAndGet();
    }

    private Match getPotentialMatch(int builderIndex, KeyStore.Builder builder, KeyStore keyStore, String localAlias, Match.Quality qualityLimit, List<String> keyTypes, Set<Principal> uniqueIssuers, BCAlgorithmConstraints algorithmConstraints, boolean forServer, Date atDate, String requestedHostName) throws KeyStoreException {
        Match.Quality quality;
        X509Certificate[] chain;
        if (keyStore.isKeyEntry(localAlias) && this.isSuitableChain(chain = JsseUtils.getX509CertificateChain(keyStore.getCertificateChain(localAlias)), keyTypes, uniqueIssuers, algorithmConstraints, forServer) && (quality = ProvX509KeyManager.getCertificateQuality(chain[0], atDate, requestedHostName)).compareTo(qualityLimit) < 0) {
            return new Match(quality, builderIndex, localAlias, keyStore, chain);
        }
        return null;
    }

    private KeyStore.PrivateKeyEntry getPrivateKeyEntry(String alias) {
        KeyStore.PrivateKeyEntry cachedEntry;
        if (null == alias) {
            return null;
        }
        SoftReference<KeyStore.PrivateKeyEntry> entryRef = this.cachedEntries.get(alias);
        if (null != entryRef && null != (cachedEntry = entryRef.get())) {
            return cachedEntry;
        }
        KeyStore.PrivateKeyEntry result = this.loadPrivateKeyEntry(alias);
        if (null != result) {
            this.cachedEntries.put(alias, new SoftReference<KeyStore.PrivateKeyEntry>(result));
        }
        return result;
    }

    private boolean isSuitableChain(X509Certificate[] chain, List<String> keyTypes, Set<Principal> uniqueIssuers, BCAlgorithmConstraints algorithmConstraints, boolean forServer) {
        if (TlsUtils.isNullOrEmpty(chain) || !ProvX509KeyManager.isSuitableChainForIssuers(chain, uniqueIssuers) || !ProvX509KeyManager.isSuitableEECert(chain[0], keyTypes, algorithmConstraints, forServer)) {
            return false;
        }
        try {
            Set<X509Certificate> trustedCerts = Collections.emptySet();
            KeyPurposeId ekuOID = ProvX509KeyManager.getRequiredExtendedKeyUsage(forServer);
            int kuBit = -1;
            ProvAlgorithmChecker.checkChain(this.isInFipsMode, this.helper, algorithmConstraints, trustedCerts, chain, ekuOID, kuBit);
        }
        catch (CertPathValidatorException e) {
            return false;
        }
        return true;
    }

    private KeyStore.PrivateKeyEntry loadPrivateKeyEntry(String alias) {
        try {
            int builderIndexStart = 0;
            int builderIndexEnd = alias.indexOf(46, builderIndexStart);
            if (builderIndexEnd > builderIndexStart) {
                int builderIndex;
                int localAliasStart = builderIndexEnd + 1;
                int localAliasEnd = alias.lastIndexOf(46);
                if (localAliasEnd > localAliasStart && 0 <= (builderIndex = Integer.parseInt(alias.substring(builderIndexStart, builderIndexEnd))) && builderIndex < this.builders.size()) {
                    KeyStore.ProtectionParameter protectionParameter;
                    KeyStore.Builder builder = this.builders.get(builderIndex);
                    String localAlias = alias.substring(localAliasStart, localAliasEnd);
                    KeyStore keyStore = builder.getKeyStore();
                    KeyStore.Entry entry = keyStore.getEntry(localAlias, protectionParameter = builder.getProtectionParameter(localAlias));
                    if (entry instanceof KeyStore.PrivateKeyEntry) {
                        return (KeyStore.PrivateKeyEntry)entry;
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.FINER, "Failed to load PrivateKeyEntry: " + alias, e);
        }
        return null;
    }

    private static List<Match> addToAllMatches(List<Match> allMatches, List<Match> matches) {
        if (null != matches && !matches.isEmpty()) {
            if (null == allMatches) {
                allMatches = matches;
            } else {
                allMatches.addAll(matches);
            }
        }
        return allMatches;
    }

    private static List<Match> addToMatches(List<Match> matches, Match match) {
        if (null == matches) {
            matches = new ArrayList<Match>();
        }
        matches.add(match);
        return matches;
    }

    private static String getAlias(Match match, String versionSuffix) {
        return match.builderIndex + "." + match.localAlias + versionSuffix;
    }

    private static String[] getAliases(List<Match> matches, String versionSuffix) {
        int count = matches.size();
        int pos = 0;
        String[] result = new String[count];
        for (Match match : matches) {
            result[pos++] = ProvX509KeyManager.getAlias(match, versionSuffix);
        }
        return result;
    }

    private static Match.Quality getCertificateQuality(X509Certificate certificate, Date atDate, String requestedHostName) {
        boolean[] keyUsage;
        try {
            certificate.checkValidity(atDate);
        }
        catch (CertificateException e) {
            return Match.Quality.EXPIRED;
        }
        if (null != requestedHostName) {
            try {
                ProvX509TrustManager.checkEndpointID(requestedHostName, certificate, "HTTPS");
            }
            catch (CertificateException e) {
                return Match.Quality.MISMATCH_SNI;
            }
        }
        if ("RSA".equalsIgnoreCase(JsseUtils.getPublicKeyAlgorithm(certificate.getPublicKey())) && ProvAlgorithmChecker.supportsKeyUsage(keyUsage = certificate.getKeyUsage(), 0) && ProvAlgorithmChecker.supportsKeyUsage(keyUsage, 2)) {
            return Match.Quality.RSA_MULTI_USE;
        }
        return Match.Quality.OK;
    }

    private static List<String> getKeyTypes(String ... keyTypes) {
        if (null != keyTypes && keyTypes.length > 0) {
            ArrayList<String> result = new ArrayList<String>(keyTypes.length);
            for (String keyType : keyTypes) {
                if (null == keyType) continue;
                result.add(keyType.toUpperCase(Locale.ENGLISH));
            }
            if (!result.isEmpty()) {
                return Collections.unmodifiableList(result);
            }
        }
        return Collections.emptyList();
    }

    private static String getRequestedHostName(TransportData transportData, boolean forServer) {
        BCSNIHostName sniHostName;
        BCExtendedSSLSession sslSession;
        if (null != transportData && forServer && null != (sslSession = transportData.getHandshakeSession()) && null != (sniHostName = JsseUtils.getSNIHostName(sslSession.getRequestedServerNames()))) {
            return sniHostName.getAsciiName();
        }
        return null;
    }

    private static Set<Principal> getUniquePrincipals(Principal[] principals) {
        if (null == principals) {
            return null;
        }
        if (principals.length > 0) {
            HashSet<Principal> result = new HashSet<Principal>();
            for (int i = 0; i < principals.length; ++i) {
                Principal principal = principals[i];
                if (null == principal) continue;
                result.add(principal);
            }
            if (!result.isEmpty()) {
                return Collections.unmodifiableSet(result);
            }
        }
        return Collections.emptySet();
    }

    private static boolean isSuitableChainForIssuers(X509Certificate[] chain, Set<Principal> uniqueIssuers) {
        if (null == uniqueIssuers || uniqueIssuers.isEmpty()) {
            return true;
        }
        int pos = chain.length;
        while (--pos >= 0) {
            if (!uniqueIssuers.contains(chain[pos].getIssuerX500Principal())) continue;
            return true;
        }
        X509Certificate eeCert = chain[0];
        return eeCert.getBasicConstraints() >= 0 && uniqueIssuers.contains(eeCert.getSubjectX500Principal());
    }

    private static boolean isSuitableEECert(X509Certificate eeCert, List<String> keyTypes, BCAlgorithmConstraints algorithmConstraints, boolean forServer) {
        Map<String, PublicKeyFilter> filters = forServer ? FILTERS_SERVER : FILTERS_CLIENT;
        PublicKey publicKey = eeCert.getPublicKey();
        boolean[] keyUsage = eeCert.getKeyUsage();
        for (String keyType : keyTypes) {
            PublicKeyFilter filter = filters.get(keyType);
            if (null == filter || !filter.accepts(publicKey, keyUsage, algorithmConstraints)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class Match
    implements Comparable<Match> {
        static final Match NOTHING = new Match(Quality.NONE, -1, null, null, null);
        final Quality quality;
        final int builderIndex;
        final String localAlias;
        final KeyStore cachedKeyStore;
        final X509Certificate[] cachedCertificateChain;

        Match(Quality quality, int builderIndex, String localAlias, KeyStore cachedKeyStore, X509Certificate[] cachedCertificateChain) {
            this.quality = quality;
            this.builderIndex = builderIndex;
            this.localAlias = localAlias;
            this.cachedKeyStore = cachedKeyStore;
            this.cachedCertificateChain = cachedCertificateChain;
        }

        @Override
        public int compareTo(Match other) {
            return this.quality.compareTo(other.quality);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        static enum Quality {
            OK,
            RSA_MULTI_USE,
            MISMATCH_SNI,
            EXPIRED,
            NONE;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class PublicKeyFilter {
        final String algorithm;
        final Class<? extends PublicKey> clazz;
        final int keyUsageBit;

        PublicKeyFilter(String algorithm, Class<? extends PublicKey> clazz, int keyUsageBit) {
            this.algorithm = algorithm;
            this.clazz = clazz;
            this.keyUsageBit = keyUsageBit;
        }

        boolean accepts(PublicKey publicKey, boolean[] keyUsage, BCAlgorithmConstraints algorithmConstraints) {
            return this.appliesTo(publicKey) && ProvAlgorithmChecker.permitsKeyUsage(publicKey, keyUsage, this.keyUsageBit, algorithmConstraints);
        }

        private boolean appliesTo(PublicKey publicKey) {
            return null != this.algorithm && this.algorithm.equalsIgnoreCase(JsseUtils.getPublicKeyAlgorithm(publicKey)) || null != this.clazz && this.clazz.isInstance(publicKey);
        }
    }
}

