/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.Times;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsPeer;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoUtils;
import org.bouncycastle.tls.crypto.TlsNonceGenerator;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class AbstractTlsContext
implements TlsContext {
    private static long counter = Times.nanoTime();
    private TlsCrypto crypto;
    private int connectionEnd;
    private TlsNonceGenerator nonceGenerator;
    private SecurityParameters securityParametersHandshake = null;
    private SecurityParameters securityParametersConnection = null;
    private ProtocolVersion[] clientSupportedVersions = null;
    private ProtocolVersion clientVersion = null;
    private ProtocolVersion rsaPreMasterSecretVersion = null;
    private TlsSession session = null;
    private Object userObject = null;

    private static synchronized long nextCounterValue() {
        return ++counter;
    }

    private static TlsNonceGenerator createNonceGenerator(TlsCrypto crypto, int connectionEnd) {
        byte[] additionalSeedMaterial = new byte[16];
        Pack.longToBigEndian((long)AbstractTlsContext.nextCounterValue(), (byte[])additionalSeedMaterial, (int)0);
        Pack.longToBigEndian((long)Times.nanoTime(), (byte[])additionalSeedMaterial, (int)8);
        additionalSeedMaterial[0] = (byte)(additionalSeedMaterial[0] & 0x7F);
        additionalSeedMaterial[0] = (byte)(additionalSeedMaterial[0] | (byte)(connectionEnd << 7));
        return crypto.createNonceGenerator(additionalSeedMaterial);
    }

    AbstractTlsContext(TlsCrypto crypto, int connectionEnd) {
        this.crypto = crypto;
        this.connectionEnd = connectionEnd;
        this.nonceGenerator = AbstractTlsContext.createNonceGenerator(crypto, connectionEnd);
    }

    synchronized void handshakeBeginning(TlsPeer peer) throws IOException {
        if (null != this.securityParametersHandshake) {
            throw new TlsFatalAlert(80, "Handshake already started");
        }
        this.securityParametersHandshake = new SecurityParameters();
        this.securityParametersHandshake.entity = this.connectionEnd;
        if (null != this.securityParametersConnection) {
            throw new TlsFatalAlert(80, "Renegotiation not supported");
        }
        peer.notifyHandshakeBeginning();
    }

    synchronized void handshakeComplete(TlsPeer peer, TlsSession session) throws IOException {
        if (null == this.securityParametersHandshake) {
            throw new TlsFatalAlert(80);
        }
        this.session = session;
        this.securityParametersConnection = this.securityParametersHandshake;
        peer.notifyHandshakeComplete();
        this.securityParametersHandshake = null;
    }

    public TlsCrypto getCrypto() {
        return this.crypto;
    }

    public TlsNonceGenerator getNonceGenerator() {
        return this.nonceGenerator;
    }

    public synchronized SecurityParameters getSecurityParameters() {
        return null != this.securityParametersHandshake ? this.securityParametersHandshake : this.securityParametersConnection;
    }

    public synchronized SecurityParameters getSecurityParametersConnection() {
        return this.securityParametersConnection;
    }

    public synchronized SecurityParameters getSecurityParametersHandshake() {
        return this.securityParametersHandshake;
    }

    public ProtocolVersion[] getClientSupportedVersions() {
        return this.clientSupportedVersions;
    }

    public void setClientSupportedVersions(ProtocolVersion[] clientSupportedVersions) {
        this.clientSupportedVersions = clientSupportedVersions;
    }

    public ProtocolVersion getClientVersion() {
        return this.clientVersion;
    }

    void setClientVersion(ProtocolVersion clientVersion) {
        this.clientVersion = clientVersion;
    }

    public ProtocolVersion getRSAPreMasterSecretVersion() {
        return this.rsaPreMasterSecretVersion;
    }

    public void setRSAPreMasterSecretVersion(ProtocolVersion rsaPreMasterSecretVersion) {
        this.rsaPreMasterSecretVersion = rsaPreMasterSecretVersion;
    }

    public ProtocolVersion getServerVersion() {
        return this.getSecurityParameters().getNegotiatedVersion();
    }

    public TlsSession getResumableSession() {
        TlsSession session = this.getSession();
        if (session == null || !session.isResumable()) {
            return null;
        }
        return session;
    }

    public TlsSession getSession() {
        return this.session;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public byte[] exportChannelBinding(int channelBinding) {
        SecurityParameters securityParameters = this.getSecurityParametersConnection();
        if (null == securityParameters) {
            throw new IllegalStateException("Export of channel bindings unavailable before handshake completion");
        }
        if (TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion())) {
            return null;
        }
        switch (channelBinding) {
            case 0: {
                byte[] tlsServerEndPoint = securityParameters.getTLSServerEndPoint();
                return TlsUtils.isNullOrEmpty(tlsServerEndPoint) ? null : Arrays.clone((byte[])tlsServerEndPoint);
            }
            case 1: {
                return Arrays.clone((byte[])securityParameters.getTLSUnique());
            }
        }
        throw new UnsupportedOperationException();
    }

    public byte[] exportEarlyKeyingMaterial(String asciiLabel, byte[] context, int length) {
        SecurityParameters sp = this.getSecurityParametersHandshake();
        if (null == sp) {
            throw new IllegalStateException("Export of early key material only available during handshake");
        }
        return this.exportKeyingMaterial13(this.checkEarlyExportSecret(sp.getEarlyExporterMasterSecret()), sp.getPRFHashAlgorithm(), asciiLabel, context, length);
    }

    public byte[] exportKeyingMaterial(String asciiLabel, byte[] context, int length) {
        SecurityParameters sp = this.getSecurityParametersConnection();
        if (null == sp) {
            throw new IllegalStateException("Export of key material unavailable before handshake completion");
        }
        if (!sp.isExtendedMasterSecret()) {
            throw new IllegalStateException("Export of key material requires extended_master_secret");
        }
        if (TlsUtils.isTLSv13(sp.getNegotiatedVersion())) {
            return this.exportKeyingMaterial13(this.checkExportSecret(sp.getExporterMasterSecret()), sp.getPRFHashAlgorithm(), asciiLabel, context, length);
        }
        byte[] seed = TlsUtils.calculateExporterSeed(sp, context);
        return TlsUtils.PRF(sp, this.checkExportSecret(sp.getMasterSecret()), asciiLabel, seed, length).extract();
    }

    protected byte[] exportKeyingMaterial13(TlsSecret secret, short hashAlgorithm, String asciiLabel, byte[] context, int length) {
        if (null == context) {
            context = TlsUtils.EMPTY_BYTES;
        } else if (!TlsUtils.isValidUint16(context.length)) {
            throw new IllegalArgumentException("'context' must have length less than 2^16 (or be null)");
        }
        try {
            return TlsCryptoUtils.hkdfExpandLabel(secret, hashAlgorithm, asciiLabel, context, length).extract();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected TlsSecret checkEarlyExportSecret(TlsSecret secret) {
        if (null == secret) {
            throw new IllegalStateException("Export of early key material not available for this handshake");
        }
        return secret;
    }

    protected TlsSecret checkExportSecret(TlsSecret secret) {
        if (null == secret) {
            throw new IllegalStateException("Export of key material only available from notifyHandshakeComplete()");
        }
        return secret;
    }
}

