/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.provider;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AbstractProvider;
import org.brickred.socialauth.AuthProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.exception.ProviderStateException;
import org.brickred.socialauth.exception.ServerDataException;
import org.brickred.socialauth.exception.SocialAuthConfigurationException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.exception.UserDeniedPermissionException;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.OAuthConsumer;
import org.brickred.socialauth.util.Response;
import org.brickred.socialauth.util.Token;
import org.json.JSONArray;
import org.json.JSONObject;

public class MySpaceImpl
extends AbstractProvider
implements AuthProvider,
Serializable {
    private static final long serialVersionUID = -4074039782095430942L;
    private static final String PROPERTY_DOMAIN = "api.myspace.com";
    private static final String REQUEST_TOKEN_URL = "http://api.myspace.com/request_token";
    private static final String AUTHORIZATION_URL = "http://api.myspace.com/authorize?myspaceid.permissions=VIEWER_FULL_PROFILE_INFO|ViewFullProfileInfo|UpdateMoodStatus";
    private static final String ACCESS_TOKEN_URL = "http://api.myspace.com/access_token";
    private static final String PROFILE_URL = "http://api.myspace.com/1.0/people/@me/@self";
    private static final String CONTACTS_URL = "http://api.myspace.com/1.0/people/@me/@all";
    private static final String UPDATE_STATUS_URL = "http://api.myspace.com/1.0/statusmood/@me/@self";
    private final Log LOG = LogFactory.getLog(MySpaceImpl.class);
    private Permission scope;
    private Properties properties;
    private boolean isVerify;
    private Token requestToken;
    private Token accessToken;
    OAuthConsumer oauth;
    OAuthConfig config;

    public MySpaceImpl(Properties props) throws Exception {
        try {
            this.properties = props;
            this.config = OAuthConfig.load(this.properties, PROPERTY_DOMAIN);
        }
        catch (IllegalStateException e) {
            throw new SocialAuthConfigurationException(e);
        }
        if (this.config.get_consumerSecret().length() == 0) {
            throw new SocialAuthConfigurationException("api.myspace.com.consumer_secret value is null");
        }
        if (this.config.get_consumerKey().length() == 0) {
            throw new SocialAuthConfigurationException("api.myspace.com.consumer_key value is null");
        }
        this.oauth = new OAuthConsumer(this.config);
    }

    @Override
    public String getLoginRedirectURL(String returnTo) throws Exception {
        this.LOG.info((Object)"Determining URL for redirection");
        this.setProviderState(true);
        this.LOG.debug((Object)"Call to fetch Request Token");
        this.requestToken = this.oauth.getRequestToken(REQUEST_TOKEN_URL, returnTo);
        StringBuilder urlBuffer = this.oauth.buildAuthUrl(AUTHORIZATION_URL, this.requestToken, returnTo);
        this.LOG.info((Object)("Redirection to following URL should happen : " + urlBuffer.toString()));
        return urlBuffer.toString();
    }

    @Override
    public Profile verifyResponse(HttpServletRequest request) throws Exception {
        this.LOG.info((Object)"Verifying the authentication response from provider");
        if (request.getParameter("oauth_problem") != null && "user_refused".equals(request.getParameter("oauth_problem"))) {
            throw new UserDeniedPermissionException();
        }
        if (!this.isProviderState()) {
            throw new ProviderStateException();
        }
        if (this.requestToken == null) {
            throw new SocialAuthException("Request token is null");
        }
        String verifier = request.getParameter("oauth_verifier");
        if (verifier != null) {
            this.requestToken.setAttribute("oauth_verifier", verifier);
        }
        this.LOG.debug((Object)"Call to fetch Access Token");
        this.accessToken = this.oauth.getAccessToken(ACCESS_TOKEN_URL, this.requestToken);
        this.isVerify = true;
        return this.getUserProfile();
    }

    @Override
    public List<Contact> getContactList() throws Exception {
        String result;
        if (!this.isVerify) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        this.LOG.info((Object)"Fetching contacts from http://api.myspace.com/1.0/people/@me/@all");
        Response serviceResponse = null;
        try {
            serviceResponse = this.oauth.httpGet(CONTACTS_URL, null, this.accessToken);
        }
        catch (Exception ie) {
            throw new SocialAuthException("Failed to retrieve the contacts from http://api.myspace.com/1.0/people/@me/@all", ie);
        }
        try {
            result = serviceResponse.getResponseBodyAsString("UTF-8");
            this.LOG.debug((Object)("Contacts JSON :" + result));
        }
        catch (Exception exc) {
            throw new SocialAuthException("Failed to read contacts from  http://api.myspace.com/1.0/people/@me/@all");
        }
        JSONArray fArr = new JSONArray();
        JSONObject resObj = new JSONObject(result);
        if (!resObj.has("entry")) {
            throw new ServerDataException("Failed to parse the user Contacts json : " + result);
        }
        fArr = resObj.getJSONArray("entry");
        ArrayList<Contact> plist = new ArrayList<Contact>();
        for (int i = 0; i < fArr.length(); ++i) {
            JSONObject fObj = fArr.getJSONObject(i);
            if (!fObj.has("person")) continue;
            Contact contact = new Contact();
            JSONObject pObj = fObj.getJSONObject("person");
            if (pObj.has("displayName")) {
                contact.setDisplayName(pObj.getString("displayName"));
            }
            if (pObj.has("name")) {
                JSONObject nobj = pObj.getJSONObject("name");
                if (nobj.has("familyName")) {
                    contact.setLastName(nobj.getString("familyName"));
                }
                if (nobj.has("givenName")) {
                    contact.setFirstName(nobj.getString("givenName"));
                }
            }
            if (pObj.has("profileUrl")) {
                contact.setProfileUrl(pObj.getString("profileUrl"));
            }
            plist.add(contact);
        }
        return plist;
    }

    @Override
    public void updateStatus(String msg) throws Exception {
        if (!this.isVerify) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        if (msg == null || msg.trim().length() == 0) {
            throw new ServerDataException("Status cannot be blank");
        }
        this.LOG.info((Object)("Updating status " + msg + " on " + UPDATE_STATUS_URL));
        String msgBody = "{\"status\":\"" + msg + "\"}";
        Response serviceResponse = null;
        try {
            serviceResponse = this.oauth.httpPut(UPDATE_STATUS_URL, null, null, msgBody, this.accessToken, false);
        }
        catch (Exception ie) {
            throw new SocialAuthException("Failed to update status on http://api.myspace.com/1.0/statusmood/@me/@self", ie);
        }
        this.LOG.info((Object)("Update Status Response :" + serviceResponse.getStatus()));
    }

    @Override
    public void logout() {
        this.requestToken = null;
        this.accessToken = null;
    }

    @Override
    public void setPermission(Permission p) {
        this.LOG.debug((Object)("Permission requested : " + p.toString()));
        this.scope = p;
    }

    private Profile getUserProfile() throws Exception {
        String result;
        this.LOG.debug((Object)"Obtaining user profile");
        Profile profile = new Profile();
        Response serviceResponse = null;
        try {
            serviceResponse = this.oauth.httpGet(PROFILE_URL, null, this.accessToken);
        }
        catch (Exception e) {
            throw new SocialAuthException("Failed to retrieve the user profile from  http://api.myspace.com/1.0/people/@me/@self");
        }
        if (serviceResponse.getStatus() != 200) {
            throw new SocialAuthException("Failed to retrieve the user profile from  http://api.myspace.com/1.0/people/@me/@self. Staus :" + serviceResponse.getStatus());
        }
        try {
            result = serviceResponse.getResponseBodyAsString("UTF-8");
            this.LOG.debug((Object)("User Profile :" + result));
        }
        catch (Exception exc) {
            throw new SocialAuthException("Failed to read response from  http://api.myspace.com/1.0/people/@me/@self");
        }
        JSONObject pObj = new JSONObject();
        JSONObject jobj = new JSONObject(result);
        if (!jobj.has("person")) {
            throw new ServerDataException("Failed to parse the user profile json : " + result);
        }
        pObj = jobj.getJSONObject("person");
        if (pObj.has("displayName")) {
            profile.setDisplayName(pObj.getString("displayName"));
        }
        if (pObj.has("id")) {
            profile.setValidatedId(pObj.getString("id"));
        }
        if (pObj.has("name")) {
            JSONObject nobj = pObj.getJSONObject("name");
            if (nobj.has("familyName")) {
                profile.setLastName(nobj.getString("familyName"));
            }
            if (nobj.has("givenName")) {
                profile.setFirstName(nobj.getString("givenName"));
            }
        }
        if (pObj.has("location")) {
            profile.setLocation(pObj.getString("location"));
        }
        if (pObj.has("nickname")) {
            profile.setDisplayName(pObj.getString("nickname"));
        }
        if (pObj.has("lang")) {
            profile.setLanguage(pObj.getString("lang"));
        }
        if (pObj.has("birthdate")) {
            profile.setDob(pObj.getString("birthdate"));
        }
        if (pObj.has("thumbnailUrl")) {
            profile.setProfileImageURL(pObj.getString("thumbnailUrl"));
        }
        return profile;
    }

    @Override
    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        if (!this.isProviderState()) {
            throw new ProviderStateException();
        }
        if (!this.isVerify) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        Response response = null;
        this.LOG.debug((Object)("Calling URL : " + url));
        if (MethodType.GET.toString().equals(methodType)) {
            try {
                response = this.oauth.httpGet(url, headerParams, this.accessToken);
            }
            catch (Exception ie) {
                throw new SocialAuthException("Error while making request to URL : " + url, ie);
            }
        }
        if (MethodType.PUT.toString().equals(methodType)) {
            try {
                response = this.oauth.httpPut(url, params, headerParams, body, this.accessToken);
            }
            catch (Exception e) {
                throw new SocialAuthException("Error while making request to URL : " + url, e);
            }
        }
        if (MethodType.POST.toString().equals(methodType)) {
            try {
                response = this.oauth.httpPost(url, params, headerParams, body, this.accessToken);
            }
            catch (Exception e) {
                throw new SocialAuthException("Error while making request to URL : " + url, e);
            }
        }
        return response;
    }
}

