/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.util;

import java.io.Serializable;
import java.util.Properties;
import org.brickred.socialauth.util.MethodType;

public class OAuthConfig
implements Serializable {
    private static final long serialVersionUID = 7574560869168900919L;
    private final String _consumerKey;
    private final String _consumerSecret;
    private final String _signatureMethod;
    private final String _transportName;

    public static OAuthConfig load(Properties props, String domain) {
        String consumerKey = props.getProperty(domain + ".consumer_key");
        if (consumerKey == null) {
            throw new IllegalStateException(domain + ".consumer_key not found.");
        }
        String consumerSecret = props.getProperty(domain + ".consumer_secret");
        if (consumerSecret == null) {
            throw new IllegalStateException(domain + ".consumer_secret not found.");
        }
        String signatureMethod = props.getProperty(domain + ".signature_method");
        String transportName = props.getProperty(domain + ".transport_name");
        return new OAuthConfig(consumerKey, consumerSecret, signatureMethod, transportName);
    }

    public OAuthConfig(String consumerKey, String consumerSecret, String signatureMethod, String transportName) {
        this._consumerKey = consumerKey;
        this._consumerSecret = consumerSecret;
        this._signatureMethod = signatureMethod == null || signatureMethod.length() == 0 ? "HMAC-SHA1" : signatureMethod;
        this._transportName = transportName == null || transportName.length() == 0 ? MethodType.GET.toString() : transportName;
    }

    public String get_consumerKey() {
        return this._consumerKey;
    }

    public String get_consumerSecret() {
        return this._consumerSecret;
    }

    public String get_signatureMethod() {
        return this._signatureMethod;
    }

    public String get_transportName() {
        return this._transportName;
    }
}

