/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.util;

import java.io.File;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLParseUtil {
    public static String getElementData(Node node) {
        StringBuffer ret = new StringBuffer();
        if (node != null) {
            for (Node text = node.getFirstChild(); text != null; text = text.getNextSibling()) {
                if (text.getNodeType() == 3 || text.getNodeType() == 4) {
                    ret.append(text.getNodeValue());
                    continue;
                }
                if (text.getNodeType() != 5) continue;
                ret.append(XMLParseUtil.getElementData(text));
            }
        }
        return ret.toString();
    }

    public static String getElementData(Element root, String elementName) {
        NodeList nodes = root.getElementsByTagName(elementName);
        if (nodes.getLength() < 1) {
            return null;
        }
        return XMLParseUtil.getElementData(nodes.item(0));
    }

    public static Element loadXmlResource(String fileName) throws Exception {
        File file = new File(fileName);
        DocumentBuilder db = XMLParseUtil.getDocumentBuilder();
        Document doc = db.parse(file);
        return doc.getDocumentElement();
    }

    public static Element loadXmlResource(InputStream in) throws Exception {
        DocumentBuilder db = XMLParseUtil.getDocumentBuilder();
        Document doc = db.parse(in);
        return doc.getDocumentElement();
    }

    public static DocumentBuilder getDocumentBuilder() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(false);
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }
}

