/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.provider;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AbstractProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.exception.AccessTokenExpireException;
import org.brickred.socialauth.exception.ServerDataException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.oauthstrategy.OAuth2;
import org.brickred.socialauth.oauthstrategy.OAuthStrategyBase;
import org.brickred.socialauth.util.AccessGrant;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.Response;
import org.json.JSONObject;

public class AmazonImpl
extends AbstractProvider {
    private static final long serialVersionUID = -4484000112933480313L;
    private static final String PROFILE_URL = "https://api.amazon.com/user/profile";
    private static final Map<String, String> ENDPOINTS;
    private final Log LOG = LogFactory.getLog(AmazonImpl.class);
    private Permission scope;
    private OAuthConfig config;
    private Profile userProfile;
    private AccessGrant accessGrant;
    private OAuthStrategyBase authenticationStrategy;
    private String state;
    private static final String[] AuthPerms;

    static {
        AuthPerms = new String[]{"profile", "postal_code"};
        ENDPOINTS = new HashMap<String, String>();
        ENDPOINTS.put("authorizationURL", "https://www.amazon.com/ap/oa");
        ENDPOINTS.put("accessTokenURL", "https://api.amazon.com/auth/o2/token");
    }

    public AmazonImpl(OAuthConfig providerConfig) throws Exception {
        this.config = providerConfig;
        this.state = "SocialAuth" + System.currentTimeMillis();
        if (this.config.getCustomPermissions() != null) {
            this.scope = Permission.CUSTOM;
        }
        if (this.config.getAuthenticationUrl() != null) {
            ENDPOINTS.put("authorizationURL", this.config.getAuthenticationUrl());
        } else {
            this.config.setAuthenticationUrl(ENDPOINTS.get("authorizationURL"));
        }
        if (this.config.getAccessTokenUrl() != null) {
            ENDPOINTS.put("accessTokenURL", this.config.getAccessTokenUrl());
        } else {
            this.config.setAccessTokenUrl(ENDPOINTS.get("accessTokenURL"));
        }
        this.authenticationStrategy = new OAuth2(this.config, ENDPOINTS);
        this.authenticationStrategy.setPermission(this.scope);
        this.authenticationStrategy.setScope(this.getScope());
    }

    @Override
    public void setAccessGrant(AccessGrant accessGrant) throws AccessTokenExpireException, SocialAuthException {
        this.accessGrant = accessGrant;
        this.authenticationStrategy.setAccessGrant(accessGrant);
    }

    @Override
    public String getLoginRedirectURL(String successUrl) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("state", this.state);
        return this.authenticationStrategy.getLoginRedirectURL(successUrl, map);
    }

    @Override
    public Profile verifyResponse(Map<String, String> requestParams) throws Exception {
        String stateStr;
        if (requestParams.containsKey("state") && !this.state.equals(stateStr = requestParams.get("state"))) {
            throw new SocialAuthException("State parameter value does not match with expected value");
        }
        return this.doVerifyResponse(requestParams);
    }

    private Profile doVerifyResponse(Map<String, String> requestParams) throws Exception {
        this.LOG.info((Object)"Verifying the authentication response from provider");
        this.accessGrant = this.authenticationStrategy.verifyResponse(requestParams, MethodType.POST.toString());
        return this.getProfile();
    }

    private Profile getProfile() throws Exception {
        String presp;
        try {
            Response response = this.authenticationStrategy.executeFeed(PROFILE_URL);
            presp = response.getResponseBodyAsString("UTF-8");
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while getting profile from https://api.amazon.com/user/profile", e);
        }
        try {
            this.LOG.debug((Object)("User Profile : " + presp));
            JSONObject resp = new JSONObject(presp);
            Profile p = new Profile();
            p.setFullName(resp.optString("name", null));
            p.setEmail(resp.optString("email", null));
            p.setValidatedId(resp.optString("user_id", null));
            p.setLocation(resp.optString("postal_code", null));
            if (this.config.isSaveRawResponse()) {
                p.setRawResponse(presp);
            }
            p.setProviderId(this.getProviderId());
            if (this.config.isSaveRawResponse()) {
                p.setRawResponse(presp);
            }
            this.userProfile = p;
            return p;
        }
        catch (Exception ex) {
            throw new ServerDataException("Failed to parse the user profile json : " + presp, ex);
        }
    }

    @Override
    public Response updateStatus(String msg) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for Amazon");
        throw new SocialAuthException("Update Status is not implemented for Amazon");
    }

    @Override
    public List<Contact> getContactList() throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for Amazon");
        throw new SocialAuthException("Get contact list is not implemented for Amazon");
    }

    @Override
    public void logout() {
        this.accessGrant = null;
        this.authenticationStrategy.logout();
    }

    @Override
    public void setPermission(Permission p) {
        this.LOG.debug((Object)("Permission requested : " + p.toString()));
        this.scope = p;
        this.authenticationStrategy.setPermission(this.scope);
    }

    @Override
    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        this.LOG.info((Object)("Calling api function for url\t:\t" + url));
        Response response = null;
        try {
            response = this.authenticationStrategy.executeFeed(url, methodType, params, headerParams, body);
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while making request to URL : " + url, e);
        }
        return response;
    }

    @Override
    public Profile getUserProfile() throws Exception {
        if (this.userProfile == null && this.accessGrant != null) {
            this.getProfile();
        }
        return this.userProfile;
    }

    @Override
    public AccessGrant getAccessGrant() {
        return this.accessGrant;
    }

    @Override
    public String getProviderId() {
        return this.config.getId();
    }

    @Override
    public Response uploadImage(String message, String fileName, InputStream inputStream) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for Amazon");
        throw new SocialAuthException("Upload Image is not implemented for Amazon");
    }

    @Override
    protected List<String> getPluginsList() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.config.getRegisteredPlugins() != null && this.config.getRegisteredPlugins().length > 0) {
            list.addAll(Arrays.asList(this.config.getRegisteredPlugins()));
        }
        return list;
    }

    @Override
    protected OAuthStrategyBase getOauthStrategy() {
        return this.authenticationStrategy;
    }

    private String getScope() {
        StringBuffer result = new StringBuffer();
        String[] arr = AuthPerms;
        if (Permission.AUTHENTICATE_ONLY.equals(this.scope)) {
            arr = AuthPerms;
        } else if (Permission.CUSTOM.equals(this.scope) && this.config.getCustomPermissions() != null) {
            arr = this.config.getCustomPermissions().split(",");
        }
        result.append(arr[0]);
        int i = 1;
        while (i < arr.length) {
            result.append(" ").append(arr[i]);
            ++i;
        }
        String pluginScopes = this.getPluginsScope(this.config);
        if (pluginScopes != null) {
            result.append(" ").append(pluginScopes);
        }
        return result.toString();
    }
}

