/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.provider;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AbstractProvider;
import org.brickred.socialauth.AuthProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.exception.AccessTokenExpireException;
import org.brickred.socialauth.exception.ServerDataException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.exception.UserDeniedPermissionException;
import org.brickred.socialauth.oauthstrategy.OAuth1;
import org.brickred.socialauth.oauthstrategy.OAuthStrategyBase;
import org.brickred.socialauth.util.AccessGrant;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.Response;
import org.brickred.socialauth.util.XMLParseUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FlickerImpl
extends AbstractProvider
implements AuthProvider,
Serializable {
    private static final long serialVersionUID = 1908393649053616794L;
    private static final String PROFILE_URL = "https://api.flickr.com/services/rest/?method=flickr.people.getInfo&user_id=%1$s&api_key=%2$s";
    private static final String CONTACT_URL = "https://api.flickr.com/services/rest/?method=flickr.contacts.getList&user_id=%1$s&api_key=%2$s";
    private static final Map<String, String> ENDPOINTS;
    private final Log LOG = LogFactory.getLog(FlickerImpl.class);
    private Permission scope;
    private boolean isVerify;
    private AccessGrant accessToken;
    private final OAuthConfig config;
    private Profile userProfile;
    private final OAuthStrategyBase authenticationStrategy;
    private static final String[] AllPerms;
    private static final String[] AuthPerms;

    static {
        AllPerms = new String[]{"delete"};
        AuthPerms = new String[]{"read"};
        ENDPOINTS = new HashMap<String, String>();
        ENDPOINTS.put("reqTokenURL", "http://www.flickr.com/services/oauth/request_token");
        ENDPOINTS.put("authorizationURL", "http://www.flickr.com/services/oauth/authorize");
        ENDPOINTS.put("accessTokenURL", "http://www.flickr.com/services/oauth/access_token");
    }

    public FlickerImpl(OAuthConfig providerConfig) throws Exception {
        this.config = providerConfig;
        if (this.config.getCustomPermissions() != null) {
            this.scope = Permission.CUSTOM;
        }
        if (this.config.getRequestTokenUrl() != null) {
            ENDPOINTS.put("reqTokenURL", this.config.getRequestTokenUrl());
        } else {
            this.config.setRequestTokenUrl(ENDPOINTS.get("reqTokenURL"));
        }
        if (this.config.getAuthenticationUrl() != null) {
            ENDPOINTS.put("authorizationURL", this.config.getAuthenticationUrl());
        } else {
            this.config.setAuthenticationUrl(ENDPOINTS.get("authorizationURL"));
        }
        if (this.config.getAccessTokenUrl() != null) {
            ENDPOINTS.put("accessTokenURL", this.config.getAccessTokenUrl());
        } else {
            this.config.setAccessTokenUrl(ENDPOINTS.get("accessTokenURL"));
        }
        this.authenticationStrategy = new OAuth1(this.config, ENDPOINTS);
        this.authenticationStrategy.setPermission(this.scope);
        this.authenticationStrategy.setScope(this.getScope());
    }

    @Override
    public void setAccessGrant(AccessGrant accessGrant) throws AccessTokenExpireException {
        this.accessToken = accessGrant;
        this.isVerify = true;
        this.authenticationStrategy.setAccessGrant(accessGrant);
    }

    @Override
    public String getLoginRedirectURL(String successUrl) throws Exception {
        this.LOG.info((Object)"Determining URL for redirection");
        return this.authenticationStrategy.getLoginRedirectURL(successUrl);
    }

    @Override
    public Profile verifyResponse(Map<String, String> requestParams) throws Exception {
        return this.doVerifyResponse(requestParams);
    }

    private Profile doVerifyResponse(Map<String, String> requestParams) throws Exception {
        this.LOG.info((Object)"Verifying the authentication response from provider");
        if (requestParams.get("denied") != null) {
            throw new UserDeniedPermissionException();
        }
        this.accessToken = this.authenticationStrategy.verifyResponse(requestParams);
        this.isVerify = true;
        return this.getProfile();
    }

    private Profile getProfile() throws Exception {
        Element p;
        NodeList pList;
        Element root;
        Profile profile = new Profile();
        String profileUrl = String.format(PROFILE_URL, this.accessToken.getAttribute("user_nsid"), this.config.get_consumerKey());
        this.LOG.info((Object)("Obtaining user profile. Profile URL : " + profileUrl));
        Response serviceResponse = null;
        try {
            serviceResponse = this.authenticationStrategy.executeFeed(profileUrl);
        }
        catch (Exception e) {
            throw new SocialAuthException("Failed to retrieve the user profile from  " + profileUrl, e);
        }
        if (serviceResponse.getStatus() != 200) {
            throw new SocialAuthException("Failed to retrieve the user profile from  " + profileUrl + ". Status :" + serviceResponse.getStatus());
        }
        try {
            root = XMLParseUtil.loadXmlResource(serviceResponse.getInputStream());
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to parse the profile from response." + profileUrl, e);
        }
        if (root != null && (pList = root.getElementsByTagName("person")) != null && pList.getLength() > 0 && (p = (Element)pList.item(0)) != null) {
            profile.setFullName(XMLParseUtil.getElementData(p, "realname"));
            profile.setDisplayName(XMLParseUtil.getElementData(p, "username"));
            profile.setCountry(XMLParseUtil.getElementData(p, "location"));
            String id = p.getAttribute("id");
            String iconfarm = p.getAttribute("iconfarm");
            String iconserver = p.getAttribute("iconserver");
            String buddyurl = "http://farm" + iconfarm + ".staticflickr.com/" + iconserver + "/buddyicons/" + id + ".jpg";
            profile.setValidatedId(id);
            if (iconserver.equalsIgnoreCase("0")) {
                profile.setProfileImageURL("http://www.flickr.com/images/buddyicon.gif");
            } else {
                profile.setProfileImageURL(buddyurl);
            }
            profile.setProviderId(this.getProviderId());
            if (this.config.isSaveRawResponse()) {
                profile.setRawResponse(XMLParseUtil.getStringFromElement(root));
            }
            this.userProfile = profile;
        }
        return profile;
    }

    @Override
    public Response updateStatus(String msg) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for Flickr");
        throw new SocialAuthException("Update Status is not implemented for Flickr");
    }

    @Override
    public List<Contact> getContactList() throws Exception {
        Element root;
        String result;
        String contactUrl = String.format(CONTACT_URL, this.accessToken.getAttribute("user_nsid"), this.config.get_consumerKey());
        this.LOG.info((Object)("Obtaining user contacts. Contact URL : " + contactUrl));
        Response serviceResponse = null;
        try {
            serviceResponse = this.authenticationStrategy.executeFeed(contactUrl);
        }
        catch (Exception e) {
            throw new SocialAuthException("Failed to retrieve contacts from  " + contactUrl, e);
        }
        if (serviceResponse.getStatus() != 200) {
            throw new SocialAuthException("Failed to retrieve contacts from  " + contactUrl + ". Status :" + serviceResponse.getStatus());
        }
        try {
            result = serviceResponse.getResponseBodyAsString("UTF-8");
        }
        catch (Exception exc) {
            throw new SocialAuthException("Failed to read response from  " + contactUrl, exc);
        }
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(result.getBytes());
            root = XMLParseUtil.loadXmlResource(is);
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to parse the user contacts xml : " + result, e);
        }
        ArrayList<Contact> contactList = new ArrayList<Contact>();
        if (root != null) {
            NodeList cList = root.getElementsByTagName("contacts");
            if (cList != null && cList.getLength() > 0) {
                Element contacts = (Element)cList.item(0);
                NodeList contactNodes = contacts.getElementsByTagName("contact");
                if (contactNodes != null && contactNodes.getLength() > 0) {
                    this.LOG.debug((Object)("Found contacts : " + contactNodes.getLength()));
                    int i = 0;
                    while (i < contactNodes.getLength()) {
                        Element contact = (Element)contactNodes.item(i);
                        String id = contact.getAttribute("nsid");
                        String userName = contact.getAttribute("username");
                        String realName = contact.getAttribute("realname");
                        String iconfarm = contact.getAttribute("iconfarm");
                        String iconserver = contact.getAttribute("iconserver");
                        String buddyurl = "http://farm" + iconfarm + ".staticflickr.com/" + iconserver + "/buddyicons/" + id + ".jpg";
                        if (id != null) {
                            Contact contactObj = new Contact();
                            if (realName != null) {
                                contactObj.setFirstName(realName);
                            }
                            if (userName != null) {
                                contactObj.setDisplayName(userName);
                            }
                            if (iconserver != null) {
                                if (iconserver.equalsIgnoreCase("0")) {
                                    contactObj.setProfileImageURL("http://www.flickr.com/images/buddyicon.gif");
                                } else {
                                    contactObj.setProfileImageURL(buddyurl);
                                }
                            }
                            contactObj.setId(id);
                            if (this.config.isSaveRawResponse()) {
                                contactObj.setRawResponse(XMLParseUtil.getStringFromElement(contact));
                            }
                            contactList.add(contactObj);
                        }
                        ++i;
                    }
                } else {
                    this.LOG.debug((Object)("No contacts were obtained from : " + contactUrl));
                }
            } else {
                this.LOG.debug((Object)("No contacts were obtained from : " + contactUrl));
            }
        }
        return contactList;
    }

    @Override
    public void logout() {
        this.accessToken = null;
        this.authenticationStrategy.logout();
    }

    @Override
    public void setPermission(Permission p) {
        this.LOG.debug((Object)("Permission requested : " + p.toString()));
        this.scope = p;
    }

    @Override
    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        if (!this.isVerify) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        Response response = null;
        this.LOG.debug((Object)("Calling URL : " + url));
        response = this.authenticationStrategy.executeFeed(url, methodType, params, headerParams, body);
        return response;
    }

    @Override
    public Profile getUserProfile() throws Exception {
        if (this.userProfile == null && this.accessToken != null) {
            this.getProfile();
        }
        return this.userProfile;
    }

    @Override
    public AccessGrant getAccessGrant() {
        return this.accessToken;
    }

    @Override
    public String getProviderId() {
        return this.config.getId();
    }

    @Override
    public Response uploadImage(String message, String fileName, InputStream inputStream) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for Flickr");
        throw new SocialAuthException("Not implemented for Flickr");
    }

    private String getScope() {
        StringBuffer result = new StringBuffer();
        String[] arr = null;
        arr = Permission.AUTHENTICATE_ONLY.equals(this.scope) ? AuthPerms : (Permission.CUSTOM.equals(this.scope) && this.config.getCustomPermissions() != null ? this.config.getCustomPermissions().split(",") : AllPerms);
        result.append(arr[0]);
        int i = 1;
        while (i < arr.length) {
            result.append(" ").append(arr[i]);
            ++i;
        }
        List<String> scopes = this.config.getPluginsScopes();
        if (scopes != null && !scopes.isEmpty()) {
            String scopesStr = scopes.get(0);
            int i2 = 1;
            while (i2 < scopes.size()) {
                scopesStr = String.valueOf(scopesStr) + " " + scopes.get(i2);
                ++i2;
            }
            result.append(" ").append(scopesStr);
        }
        String scope = null;
        if (result.length() > 0) {
            scope = "perms=" + result.toString();
        }
        return scope;
    }

    @Override
    protected List<String> getPluginsList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("org.brickred.socialauth.plugin.flickr.AlbumsPluginImpl");
        if (this.config.getRegisteredPlugins() != null && this.config.getRegisteredPlugins().length > 0) {
            list.addAll(Arrays.asList(this.config.getRegisteredPlugins()));
        }
        return list;
    }

    @Override
    protected OAuthStrategyBase getOauthStrategy() {
        return this.authenticationStrategy;
    }
}

