/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.provider;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AbstractProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.exception.AccessTokenExpireException;
import org.brickred.socialauth.exception.ServerDataException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.oauthstrategy.OAuth2;
import org.brickred.socialauth.oauthstrategy.OAuthStrategyBase;
import org.brickred.socialauth.util.AccessGrant;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.Response;
import org.json.JSONObject;

public class MendeleyImpl
extends AbstractProvider {
    private static final long serialVersionUID = -8791307959143391316L;
    private static final String PROFILE_URL = "https://api-oauth2.mendeley.com/oapi/profiles/info/me/";
    private static final Map<String, String> ENDPOINTS = new HashMap<String, String>();
    private final Log LOG = LogFactory.getLog(MendeleyImpl.class);
    private static final String SCOPE = "all";
    private Permission scope;
    private boolean isVerify;
    private AccessGrant accessToken;
    private OAuthConfig config;
    private Profile userProfile;
    private OAuthStrategyBase authenticationStrategy;

    static {
        ENDPOINTS.put("authorizationURL", "https://api-oauth2.mendeley.com/oauth/authorize/");
        ENDPOINTS.put("accessTokenURL", "https://api-oauth2.mendeley.com/oauth/token");
    }

    public MendeleyImpl(OAuthConfig providerConfig) throws Exception {
        this.config = providerConfig;
        if (this.config.getAuthenticationUrl() != null) {
            ENDPOINTS.put("authorizationURL", this.config.getAuthenticationUrl());
        } else {
            this.config.setAuthenticationUrl(ENDPOINTS.get("authorizationURL"));
        }
        if (this.config.getAccessTokenUrl() != null) {
            ENDPOINTS.put("accessTokenURL", this.config.getAccessTokenUrl());
        } else {
            this.config.setAccessTokenUrl(ENDPOINTS.get("accessTokenURL"));
        }
        this.authenticationStrategy = new OAuth2(this.config, ENDPOINTS);
        this.authenticationStrategy.setScope(SCOPE);
    }

    @Override
    public void setAccessGrant(AccessGrant accessGrant) throws AccessTokenExpireException {
        this.accessToken = accessGrant;
        this.isVerify = true;
        this.authenticationStrategy.setAccessGrant(accessGrant);
    }

    @Override
    public String getLoginRedirectURL(String successUrl) throws Exception {
        this.LOG.info((Object)"Determining URL for redirection");
        return this.authenticationStrategy.getLoginRedirectURL(successUrl);
    }

    @Override
    public Profile verifyResponse(Map<String, String> requestParams) throws Exception {
        return this.doVerifyResponse(requestParams);
    }

    private Profile doVerifyResponse(Map<String, String> requestParams) throws Exception {
        this.LOG.info((Object)"Verifying the authentication response from provider");
        this.accessToken = this.authenticationStrategy.verifyResponse(requestParams, MethodType.POST.toString());
        this.isVerify = true;
        return this.getProfile();
    }

    private Profile getProfile() throws Exception {
        String result;
        Profile profile = new Profile();
        String url = PROFILE_URL;
        this.LOG.debug((Object)("Obtaining user profile. Profile URL : " + url));
        Response serviceResponse = null;
        try {
            serviceResponse = this.authenticationStrategy.executeFeed(url);
        }
        catch (Exception e) {
            throw new SocialAuthException("Failed to retrieve the user profile from  " + url, e);
        }
        if (serviceResponse.getStatus() != 200) {
            throw new SocialAuthException("Failed to retrieve the user profile from  " + url + ". Staus :" + serviceResponse.getStatus());
        }
        try {
            result = serviceResponse.getResponseBodyAsString("UTF-8");
            this.LOG.debug((Object)("User Profile :" + result));
        }
        catch (Exception exc) {
            throw new SocialAuthException("Failed to read response from  " + url, exc);
        }
        try {
            String photo;
            JSONObject pRes = new JSONObject(result);
            JSONObject pObj = pRes.getJSONObject("main");
            profile.setValidatedId(pObj.optString("profile_id", null));
            String name = pObj.optString("name", null);
            if (name != null && name.trim().length() > 0) {
                profile.setFirstName(name);
            }
            if ((photo = pObj.optString("photo", null)) != null && photo.trim().length() > 0) {
                profile.setProfileImageURL(photo);
            }
            profile.setProviderId(this.getProviderId());
            if (this.config.isSaveRawResponse()) {
                profile.setRawResponse(result);
            }
            this.userProfile = profile;
            return profile;
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to parse the user profile json : " + result, e);
        }
    }

    @Override
    public Response updateStatus(String msg) throws Exception {
        throw new SocialAuthException("Mendeley does not support status updates");
    }

    @Override
    public List<Contact> getContactList() throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for Mendeley");
        throw new SocialAuthException("Get contact list is not implemented for Mendeley");
    }

    @Override
    public void logout() {
        this.accessToken = null;
        this.authenticationStrategy.logout();
    }

    @Override
    public void setPermission(Permission p) {
        this.LOG.debug((Object)("Permission requested : " + p.toString()));
        this.scope = p;
    }

    @Override
    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        if (!this.isVerify) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        Response response = null;
        this.LOG.debug((Object)("Calling URL : " + url));
        response = this.authenticationStrategy.executeFeed(url, methodType, params, headerParams, body);
        return response;
    }

    @Override
    public Profile getUserProfile() throws Exception {
        if (this.userProfile == null && this.accessToken != null) {
            this.getProfile();
        }
        return this.userProfile;
    }

    @Override
    public AccessGrant getAccessGrant() {
        return this.accessToken;
    }

    @Override
    public String getProviderId() {
        return this.config.getId();
    }

    @Override
    public Response uploadImage(String message, String fileName, InputStream inputStream) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for Mendeley");
        throw new SocialAuthException("Upload Image is not implemented for Mendeley");
    }

    @Override
    protected List<String> getPluginsList() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.config.getRegisteredPlugins() != null && this.config.getRegisteredPlugins().length > 0) {
            list.addAll(Arrays.asList(this.config.getRegisteredPlugins()));
        }
        return list;
    }

    @Override
    protected OAuthStrategyBase getOauthStrategy() {
        return this.authenticationStrategy;
    }
}

