/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.provider;

import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AbstractProvider;
import org.brickred.socialauth.AuthProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.exception.AccessTokenExpireException;
import org.brickred.socialauth.exception.ProviderStateException;
import org.brickred.socialauth.exception.ServerDataException;
import org.brickred.socialauth.exception.SocialAuthConfigurationException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.exception.UserDeniedPermissionException;
import org.brickred.socialauth.oauthstrategy.OAuthStrategyBase;
import org.brickred.socialauth.util.AccessGrant;
import org.brickred.socialauth.util.BirthDate;
import org.brickred.socialauth.util.HttpUtil;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.Response;
import org.brickred.socialauth.util.SocialAuthUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class YammerImpl
extends AbstractProvider
implements AuthProvider,
Serializable {
    private static final long serialVersionUID = 8671863515161132392L;
    private static final String AUTHORIZATION_URL = "https://www.yammer.com/dialog/oauth?client_id=%1$s&redirect_uri=%2$s";
    private static final String ACCESS_TOKEN_URL = "https://www.yammer.com/oauth2/access_token.json?client_id=%1$s&client_secret=%2$s&code=%3$s";
    private static final String UPDATE_STATUS_URL = "https://www.yammer.com/api/v1/messages.json";
    private static final String PROFILE_URL = "https://www.yammer.com/api/v1/users/%1$s.json?access_token=%2$s";
    private static final String CONTACTS_URL = "https://www.yammer.com/api/v1/users.json?sort_by=followers&access_token=%1$s";
    private final Log LOG = LogFactory.getLog(YammerImpl.class);
    private String accessToken;
    private String successUrl;
    private boolean isVerify;
    private OAuthConfig config;
    private Permission scope;
    private AccessGrant accessGrant;
    private Profile userProfile;
    private String profileId;
    private boolean providerState = false;

    public YammerImpl(OAuthConfig providerConfig) throws Exception {
        this.config = providerConfig;
        if (this.config.getCustomPermissions() != null) {
            this.scope = Permission.CUSTOM;
        }
    }

    @Override
    public void setAccessGrant(AccessGrant accessGrant) throws AccessTokenExpireException {
        this.accessGrant = accessGrant;
        this.accessToken = accessGrant.getKey();
        this.isVerify = true;
    }

    @Override
    public String getLoginRedirectURL(String successUrl) throws Exception {
        this.LOG.info((Object)"Determining URL for redirection");
        this.providerState = true;
        try {
            this.successUrl = URLEncoder.encode(successUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.successUrl = successUrl;
        }
        String url = String.format(AUTHORIZATION_URL, this.config.get_consumerKey(), this.successUrl);
        String scopeStr = this.getScope();
        if (scopeStr != null) {
            url = String.valueOf(url) + "&scope=" + scopeStr;
        }
        this.LOG.info((Object)("Redirection to following URL should happen : " + url));
        return url;
    }

    @Override
    public Profile verifyResponse(Map<String, String> requestParams) throws Exception {
        return this.doVerifyResponse(requestParams);
    }

    private Profile doVerifyResponse(Map<String, String> requestParams) throws Exception {
        Response response;
        this.LOG.info((Object)"Retrieving Access Token in verify response function");
        if (requestParams.get("error") != null && "access_denied".equals(requestParams.get("error"))) {
            throw new UserDeniedPermissionException();
        }
        if (!this.providerState) {
            throw new ProviderStateException();
        }
        String code = requestParams.get("code");
        if (code == null || code.length() == 0) {
            throw new SocialAuthException("Verification code is null");
        }
        String url = String.format(ACCESS_TOKEN_URL, this.config.get_consumerKey(), this.config.get_consumerSecret(), code);
        this.LOG.debug((Object)("Verification Code : " + code));
        try {
            response = HttpUtil.doHttpRequest(url, MethodType.GET.toString(), null, null);
        }
        catch (Exception e) {
            throw new SocialAuthException("Error in url : " + e);
        }
        String result = null;
        if (response.getStatus() == 200) {
            try {
                result = response.getResponseBodyAsString("UTF-8");
            }
            catch (Exception exc) {
                throw new SocialAuthException("Failed to parse response", exc);
            }
        }
        if (result == null || result.length() == 0) {
            String errorMessage = null;
            try {
                errorMessage = response.getErrorStreamAsString("UTF-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (errorMessage == null) {
                errorMessage = "Problem in getting Access Token. Application key or Secret key may be wrong.The server running the application should be same that was registered to get the keys.";
            }
            throw new SocialAuthConfigurationException(errorMessage);
        }
        JSONObject resp = new JSONObject(result);
        JSONObject accessTokenObject = resp.getJSONObject("access_token");
        this.accessToken = accessTokenObject.getString("token");
        this.LOG.debug((Object)("Access Token : " + this.accessToken));
        if (this.accessToken != null) {
            this.isVerify = true;
            this.accessGrant = new AccessGrant();
            this.accessGrant.setKey(this.accessToken);
            if (this.scope != null) {
                this.accessGrant.setPermission(this.scope);
            } else {
                this.accessGrant.setPermission(Permission.ALL);
            }
            if (accessTokenObject.has("user_id")) {
                this.profileId = accessTokenObject.getString("user_id");
            }
            this.accessGrant.setAttribute("profileId", this.profileId);
            this.accessGrant.setProviderId(this.getProviderId());
            return this.getProfile();
        }
        throw new SocialAuthException("Access token and expires not found from https://www.yammer.com/oauth2/access_token.json?client_id=%1$s&client_secret=%2$s&code=%3$s");
    }

    @Override
    public List<Contact> getContactList() throws Exception {
        String respStr;
        if (!this.isVerify || this.accessToken == null) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        ArrayList<Contact> plist = new ArrayList<Contact>();
        String contactURL = String.format(CONTACTS_URL, this.accessToken);
        HashMap<String, String> headerParam = new HashMap<String, String>();
        headerParam.put("Authorization", "Bearer " + this.accessToken);
        this.LOG.info((Object)("Fetching contacts from " + contactURL));
        try {
            Response response = HttpUtil.doHttpRequest(contactURL, MethodType.GET.toString(), null, headerParam);
            respStr = response.getResponseBodyAsString("UTF-8");
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while getting contacts from " + contactURL, e);
        }
        try {
            this.LOG.debug((Object)("User Contacts list in json : " + respStr));
            JSONArray resp = new JSONArray(respStr);
            int i = 0;
            while (i < resp.length()) {
                JSONObject obj = resp.getJSONObject(i);
                Contact p = new Contact();
                String name = obj.getString("full_name");
                p.setDisplayName(name);
                JSONObject userContactDetails = obj.getJSONObject("contact");
                JSONArray emailArr = userContactDetails.getJSONArray("email_addresses");
                JSONObject eobj = emailArr.getJSONObject(0);
                if (eobj.has("address")) {
                    p.setEmail(eobj.optString("address", null));
                }
                p.setId(obj.optString("id", null));
                p.setProfileUrl(obj.optString("web_url", null));
                if (this.config.isSaveRawResponse()) {
                    p.setRawResponse(obj.toString());
                }
                plist.add(p);
                ++i;
            }
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to parse the user profile json : " + respStr, e);
        }
        return plist;
    }

    @Override
    public Response updateStatus(String msg) throws Exception {
        Response serviceResponse;
        this.LOG.info((Object)("Updating status : " + msg));
        if (!this.isVerify || this.accessToken == null) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token and then update status");
        }
        if (msg == null || msg.trim().length() == 0) {
            throw new ServerDataException("Status cannot be blank");
        }
        HashMap<String, String> headerParam = new HashMap<String, String>();
        headerParam.put("Authorization", "Bearer " + this.accessToken);
        headerParam.put("Content-Type", "application/json");
        headerParam.put("Accept", "application/json");
        String msgBody = "{\"body\" : \"" + msg + "\"}";
        try {
            serviceResponse = HttpUtil.doHttpRequest(UPDATE_STATUS_URL, MethodType.POST.toString(), msgBody, headerParam);
            if (serviceResponse.getStatus() != 201) {
                throw new SocialAuthException("Status not updated. Return Status code :" + serviceResponse.getStatus());
            }
        }
        catch (Exception e) {
            throw new SocialAuthException(e);
        }
        return serviceResponse;
    }

    @Override
    public void logout() {
        this.accessToken = null;
        this.accessGrant = null;
    }

    private Profile getProfile() throws Exception {
        String result;
        Response serviceResponse;
        if (!this.isVerify || this.accessToken == null) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token and then update status");
        }
        Profile p = new Profile();
        if (this.profileId == null) {
            this.profileId = (String)this.accessGrant.getAttribute("profileId");
        }
        String profileURL = String.format(PROFILE_URL, this.profileId, this.accessToken);
        HashMap<String, String> headerParam = new HashMap<String, String>();
        headerParam.put("Authorization", "Bearer " + this.accessToken);
        try {
            serviceResponse = HttpUtil.doHttpRequest(profileURL, "GET", null, headerParam);
        }
        catch (Exception e) {
            throw new SocialAuthException("Failed to retrieve the user profile from  " + profileURL, e);
        }
        try {
            result = serviceResponse.getResponseBodyAsString("UTF-8");
            this.LOG.debug((Object)("User Profile :" + result));
        }
        catch (Exception e) {
            throw new SocialAuthException("Failed to read response from  " + profileURL, e);
        }
        try {
            JSONObject userContactDetails;
            JSONArray emailArr;
            JSONObject eobj;
            String dstr;
            JSONObject resp = new JSONObject(result);
            p.setFullName(resp.optString("full_name", null));
            p.setLocation(resp.optString("location", null));
            p.setProfileImageURL(resp.optString("mugshot_url", null));
            if (resp.has("birth_date") && (dstr = resp.getString("birth_date")) != null) {
                String[] arr = dstr.split("\\s+");
                BirthDate bd = new BirthDate();
                if (arr.length == 1) {
                    Calendar currentDate = Calendar.getInstance();
                    bd.setMonth(currentDate.get(2) + 1);
                    bd.setDay(currentDate.get(5));
                } else {
                    if (arr.length > 0) {
                        bd.setDay(Integer.parseInt(arr[1]));
                    }
                    if (arr.length > 1) {
                        bd.setMonth(new Integer(SocialAuthUtil.getMonthInInt(arr[0])));
                    }
                }
                p.setDob(bd);
            }
            if ((eobj = (emailArr = (userContactDetails = resp.getJSONObject("contact")).getJSONArray("email_addresses")).getJSONObject(0)).has("address")) {
                p.setEmail(eobj.optString("address", null));
            }
            p.setProviderId(this.getProviderId());
            if (this.config.isSaveRawResponse()) {
                p.setRawResponse(result);
            }
            this.userProfile = p;
            return this.userProfile;
        }
        catch (Exception e) {
            throw new SocialAuthException("Failed to parse the user profile json : " + result, e);
        }
    }

    @Override
    public void setPermission(Permission p) {
        this.LOG.debug((Object)("Permission requested : " + p.toString()));
        this.scope = p;
    }

    @Override
    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        Response serviceResponse;
        if (!this.isVerify || this.accessToken == null) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        HashMap<String, String> headerParam = new HashMap<String, String>();
        headerParam.put("Content-Type", "application/json");
        headerParam.put("Accept", "application/json");
        if (headerParams != null) {
            headerParam.putAll(headerParams);
        }
        headerParam.put("Authorization", "Bearer " + this.accessToken);
        this.LOG.debug((Object)("Calling URL : " + url));
        this.LOG.debug((Object)("Header Params : " + ((Object)headerParam).toString()));
        try {
            serviceResponse = HttpUtil.doHttpRequest(url, methodType, body, headerParam);
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while making request to URL : " + url, e);
        }
        if (serviceResponse.getStatus() != 200 && serviceResponse.getStatus() != 201) {
            this.LOG.debug((Object)("Return statuc for URL " + url + " is " + serviceResponse.getStatus()));
            throw new SocialAuthException("Error while making request to URL :" + url + "Status : " + serviceResponse.getStatus());
        }
        return serviceResponse;
    }

    @Override
    public Profile getUserProfile() throws Exception {
        if (this.userProfile == null && this.accessToken != null) {
            this.getProfile();
        }
        return this.userProfile;
    }

    @Override
    public AccessGrant getAccessGrant() {
        return this.accessGrant;
    }

    @Override
    public String getProviderId() {
        return this.config.getId();
    }

    @Override
    public Response uploadImage(String message, String fileName, InputStream inputStream) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for Yammer");
        throw new SocialAuthException("Upload Image is not implemented for Yammer");
    }

    private String getScope() {
        String scopeStr = null;
        if (Permission.CUSTOM.equals(this.scope)) {
            scopeStr = this.config.getCustomPermissions();
        }
        return scopeStr;
    }

    @Override
    protected List<String> getPluginsList() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.config.getRegisteredPlugins() != null && this.config.getRegisteredPlugins().length > 0) {
            list.addAll(Arrays.asList(this.config.getRegisteredPlugins()));
        }
        return list;
    }

    @Override
    protected OAuthStrategyBase getOauthStrategy() {
        return null;
    }
}

