/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.plugin.processor;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.tools.JavaFileObject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.bsc.maven.plugin.processor.ZipFileObject;
import org.bsc.maven.plugin.processor.ZipFileObjectExtracted;

public final class UnzipService {
    private final Log log;

    public static final UnzipService newInstance(Log log) {
        Objects.requireNonNull(log, "log argument is null!");
        return new UnzipService(log);
    }

    private UnzipService(Log log) {
        this.log = log;
    }

    private boolean isJavaEntry(ZipEntry entry) {
        return entry.getName().endsWith(".java");
    }

    public final void extractSourcesFromArtifact(Artifact artifact, List<JavaFileObject> allSources) {
        Objects.requireNonNull(artifact, "artifact argument is null!");
        Objects.requireNonNull(allSources, "allSources argument is null!");
        int size = allSources.size();
        File fileZip = artifact.getFile();
        try {
            ZipFile zipFile = new ZipFile(fileZip);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!this.isJavaEntry(entry)) continue;
                allSources.add(ZipFileObject.create(zipFile, entry));
            }
            this.log.info((CharSequence)String.format("Discovered [%d] java sources in artifact [%s]", allSources.size() - size, artifact));
        }
        catch (Exception ex) {
            this.log.warn((CharSequence)String.format("Problem reading source archive [%s]", fileZip.getPath()));
            this.log.debug((Throwable)ex);
        }
    }

    public final void extractSourcesFromArtifactToTempDirectory(Artifact artifact, List<JavaFileObject> allSources, Path target) {
        Objects.requireNonNull(artifact, "artifact argument is null!");
        Objects.requireNonNull(allSources, "allSources argument is null!");
        int size = allSources.size();
        File fileZip = artifact.getFile();
        if (target == null) {
            try {
                target = Files.createTempDirectory(fileZip.getName(), new FileAttribute[0]);
            }
            catch (IOException ex) {
                this.log.warn((CharSequence)"Problem creating temporary directory", (Throwable)ex);
                return;
            }
        }
        try {
            target = Files.createDirectories(Paths.get(target.toString(), artifact.getArtifactId()), new FileAttribute[0]);
        }
        catch (IOException ex) {
            this.log.warn((CharSequence)String.format("Problem creating directory [%s]", target), (Throwable)ex);
            return;
        }
        try (ZipFile zipFile = new ZipFile(fileZip);){
            byte[] buffer = new byte[4096];
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                Path newFile = Paths.get(target.toString(), zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    Files.createDirectories(newFile, new FileAttribute[0]);
                    continue;
                }
                if (!this.isJavaEntry(zipEntry)) continue;
                try (FileOutputStream fos = new FileOutputStream(newFile.toFile());){
                    InputStream zis = zipFile.getInputStream(zipEntry);
                    Throwable throwable = null;
                    try {
                        int len;
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                        allSources.add(new ZipFileObjectExtracted(newFile.toUri(), JavaFileObject.Kind.SOURCE));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (zis == null) continue;
                        UnzipService.$closeResource(throwable, zis);
                    }
                }
            }
        }
        catch (Exception ex) {
            this.log.warn((CharSequence)String.format("Problem reading source archive [%s]", fileZip));
            this.log.debug((Throwable)ex);
        }
        this.log.info((CharSequence)String.format("[%d] sources succesfully extracted from artifact [%s] to:\n [%s]", allSources.size() - size, artifact, target));
    }
}

