/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.buni.meldware.mail.util.io.Copier;

public class DotUnstuffingCopier
implements Copier {
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final byte DOT = 46;
    public static final int MIN_BLOCK_SIZE = 1024;
    private static final int TERMINAL_LENGTH = 5;
    private boolean eofsok;
    private boolean hitterm;

    public DotUnstuffingCopier() {
        this(false);
    }

    public DotUnstuffingCopier(boolean eofsok) {
        this.eofsok = eofsok;
    }

    public int copy(InputStream in, OutputStream out, int blockSize) throws IOException {
        in.markSupported();
        byte[] block = new byte[Math.max(blockSize, 1024)];
        int count = 0;
        int total = 0;
        int startOffset = 0;
        in.mark(blockSize);
        while ((count = in.read(block, startOffset, block.length - startOffset) + startOffset) != -1) {
            int idx = 0;
            startOffset = 0;
            total += count;
            int i = 0;
            while (i < count) {
                int remaining = count - i;
                switch (remaining) {
                    case 4: {
                        if (13 == block[i] && 10 == block[i + 1] && 46 == block[i + 2] && 46 == block[i + 3]) {
                            out.write(block, idx, i - idx + 3);
                            startOffset = 0;
                            i += remaining;
                            break;
                        }
                        if (13 != block[i] || 10 != block[i + 1] || 46 != block[i + 2] || 13 != block[i + 3]) break;
                        out.write(block, idx, i - idx);
                        System.arraycopy(block, i, block, 0, 4);
                        startOffset = remaining;
                        i += remaining;
                        break;
                    }
                    case 3: {
                        if (13 != block[i] || 10 != block[i + 1] || 46 != block[i + 2]) break;
                        out.write(block, idx, i - idx);
                        System.arraycopy(block, i, block, 0, remaining);
                        startOffset = remaining;
                        i += remaining;
                        break;
                    }
                    case 2: {
                        if (13 != block[i] || 10 != block[i + 1]) break;
                        out.write(block, idx, i - idx);
                        System.arraycopy(block, i, block, 0, remaining);
                        startOffset = remaining;
                        i += remaining;
                        break;
                    }
                    case 1: {
                        if (13 == block[i]) {
                            out.write(block, idx, i - idx);
                            System.arraycopy(block, i, block, 0, remaining);
                            startOffset = remaining;
                        } else {
                            out.write(block, idx, i - idx + 1);
                            startOffset = 0;
                        }
                        i += remaining;
                        break;
                    }
                    case 0: {
                        throw new RuntimeException("Unreachable");
                    }
                    default: {
                        if (13 != block[i] || 10 != block[i + 1] || 46 != block[i + 2]) break;
                        if (46 == block[i + 3]) {
                            out.write(block, idx, i - idx + 3);
                            idx = (i += 3) + 1;
                            startOffset = 0;
                            break;
                        }
                        if (13 != block[i + 3] || 10 != block[i + 4]) break;
                        if (i > idx) {
                            out.write(block, idx, i - idx);
                        }
                        in.reset();
                        in.skip(i + 5);
                        this.hitterm = true;
                        return 0;
                    }
                }
                ++i;
            }
            in.mark(blockSize);
        }
        if (this.eofsok) {
            return 0;
        }
        throw new IOException("Premature EOF, exepecting '\\r\\n.\\r\\n' to end input stream.");
    }

    public boolean hitTermination() {
        return this.hitterm;
    }
}

