/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.util.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import org.buni.meldware.common.logging.Log;

public class IOUtil {
    public static Object byteArrayToObject(byte[] data) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            ObjectInputStream oin = new ObjectInputStream(bais);
            return oin.readObject();
        }
        catch (IOException e) {
            throw new RuntimeException("Error restoring object", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Error restoring object", e);
        }
    }

    public static byte[] objectToByteArray(Object o) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(o);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Error serializing object", e);
        }
    }

    public static void quietClose(Log log, InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (Throwable t) {
                log.warn((Object)("Unable to close input stream: " + t.getMessage()));
            }
        }
    }

    public static void quietClose(Log log, OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (Throwable t) {
                log.warn((Object)("Unable to close input stream: " + t.getMessage()));
            }
        }
    }

    public static int appendLine(StringBuilder b, InputStream in, String charSet) throws IOException {
        int c;
        int numRead = 0;
        if (!in.markSupported()) {
            throw new IOException("mark(int) not support for input stream");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(128);
        while ((c = in.read()) != -1) {
            ++numRead;
            if (c == 13 || c == 10) {
                int expected = c == 13 ? 10 : 13;
                in.mark(1);
                int nextC = in.read();
                if (nextC == expected) {
                    ++numRead;
                    break;
                }
                in.reset();
                break;
            }
            out.write(c);
        }
        if (out.size() > 0) {
            b.append(out.toString(charSet));
        }
        return numRead;
    }

    public static int appendLine(StringBuilder b, PushbackInputStream in, String charSet) throws IOException {
        int c;
        int numRead = 0;
        ByteArrayOutputStream out = new ByteArrayOutputStream(128);
        while ((c = in.read()) != -1) {
            ++numRead;
            if (c == 13 || c == 10) {
                int expected = c == 13 ? 10 : 13;
                int nextC = in.read();
                if (nextC == expected) {
                    ++numRead;
                    break;
                }
                in.unread(nextC);
                break;
            }
            out.write(c);
        }
        if (out.size() > 0) {
            b.append(out.toString(charSet));
        }
        return numRead;
    }

    /*
     * Unable to fully structure code
     */
    public static byte[] parseBody(InputStream inputStream, long maxLength) throws IOException {
        dotStuffing = "\r\n.".getBytes();
        dataEnd = "\r\n.\r\n".getBytes();
        body = null;
        curIndex = 0;
        dotStuffed = false;
        buffer = new ExtByteArrayOutputStream(4096);
        inChunk = new byte[1024];
        outChunk = new byte[1024];
        outChunkIndex = 0;
        inputStream.mark(inChunk.length);
        count = inputStream.read(inChunk);
        bLast = 0;
        bRead = 0;
        while (count != -1) {
            i = 0;
            while (i < count) {
                bRead = inChunk[i];
                if (bRead != 13 && bRead != 10) {
                    dotStuffed = false;
                }
                if (bRead != 46) ** GOTO lbl-1000
                buffer.write(outChunk, 0, outChunkIndex);
                outChunkIndex = 0;
                if (buffer.endsWith(dotStuffing)) {
                    dotStuffed = true;
                    bLast = bRead;
                } else lbl-1000:
                // 2 sources

                {
                    if ((long)curIndex > maxLength) {
                        throw new IllegalStateException("Maximum message length exceeded: " + maxLength);
                    }
                    if (outChunkIndex == outChunk.length) {
                        buffer.write(outChunk, 0, outChunkIndex);
                        outChunkIndex = 0;
                    }
                    outChunk[outChunkIndex] = bRead;
                    ++outChunkIndex;
                    ++curIndex;
                    if (bRead == 10 && bLast == 13) {
                        buffer.write(outChunk, 0, outChunkIndex);
                        outChunkIndex = 0;
                        if (!dotStuffed && buffer.endsWith(dataEnd)) {
                            body = buffer.toByteArray(0, curIndex - 3);
                            inputStream.reset();
                            dummy = new byte[i];
                            inputStream.read(dummy);
                            return body;
                        }
                    }
                    bLast = bRead;
                }
                ++i;
            }
            inputStream.mark(inChunk.length);
            count = inputStream.read(inChunk);
        }
        throw new IOException("Premature EOF");
    }

    public static String toString(InputStream in, String encoding) throws IOException {
        byte[] b = new byte[8192];
        StringBuilder sb = new StringBuilder();
        int numRead = 0;
        while ((numRead = in.read(b)) != -1) {
            sb.append(new String(b, 0, numRead, encoding));
        }
        return sb.toString();
    }

    public static class ExtByteArrayOutputStream
    extends ByteArrayOutputStream {
        public ExtByteArrayOutputStream(int size) {
            super(size);
        }

        public synchronized boolean endsWith(byte[] tailBytes) {
            int tailLength = tailBytes.length;
            int offset = this.count - tailLength;
            if (offset < 0) {
                return false;
            }
            int i = 0;
            while (i < tailLength) {
                if (this.buf[offset + i] != tailBytes[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public synchronized byte[] toByteArray(int offset, int length) {
            byte[] newbuf = new byte[length];
            System.arraycopy(this.buf, offset, newbuf, 0, length);
            return newbuf;
        }
    }
}

