/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.imap4;

import java.lang.reflect.Method;
import java.util.Map;
import javax.naming.InitialContext;
import javax.net.ssl.SSLSocketFactory;
import org.buni.meldware.mail.Protocol;
import org.buni.meldware.mail.imap4.IMAP4Constants;
import org.buni.meldware.mail.imap4.IMAP4ProtocolInstance;
import org.buni.meldware.mail.imap4.IMAP4ProtocolMBean;
import org.buni.meldware.mail.mailbox.MailboxService;
import org.buni.meldware.mail.userrepository.UserRepository;
import org.jboss.security.SecurityDomain;
import org.jboss.system.ServiceMBeanSupport;
import org.w3c.dom.Element;

public class IMAP4Protocol
extends ServiceMBeanSupport
implements IMAP4ProtocolMBean,
IMAP4Constants {
    Map handlers;
    Map properties;
    private MailboxService mailboxManager;
    protected String sslDomain;
    private String servername;
    private boolean tlsEnabled;
    private boolean requireClientCert;
    private UserRepository userRepository;
    private boolean requireTls;

    public String getName() {
        return "IMAP4";
    }

    public Element getProperties() {
        return null;
    }

    public Protocol createInstance() {
        return new IMAP4ProtocolInstance(this.handlers, this.getServiceName(), this.mailboxManager);
    }

    public void setSecurityDomain(String domainName) {
        try {
            this.log.debug((Object)"setSecurityDomain()");
            this.sslDomain = domainName;
        }
        catch (RuntimeException e) {
            this.log.error((Object)"Error", (Throwable)e);
            throw e;
        }
    }

    public String getSecurityDomain() {
        return this.sslDomain;
    }

    protected void startService() throws Exception {
        this.log.debug((Object)"startService()");
    }

    private void setupSSLSocketFactory() throws RuntimeException {
        SSLSocketFactory sslSocketFactory = null;
        if (this.sslDomain != null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> sfClass;
                try {
                    sfClass = loader.loadClass("org.jboss.security.ssl.DomainSocketFactory");
                    sslSocketFactory = (SSLSocketFactory)sfClass.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not create SSLSocketFactory", e);
                }
                sfClass = sslSocketFactory.getClass();
                InitialContext ctx = new InitialContext();
                SecurityDomain domain = (SecurityDomain)ctx.lookup(this.sslDomain);
                Class[] parameterTypes = new Class[]{SecurityDomain.class};
                Method m = sfClass.getMethod("setSecurityDomain", parameterTypes);
                Object[] args = new Object[]{domain};
                m.invoke((Object)sslSocketFactory, args);
            }
            catch (NoSuchMethodException e) {
                this.log.error((Object)"Socket factory does not support setSecurityDomain(SecurityDomain)");
                throw new RuntimeException("Could not set up security for TLS", e);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to setSecurityDomain=" + this.sslDomain + " on socket factory"), (Throwable)e);
                throw new RuntimeException("Could not set up security for TLS", e);
            }
        }
        Boolean prop = (Boolean)this.properties.get("tls-enabled");
        if (prop != null && prop.booleanValue()) {
            throw new RuntimeException("tls-enabled was set to true, but no SecurityDomain was specified");
        }
        this.properties.put("SSL_SOCKET_FACTORY", sslSocketFactory);
    }

    public void setMailboxManager(MailboxService mailboxManager) {
        this.mailboxManager = mailboxManager;
    }

    public MailboxService getMailboxManager() {
        return this.mailboxManager;
    }

    public boolean isRequireClientCert() {
        return this.requireClientCert;
    }

    public void setRequireClientCert(boolean requireClientCert) {
        this.requireClientCert = requireClientCert;
    }

    public String getServername() {
        return this.servername;
    }

    public void setServername(String servername) {
        this.servername = servername;
    }

    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    public void setTlsEnabled(boolean tlsEnabled) {
        this.tlsEnabled = tlsEnabled;
    }

    public UserRepository getUserRepository() {
        return this.userRepository;
    }

    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public Class getProtocolInterfaceClass() {
        return IMAP4ProtocolMBean.class;
    }

    public String getSslDomain() {
        return this.getSecurityDomain();
    }

    public boolean isRequireTls() {
        return this.requireTls;
    }

    public void setRequireTls(boolean requireTls) {
        this.requireTls = requireTls;
    }

    public void setSslDomain(String sslDomain) {
        this.setSecurityDomain(sslDomain);
    }
}

