/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.imap4.commands;

import org.buni.meldware.mail.api.FolderExistsException;
import org.buni.meldware.mail.api.Mailbox;
import org.buni.meldware.mail.imap4.IMAP4Response;
import org.buni.meldware.mail.imap4.commands.AbstractImapCommand;

public class CreateCommand
extends AbstractImapCommand {
    String _folder;

    public CreateCommand() {
        super("CREATE");
    }

    public boolean isValidForState() {
        return this.getProtocolInstance().getState() == 1;
    }

    public IMAP4Response execute() {
        IMAP4Response res = this.constructResponse();
        String[] path = this.getFolder().split("/");
        Mailbox mailbox = this.getProtocolInstance().getMailboxProxy();
        try {
            mailbox.createFolder(path);
            this.taggedSimpleSuccess();
        }
        catch (FolderExistsException e) {
            this.taggedResponse("NO create failure: %s", e.getMessage());
        }
        this.flush();
        return res;
    }

    public String getFolder() {
        return this._folder;
    }

    public void setFolder(String mailbox) {
        this._folder = mailbox;
    }
}

