/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.imap4.commands.fetch;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.buni.meldware.mail.api.FolderMessage;
import org.buni.meldware.mail.imap4.commands.fetch.SearchPart;

public class DateArgSearchPart
extends SearchPart {
    String argument;

    public boolean includes(FolderMessage msg) {
        System.err.println("Type: " + this.getType());
        if (this.getType().equals("BEFORE")) {
            return this.handleBefore(msg);
        }
        if (this.getType().equals("ON")) {
            return this.handleOn(msg);
        }
        if (this.getType().equals("SINCE")) {
            return this.handleSince(msg);
        }
        if (this.getType().equals("SENTBEFORE")) {
            return this.handleSentBefore(msg);
        }
        if (this.getType().equals("SENTON")) {
            return this.handleSentOn(msg);
        }
        if (this.getType().equals("SENTSINCE")) {
            return this.handleSentSince(msg);
        }
        return false;
    }

    private boolean handleBefore(FolderMessage msg) {
        Calendar emailDate = this.dateFromTimestamp(msg.getTimestamp());
        Calendar queryDate = this.dateFromString(this.getArgument());
        return emailDate != null && queryDate != null && emailDate.compareTo(queryDate) < 0;
    }

    private boolean handleOn(FolderMessage msg) {
        Calendar emailDate = this.dateFromTimestamp(msg.getTimestamp());
        Calendar queryDate = this.dateFromString(this.getArgument());
        return emailDate != null && queryDate != null && emailDate.compareTo(queryDate) == 0;
    }

    private boolean handleSince(FolderMessage msg) {
        Calendar emailDate = this.dateFromTimestamp(msg.getTimestamp());
        Calendar queryDate = this.dateFromString(this.getArgument());
        return emailDate != null && queryDate != null && emailDate.compareTo(queryDate) >= 0;
    }

    private boolean handleSentBefore(FolderMessage msg) {
        Calendar emailDate = this.dateFromString(msg.getHeader("Date"));
        Calendar queryDate = this.dateFromString(this.getArgument());
        return emailDate != null && queryDate != null && emailDate.compareTo(queryDate) < 0;
    }

    private boolean handleSentOn(FolderMessage msg) {
        Calendar emailDate = this.dateFromString(msg.getHeader("Date"));
        Calendar queryDate = this.dateFromString(this.getArgument());
        return emailDate != null && queryDate != null && emailDate.compareTo(queryDate) == 0;
    }

    private boolean handleSentSince(FolderMessage msg) {
        Calendar emailDate = this.dateFromString(msg.getHeader("Date"));
        Calendar queryDate = this.dateFromString(this.getArgument());
        return emailDate != null && queryDate != null && emailDate.compareTo(queryDate) >= 0;
    }

    private Calendar dateFromTimestamp(Date timestamp) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(timestamp);
        int day = cal.get(5);
        int month = cal.get(2);
        int year = cal.get(1);
        System.err.println("Year: " + year + ", Month: " + month + ", Day: " + day);
        cal.clear();
        cal.set(year, month, day);
        return cal;
    }

    private Calendar dateFromString(String dateString) {
        SimpleDateFormat df = new SimpleDateFormat();
        ParsePosition pp = new ParsePosition(0);
        df.applyPattern("dd-MMM-yyyy");
        Date d = df.parse(dateString, pp);
        if (d == null) {
            df.applyPattern("E, dd MMM yyyy ");
            d = df.parse(dateString, pp);
        }
        if (d == null) {
            System.err.println("Could not interpret date: " + dateString);
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        int day = cal.get(5);
        int month = cal.get(2);
        int year = cal.get(1);
        System.err.println("Year: " + year + ", Month: " + month + ", Day: " + day);
        cal.clear();
        cal.set(year, month, day);
        return cal;
    }

    public void setArgument(String argument) {
        this.argument = argument;
    }

    public String getArgument() {
        return this.argument;
    }
}

