/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.smtp.handlers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.buni.meldware.mail.Protocol;
import org.buni.meldware.mail.smtp.SMTPConstants;
import org.buni.meldware.mail.smtp.SMTPRequest;
import org.buni.meldware.mail.smtp.SMTPResponse;
import org.buni.meldware.mail.smtp.handlers.CmdHELO;
import org.buni.meldware.mail.smtp.handlers.SMTPHandler;
import org.jboss.logging.Logger;

public class CmdHELP
implements SMTPHandler,
SMTPConstants {
    private static final Logger jblog = Logger.getLogger(CmdHELO.class);
    private static final Map<String, String[]> topics = new HashMap<String, String[]>();
    public static final String COMMAND = "HELP";

    static {
        topics.put("HELO", new String[]{"HELO <hostname>", "this command identifies the MTA to this server."});
        topics.put("EHLO", new String[]{"HELO <hostname>", "this command identifies the MTA to this server", "requesting extended SMTP mode."});
        topics.put("MAIL", new String[]{"MAIL FROM:<sender>", "identifies the mail sender."});
        topics.put("RCPT", new String[]{"RCPT TO:<recipient>", "identifies a mail recipient."});
        topics.put("DATA", new String[]{"DATA", "following text is collected as the message.", "end with single dot on line followed by CRLF.", "otherwise, escape leading dot using \\."});
        topics.put("RSET", new String[]{"RSET", "resets the system."});
        topics.put("NOOP", new String[]{"NOOP", "does nothing."});
        topics.put("QUIT", new String[]{"QUIT", "terminate interaction with server."});
        topics.put("VRFY", new String[]{"VRFY <recipient>", "verify an address."});
    }

    public SMTPResponse handleRequest(OutputStream out, SMTPRequest request, Protocol protocol) throws IOException {
        jblog.debug((Object)"HELP command handler called");
        SMTPResponse response = new SMTPResponse(request, out, protocol);
        PrintWriter writer = response.getWriter();
        String[] args = request.getArguments();
        if (args.length > 0) {
            String topic = args[0].toUpperCase();
            if (topics.containsKey(topic)) {
                String[] text = topics.get(topic);
                if (text instanceof Object[]) {
                    Object[] lines = text;
                    int i = 0;
                    while (i < lines.length) {
                        writer.println("214 " + (i > 0 ? "   " : "") + lines[i]);
                        ++i;
                    }
                    writer.println("214 [end of help info]");
                } else {
                    writer.println("214 " + text);
                }
            } else {
                writer.println("501 HELP topic \"" + topic + "\" not recognized");
            }
        } else {
            writer.println("214 Topics:");
            writer.println("214    HELO EHLO MAIL RCPT DATA");
            writer.println("214    RSET NOOP QUIT HELP VRFY");
            writer.println("214 for more information use \"HELP <topic>\"");
            writer.println("214 to report bugs, go to http://buni.org/bugzilla ");
            writer.println("214 [end of help info]");
        }
        writer.flush();
        return response;
    }
}

