/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.userrepository;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.buni.meldware.mail.userrepository.StaticUserRepositoryMBean;
import org.buni.meldware.mail.util.Base64;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBean;
import org.jboss.system.ServiceMBeanSupport;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StaticUserRepository
extends ServiceMBeanSupport
implements ServiceMBean,
StaticUserRepositoryMBean,
Serializable {
    private static final long serialVersionUID = 3258698723180950328L;
    private Map<String, String> users = new HashMap<String, String>();
    private static final Logger jblog = Logger.getLogger(StaticUserRepository.class);

    public void setUsers(Element users) {
        NodeList nodes = users.getElementsByTagName("user");
        HashMap<String, String> pusers = new HashMap<String, String>(nodes.getLength());
        int k = 0;
        while (k < nodes.getLength()) {
            String pname = null;
            String pval = null;
            Node node = nodes.item(k);
            NodeList subnodes = node.getChildNodes();
            int x = 0;
            while (x < subnodes.getLength()) {
                Node subnode = subnodes.item(x);
                if (subnode.getNodeName().equals("id")) {
                    pname = subnode.getFirstChild().getNodeValue();
                } else if (subnode.getNodeName().equals("password")) {
                    pval = subnode.getFirstChild().getNodeValue();
                } else {
                    throw new RuntimeException("user id and password pairs are all that are needed/permitted");
                }
                ++x;
            }
            if (pname == null || pval == null) {
                throw new RuntimeException("users need passwords and passwords need users...");
            }
            pusers.put(pname, pval);
            ++k;
        }
        this.users = pusers;
    }

    public Element getUsers() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
        DOMImplementation impl = builder.getDOMImplementation();
        DocumentType DOCTYPE = impl.createDocumentType("non", "non", "non");
        Document doc = impl.createDocument("non", "non", DOCTYPE);
        Element retval = doc.createElement("users");
        Iterator<String> i = null;
        for (String key : this.users.keySet()) {
            String val = this.users.get(key);
            Element user = doc.createElement("user");
            Element id = doc.createElement("id");
            Element pw = doc.createElement("password");
            id.appendChild(doc.createTextNode(key));
            pw.appendChild(doc.createTextNode(val));
            user.appendChild(id);
            user.appendChild(pw);
            retval.appendChild(user);
        }
        return retval;
    }

    public void addUser(String user, String password) {
        this.users.put(user, password);
    }

    public String[][] listUsers() {
        String[][] retval = new String[this.users.size()][2];
        int k = 0;
        Iterator<String> i = this.users.keySet().iterator();
        while (i.hasNext()) {
            retval[k][0] = i.next();
            retval[k][1] = this.users.get(retval[k][0]);
            ++k;
        }
        return retval;
    }

    public String userList() {
        String[][] list = this.listUsers();
        String retval = "";
        int k = 0;
        while (k < list.length) {
            retval = String.valueOf(retval) + list[k][0];
            retval = String.valueOf(retval) + ", ";
            retval = String.valueOf(retval) + list[k][1];
            retval = String.valueOf(retval) + "\n";
            ++k;
        }
        return retval;
    }

    public boolean test(String username, String password) {
        return this.users.get(username) == null ? false : this.users.get(username).equals(password);
    }

    public boolean test(String username, String password, String apopkey) {
        String pass = this.users.get(username);
        String string = pass = pass == null ? null : String.valueOf(apopkey) + pass;
        if (pass == null) {
            return false;
        }
        String inpass = password;
        jblog.debug((Object)("got " + pass + " and " + inpass + " for " + username));
        pass = Base64.md5AsHexString((String)pass);
        jblog.debug((Object)("was " + pass + " and " + inpass + " for " + username));
        return pass.equals(inpass);
    }

    public boolean test(String username) {
        return this.users.get(username) != null;
    }

    public String getType() {
        return StaticUserRepository.class.getName();
    }
}

