/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.extra.config.provider;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.cache2k.config.BeanMarker;
import org.cache2k.config.CacheType;
import org.cache2k.config.ConfigSection;
import org.cache2k.config.ConfigWithSections;
import org.cache2k.config.ValidatingConfigBean;
import org.cache2k.extra.config.generic.BeanPropertyAccessor;
import org.cache2k.extra.config.generic.BeanPropertyMutator;
import org.cache2k.extra.config.generic.ConfigurationException;
import org.cache2k.extra.config.generic.ConfigurationTokenizer;
import org.cache2k.extra.config.generic.ParsedConfiguration;
import org.cache2k.extra.config.generic.PropertyParser;
import org.cache2k.extra.config.generic.SourceLocation;
import org.cache2k.extra.config.generic.StandardPropertyParser;
import org.cache2k.extra.config.generic.TargetPropertyAccessor;
import org.cache2k.extra.config.generic.TargetPropertyMutator;
import org.cache2k.extra.config.provider.ConfigurationContext;

public class ConfigurationProvider {
    private final PropertyParser propertyParser = new StandardPropertyParser();
    private final ConcurrentMap<Class<?>, TargetPropertyMutator> type2mutator = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, TargetPropertyAccessor> type2accessor = new ConcurrentHashMap();
    static final Set<Class> IMMUTABLE_TYPES = new HashSet<Class>(Arrays.asList(Boolean.class, Character.class, Integer.class, Long.class, Float.class, Double.class, String.class, Duration.class));

    private static String constructGetterName(String containerName) {
        return "get" + Character.toUpperCase(containerName.charAt(0)) + containerName.substring(1);
    }

    void apply(ConfigurationContext ctx, ParsedConfiguration parsedCfg, Object cfg) {
        ParsedConfiguration templates = ctx.getTemplates();
        ConfigurationTokenizer.Property include = parsedCfg.getPropertyMap().get("include");
        if (include != null) {
            for (String template : include.getValue().split(",")) {
                ParsedConfiguration c2 = null;
                if (templates != null) {
                    c2 = templates.getSection(template);
                }
                if (c2 == null) {
                    throw new ConfigurationException("Template not found '" + template + "'", include);
                }
                this.apply(ctx, c2, cfg);
            }
        }
        this.applyPropertyValues(parsedCfg, cfg);
        if (!(cfg instanceof ConfigWithSections)) {
            return;
        }
        ConfigWithSections configurationWithSections = (ConfigWithSections)cfg;
        for (ParsedConfiguration parsedSection : parsedCfg.getSections()) {
            Class<?> type;
            String sectionType = ctx.getPredefinedSectionTypes().get(parsedSection.getName());
            if (sectionType == null) {
                sectionType = parsedSection.getType();
            }
            if (sectionType == null) {
                throw new ConfigurationException("section type missing or unknown", parsedSection);
            }
            try {
                type = Class.forName(sectionType);
            }
            catch (ClassNotFoundException ex) {
                throw new ConfigurationException("class not found '" + sectionType + "'", parsedSection);
            }
            if (this.handleSection(ctx, type, configurationWithSections, parsedSection) || this.handleCollection(ctx, type, cfg, parsedSection) || this.handleBean(ctx, type, cfg, parsedSection)) continue;
            throw new ConfigurationException("Unknown property  '" + parsedSection.getContainer() + "'", parsedSection);
        }
    }

    private boolean handleBean(ConfigurationContext ctx, Class<?> type, Object cfg, ParsedConfiguration parsedCfg) {
        String containerName = parsedCfg.getContainer();
        TargetPropertyMutator m = this.provideMutator(cfg.getClass());
        Class<?> targetType = m.getType(containerName);
        if (targetType == null) {
            return false;
        }
        if (!targetType.isAssignableFrom(type)) {
            throw new ConfigurationException("Type mismatch, expected: '" + targetType.getName() + "'", parsedCfg);
        }
        Object bean = this.createBeanAndApplyConfiguration(ctx, type, parsedCfg);
        this.mutateAndCatch(cfg, m, containerName, bean, parsedCfg, bean);
        return true;
    }

    private boolean handleCollection(ConfigurationContext ctx, Class<?> type, Object cfg, ParsedConfiguration parsedCfg) {
        Collection c;
        Method m;
        String containerName = parsedCfg.getContainer();
        try {
            m = cfg.getClass().getMethod(ConfigurationProvider.constructGetterName(containerName), new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
        if (!Collection.class.isAssignableFrom(m.getReturnType())) {
            return false;
        }
        try {
            c = (Collection)m.invoke(cfg, new Object[0]);
        }
        catch (Exception ex) {
            throw new ConfigurationException("Cannot access collection for '" + containerName + "' " + ex, parsedCfg);
        }
        Object bean = this.createBeanAndApplyConfiguration(ctx, type, parsedCfg);
        try {
            c.add(bean);
        }
        catch (IllegalArgumentException ex) {
            throw new ConfigurationException("Rejected add '" + containerName + "': " + ex.getMessage(), parsedCfg);
        }
        return true;
    }

    private Object createBeanAndApplyConfiguration(ConfigurationContext ctx, Class<?> type, ParsedConfiguration parsedCfg) {
        Object bean;
        try {
            bean = type.newInstance();
        }
        catch (Exception ex) {
            throw new ConfigurationException("Cannot instantiate bean: " + ex, parsedCfg);
        }
        ParsedConfiguration parameters = parsedCfg.getSection("parameters");
        this.apply(ctx, parameters != null ? parameters : parsedCfg, bean);
        if (bean instanceof ValidatingConfigBean) {
            try {
                ((ValidatingConfigBean)bean).validate();
            }
            catch (IllegalArgumentException ex) {
                throw new ConfigurationException("Validation error '" + bean.getClass().getSimpleName() + "': " + ex.getMessage(), parsedCfg);
            }
        }
        return bean;
    }

    private boolean handleSection(ConfigurationContext ctx, Class<?> type, ConfigWithSections cfg, ParsedConfiguration sc) {
        String containerName = sc.getContainer();
        if (!"sections".equals(containerName)) {
            return false;
        }
        ConfigSection sectionBean = cfg.getSections().getSection(type);
        if (!(sectionBean instanceof ConfigSection)) {
            try {
                sectionBean = (ConfigSection)type.newInstance();
            }
            catch (Exception ex) {
                throw new ConfigurationException("Cannot instantiate section class: " + ex, sc);
            }
            cfg.getSections().add(sectionBean);
        }
        this.apply(ctx, sc, sectionBean);
        return true;
    }

    private void applyPropertyValues(ParsedConfiguration cfg, Object bean) {
        TargetPropertyMutator m = this.provideMutator(bean.getClass());
        for (ConfigurationTokenizer.Property p : cfg.getPropertyMap().values()) {
            Object obj;
            Class<?> propertyType = m.getType(p.getName());
            if (propertyType == null) {
                if ("include".equals(p.getName()) || "name".equals(p.getName()) || "type".equals(p.getName())) continue;
                throw new ConfigurationException("Unknown property '" + p.getName() + "'", p);
            }
            try {
                obj = this.propertyParser.parse(propertyType, p.getValue());
            }
            catch (Exception ex) {
                if (ex instanceof NumberFormatException) {
                    throw new ConfigurationException("Cannot parse number: '" + p.getValue() + "'", p);
                }
                if (ex instanceof IllegalArgumentException) {
                    throw new ConfigurationException("Value '" + p.getValue() + "' parse error: " + ex.getMessage(), p);
                }
                throw new ConfigurationException("Cannot parse property: " + ex, p);
            }
            this.mutateAndCatch(bean, m, p, obj);
        }
    }

    private void mutateAndCatch(Object cfg, TargetPropertyMutator m, ConfigurationTokenizer.Property p, Object obj) {
        this.mutateAndCatch(cfg, m, p.getName(), p.getValue(), p, obj);
    }

    private void mutateAndCatch(Object cfg, TargetPropertyMutator m, String name, Object valueForExceptionText, SourceLocation loc, Object obj) {
        try {
            m.mutate(cfg, name, obj);
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getTargetException();
            if (t instanceof IllegalArgumentException) {
                throw new ConfigurationException("Value '" + valueForExceptionText + "' rejected: " + t.getMessage(), loc);
            }
            throw new ConfigurationException("Setting property: " + ex, loc);
        }
        catch (Exception ex) {
            throw new ConfigurationException("Setting property: " + ex, loc);
        }
    }

    private TargetPropertyMutator provideMutator(Class<?> type) {
        return this.type2mutator.computeIfAbsent(type, aClass -> new BeanPropertyMutator((Class<?>)aClass));
    }

    private TargetPropertyAccessor provideAccessor(Class<?> type) {
        return this.type2accessor.computeIfAbsent(type, aClass -> new BeanPropertyAccessor((Class<?>)aClass));
    }

    protected Object copy(Object cfg) {
        Object target;
        Class<?> targetType = cfg.getClass();
        if (!this.isBean(cfg)) {
            throw new UnsupportedOperationException("Cannot copy " + targetType.getName());
        }
        try {
            target = targetType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Bean needs default constructor " + targetType.getName());
        }
        TargetPropertyAccessor accessor = this.provideAccessor(targetType);
        TargetPropertyMutator mutator = this.provideMutator(targetType);
        for (String property : accessor.getNames()) {
            try {
                Object obj = accessor.access(cfg, property);
                if (obj == null || this.isImmutable(obj)) {
                    mutator.mutate(target, property, obj);
                    continue;
                }
                if (this.isCollection(obj)) {
                    Collection targetCollection = (Collection)accessor.access(target, property);
                    for (Object value : (Collection)obj) {
                        targetCollection.add(this.copy(value));
                    }
                    continue;
                }
                mutator.mutate(target, property, this.copy(obj));
            }
            catch (Exception ex) {
                throw new RuntimeException("Problem copying " + targetType.getName() + ":" + property, ex);
            }
        }
        return target;
    }

    private boolean isBean(Object obj) {
        return obj instanceof BeanMarker;
    }

    private boolean isImmutable(Object obj) {
        return IMMUTABLE_TYPES.contains(obj.getClass()) || obj instanceof CacheType;
    }

    private boolean isCollection(Object obj) {
        return obj instanceof Collection;
    }
}

