/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Function;
import java.util.function.Supplier;
import org.cache2k.Cache;
import org.cache2k.CacheClosedException;
import org.cache2k.CacheEntry;
import org.cache2k.CacheManager;
import org.cache2k.config.Cache2kConfig;
import org.cache2k.config.CacheType;
import org.cache2k.core.AbstractCacheEntry;
import org.cache2k.core.BaseCache;
import org.cache2k.core.CacheBaseInfo;
import org.cache2k.core.CacheManagerImpl;
import org.cache2k.core.ConcurrentEntryIterator;
import org.cache2k.core.DefaultExceptionPropagator;
import org.cache2k.core.Entry;
import org.cache2k.core.EntryAction;
import org.cache2k.core.ExceptionWrapper;
import org.cache2k.core.ExpiryPolicyException;
import org.cache2k.core.IntegrityState;
import org.cache2k.core.InternalCache2kBuilder;
import org.cache2k.core.MapValueConverterProxy;
import org.cache2k.core.OperationCompletion;
import org.cache2k.core.ResiliencePolicyException;
import org.cache2k.core.StampedHash;
import org.cache2k.core.api.CommonMetrics;
import org.cache2k.core.api.InternalCache;
import org.cache2k.core.api.InternalCacheBuildContext;
import org.cache2k.core.api.InternalCacheInfo;
import org.cache2k.core.concurrency.ThreadFactoryProvider;
import org.cache2k.core.eviction.Eviction;
import org.cache2k.core.eviction.EvictionMetrics;
import org.cache2k.core.eviction.HeapCacheForEviction;
import org.cache2k.core.log.Log;
import org.cache2k.core.operation.ExaminationEntry;
import org.cache2k.core.operation.Operations;
import org.cache2k.core.operation.Semantic;
import org.cache2k.core.timing.TimeAgnosticTiming;
import org.cache2k.core.timing.Timing;
import org.cache2k.core.util.Util;
import org.cache2k.event.CacheClosedListener;
import org.cache2k.io.AdvancedCacheLoader;
import org.cache2k.io.CacheLoader;
import org.cache2k.io.ExceptionPropagator;
import org.cache2k.io.LoadExceptionInfo;
import org.cache2k.operation.TimeReference;

public class HeapCache<K, V>
extends BaseCache<K, V>
implements HeapCacheForEviction<K, V> {
    protected final String name;
    public final CacheManagerImpl manager;
    protected final AdvancedCacheLoader<K, V> loader;
    protected TimeReference clock;
    protected Timing<K, V> timing = TimeAgnosticTiming.ETERNAL;
    public final Object lock = new Object();
    final CommonMetrics.Updater metrics;
    protected volatile long keyMutationCnt = 0L;
    protected long clearedTime = 0L;
    protected long startedTime = 0L;
    Eviction eviction;
    protected long clearRemovedCnt = 0L;
    protected long clearCnt = 0L;
    protected long internalExceptionCnt = 0L;
    private final Executor executor;
    private volatile Executor loaderExecutor = new LazyLoaderExecutor();
    private volatile boolean disabled;
    private volatile Executor refreshExecutor;
    protected final StampedHash<K, V> hash;
    private volatile boolean closing = true;
    protected CacheType keyType;
    protected CacheType valueType;
    protected final ExceptionPropagator<? super K, ? super V> exceptionPropagator;
    Collection<CacheClosedListener> cacheClosedListeners = Collections.emptyList();
    private int featureBits;
    private static final int KEEP_AFTER_EXPIRED = 2;
    private static final int REJECT_NULL_VALUES = 8;
    private static final int BACKGROUND_REFRESH = 16;
    private static final int UPDATE_TIME_NEEDED = 32;
    private static final int RECORD_REFRESH_TIME = 64;
    private final ThreadFactoryProvider threadFactoryProvider;
    static final byte INSERT_STAT_LOAD = 1;
    static final byte INSERT_STAT_PUT = 2;

    @Override
    public Timing<K, V> getTiming() {
        return this.timing;
    }

    @Override
    public TimeReference getTimeReference() {
        return this.clock;
    }

    public Executor getLoaderExecutor() {
        return this.loaderExecutor;
    }

    protected final boolean isKeepAfterExpired() {
        return (this.featureBits & 2) > 0;
    }

    protected final boolean isRejectNullValues() {
        return (this.featureBits & 8) > 0;
    }

    @Override
    public final boolean isNullValuePermitted() {
        return !this.isRejectNullValues();
    }

    public final boolean isRefreshAhead() {
        return (this.featureBits & 0x10) > 0;
    }

    protected final boolean isUpdateTimeNeeded() {
        return (this.featureBits & 0x20) > 0;
    }

    protected final boolean isRecordRefreshTime() {
        return (this.featureBits & 0x40) > 0;
    }

    private static int featureBit(int bitmask, boolean flag) {
        return flag ? bitmask : 0;
    }

    @Override
    public Log getLog() {
        return Log.getLog(Cache.class.getName() + '/' + this.manager.getName() + ":" + this.name);
    }

    public HeapCache(InternalCacheBuildContext<K, V> ctx) {
        Cache2kConfig<K, V> cfg = ctx.getConfig();
        this.valueType = cfg.getValueType();
        this.keyType = cfg.getKeyType();
        this.name = cfg.getName();
        this.manager = (CacheManagerImpl)ctx.getCacheManager();
        this.hash = this.createHashTable();
        this.clock = ctx.getTimeReference();
        this.featureBits = HeapCache.featureBit(2, cfg.isKeepDataAfterExpired()) | HeapCache.featureBit(8, !cfg.isPermitNullValues()) | HeapCache.featureBit(16, cfg.isRefreshAhead()) | HeapCache.featureBit(32, cfg.isRecordModificationTime()) | HeapCache.featureBit(64, cfg.isRecordModificationTime());
        if (cfg.getLoader() != null) {
            Object obj = ctx.createCustomization(cfg.getLoader());
            CacheLoader simpleLoader = (CacheLoader)obj;
            this.loader = (key, startTime, currentEntry) -> simpleLoader.load(key);
        } else if (cfg.getAdvancedLoader() != null) {
            AdvancedCacheLoader advanceLoader = (AdvancedCacheLoader)ctx.createCustomization(cfg.getAdvancedLoader());
            this.loader = new InternalCache2kBuilder.WrappedAdvancedCacheLoader(this, advanceLoader);
        } else {
            this.loader = null;
        }
        this.exceptionPropagator = ctx.createCustomization(cfg.getExceptionPropagator(), DefaultExceptionPropagator.SINGLETON);
        this.metrics = ctx.createCustomization(ctx.internalConfig().getCommonMetrics());
        this.threadFactoryProvider = ctx.createCustomization(ctx.internalConfig().getThreadFactoryProvider());
        if (cfg.getLoaderExecutor() != null) {
            this.loaderExecutor = (Executor)ctx.createCustomization(cfg.getLoaderExecutor());
        } else if (cfg.getLoaderThreadCount() > 0) {
            this.loaderExecutor = this.provideDefaultLoaderExecutor(cfg.getLoaderThreadCount());
        }
        this.refreshExecutor = ctx.createCustomization(cfg.getRefreshExecutor(), new LazyRefreshExecutor());
        this.executor = ctx.getExecutor();
    }

    String getThreadNamePrefix() {
        return "cache2k-loader-" + Util.compactFullName(this.manager, this.name);
    }

    Executor provideDefaultLoaderExecutor(int threadCount) {
        int corePoolThreadSize = 0;
        return new ThreadPoolExecutor(corePoolThreadSize, threadCount, 21L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), this.threadFactoryProvider.newThreadFactory(this.getThreadNamePrefix()), new ThreadPoolExecutor.AbortPolicy());
    }

    public void setTiming(Timing<K, V> rh) {
        this.timing = rh;
        if (!(rh instanceof TimeAgnosticTiming)) {
            this.featureBits |= HeapCache.featureBit(32, true);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CacheType getKeyType() {
        return this.keyType;
    }

    @Override
    public CacheType getValueType() {
        return this.valueType;
    }

    public void init() {
        this.timing.setTarget(this);
        this.initWithoutTimerHandler();
    }

    public void initWithoutTimerHandler() {
        this.startedTime = this.clock.ticks();
        if (this.isRefreshAhead() && this.timing instanceof TimeAgnosticTiming) {
            throw new IllegalArgumentException("refresh ahead enabled, but no expiry variant defined");
        }
        this.closing = false;
    }

    public void checkClosed() {
        if (this.closing) {
            throw new CacheClosedException((Cache)this);
        }
    }

    public final void clear() {
        this.executeWithGlobalLock(() -> {
            this.clearLocalCache();
            return null;
        });
    }

    public final void clearLocalCache() {
        long removed = this.eviction.removeAll();
        this.clearRemovedCnt += removed;
        ++this.clearCnt;
        this.timing.cancelAll();
        this.hash.clearWhenLocked();
        this.clearedTime = this.clock.ticks();
    }

    @Override
    public void cancelTimerJobs() {
        this.timing.cancelAll();
    }

    public boolean isClosed() {
        return this.closing;
    }

    public void closePart1() throws CacheClosedException {
        this.executeWithGlobalLock(() -> {
            this.closing = true;
            return null;
        });
        this.closeCustomization(this.loaderExecutor, "loaderExecutor");
        this.cancelTimerJobs();
    }

    public void close() {
        try {
            this.closePart1();
        }
        catch (CacheClosedException ex) {
            return;
        }
        this.closePart2(this);
    }

    public void closePart2(InternalCache userCache) {
        this.executeWithGlobalLock(() -> {
            this.eviction.close(this);
            this.timing.close(this);
            this.hash.close();
            this.closeCustomization(this.loader, "loader");
            this.closeCustomization(this.clock, "timeReference");
            for (CacheClosedListener s : this.cacheClosedListeners) {
                Util.waitFor(s.onCacheClosed((Cache)userCache));
            }
            this.manager.sendClosedEvent(userCache, userCache);
            this.manager.cacheClosed(userCache);
            return null;
        }, false);
    }

    @Override
    public Iterator<CacheEntry<K, V>> iterator() {
        return new IteratorFilterEntry2Entry(this, this.iterateAllHeapEntries(), true);
    }

    protected void recordHit(Entry e) {
        ++e.hitCnt;
        this.metrics.heapHit();
    }

    public V get(K key) {
        Entry<K, V> e = this.getEntryInternal(key);
        if (e == null) {
            return null;
        }
        return this.returnValue(e);
    }

    protected CacheEntry<K, V> returnEntry(ExaminationEntry<K, V> e) {
        if (e == null) {
            return null;
        }
        return this.returnCacheEntry(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEntryState(K key) {
        Entry<K, V> e = this.lookupEntry(key);
        if (e == null) {
            return null;
        }
        Entry<K, V> entry = e;
        synchronized (entry) {
            return e.toString(this);
        }
    }

    @Override
    public CacheEntry<K, V> returnCacheEntry(ExaminationEntry<K, V> entry) {
        return this.returnCacheEntry(entry.getKey(), entry.getValueOrException());
    }

    public CacheEntry<K, V> returnCacheEntry(final K key, final Object valueOrException) {
        if (valueOrException instanceof ExceptionWrapper) {
            return (ExceptionWrapper)valueOrException;
        }
        return new AbstractCacheEntry<K, V>(){

            public K getKey() {
                return key;
            }

            public V getValue() {
                return valueOrException;
            }

            public Throwable getException() {
                return null;
            }

            public LoadExceptionInfo getExceptionInfo() {
                return null;
            }
        };
    }

    public CacheEntry<K, V> getEntry(K key) {
        return this.returnEntry(this.getEntryInternal(key));
    }

    protected Entry<K, V> getEntryInternal(K key) {
        int hc = HeapCache.spreadHash(key.hashCode());
        return this.getEntryInternal(key, hc, this.toStoredHashCodeOrKey(key, hc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Entry<K, V> getEntryInternal(K key, int hc, int val) {
        Entry<K, V> e;
        if (this.loader == null) {
            return this.peekEntryInternal(key, hc, val);
        }
        while (true) {
            if ((e = this.lookupOrNewEntry(key, hc, val)).hasFreshData(this.clock)) {
                return e;
            }
            Entry<K, V> entry = e;
            synchronized (entry) {
                e.waitForProcessing();
                if (e.hasFreshData(this.clock)) {
                    return e;
                }
                if (!e.isGone()) break;
                this.metrics.heapHitButNoRead();
                this.metrics.goneSpin();
            }
        }
        {
            e.startProcessing(4, null);
        }
        boolean finished = false;
        try {
            this.load(e);
            finished = true;
        }
        finally {
            e.ensureAbort(finished);
        }
        if (e.getValueOrException() == null && this.isRejectNullValues()) {
            return null;
        }
        return e;
    }

    protected void finishLoadOrEviction(Entry<K, V> e, long nextRefreshTime) {
        if (e.getProcessingState() != 7) {
            this.restartTimer(e, nextRefreshTime);
        } else {
            this.startRefreshProbationTimer(e, nextRefreshTime);
        }
        e.processingDone();
    }

    private void restartTimer(Entry<K, V> e, long nextRefreshTime) {
        e.setNextRefreshTime(this.timing.stopStartTimer(nextRefreshTime, e));
        this.checkIfImmediatelyExpired(e);
    }

    private void checkIfImmediatelyExpired(Entry<K, V> e) {
        if (e.isExpiredState() || this.disabled) {
            this.expireAndRemoveEventuallyAfterProcessing(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeEntry(Entry<K, V> e) {
        boolean removed;
        int hc = this.spreadHashFromEntry(e);
        StampedLock l = this.hash.getSegmentLock(hc);
        long stamp = l.writeLock();
        try {
            removed = this.hash.removeWithinLock(e, hc);
            e.setGone();
            if (removed) {
                this.eviction.submitWithoutTriggeringEviction(e);
            }
        }
        finally {
            l.unlockWrite(stamp);
        }
        this.checkForHashCodeChange(e);
        this.timing.cancelExpiryTimer(e);
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public V peekAndPut(K key, V value) {
        Entry<K, V> e;
        int hc = HeapCache.spreadHash(key.hashCode());
        int val = this.toStoredHashCodeOrKey(key, hc);
        Object previousValue = null;
        while (true) {
            Entry<K, V> entry = e = this.lookupOrNewEntry(key, hc, val);
            synchronized (entry) {
                e.waitForProcessing();
                if (!e.isGone()) break;
                this.metrics.goneSpin();
            }
        }
        {
            boolean hasFreshData = e.hasFreshData(this.clock);
            if (hasFreshData) {
                previousValue = e.getValueOrException();
            } else if (e.isVirgin()) {
                this.metrics.peekMiss();
            } else {
                this.metrics.peekHitNotFresh();
            }
            this.putValue(e, value);
            return HeapCache.returnValue(previousValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V peekAndReplace(K key, V value) {
        Entry<K, V> e;
        while ((e = this.lookupEntry(key)) != null) {
            Entry<K, V> entry = e;
            synchronized (entry) {
                e.waitForProcessing();
                if (e.isGone()) {
                    this.metrics.goneSpin();
                    continue;
                }
                if (e.hasFreshData(this.clock)) {
                    Object previousValue = e.getValueOrException();
                    this.putValue(e, value);
                    return HeapCache.returnValue(previousValue);
                }
                break;
            }
        }
        this.metrics.peekMiss();
        return null;
    }

    protected final void putValue(Entry<K, V> e, V value) {
        if (!this.isUpdateTimeNeeded()) {
            this.insertOrUpdateAndCalculateExpiry(e, value, 0L, 0L, 0L, (byte)2);
        } else {
            long t = this.clock.ticks();
            this.insertOrUpdateAndCalculateExpiry(e, value, t, t, t, (byte)2);
        }
    }

    public boolean replace(K key, V newValue) {
        return this.replace(key, false, null, newValue);
    }

    public boolean replaceIfEquals(K key, V oldValue, V newValue) {
        return this.replace(key, true, oldValue, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean replace(K key, boolean compare, V oldValue, V newValue) {
        Entry<K, V> e = this.lookupEntry(key);
        if (e == null) {
            this.metrics.peekMiss();
            return false;
        }
        Entry<K, V> entry = e;
        synchronized (entry) {
            e.waitForProcessing();
            if (e.isGone() || !e.hasFreshData(this.clock)) {
                return false;
            }
            if (compare && !e.equalsValue((Object)oldValue)) {
                return false;
            }
            this.putValue(e, newValue);
        }
        return true;
    }

    protected final Entry<K, V> peekEntryInternal(K key) {
        int hc = HeapCache.spreadHash(key.hashCode());
        return this.peekEntryInternal(key, hc, this.toStoredHashCodeOrKey(key, hc));
    }

    protected final Entry<K, V> peekEntryInternal(K key, int hc, int val) {
        Entry<K, V> e = this.lookupEntry(key, hc, val);
        if (e == null) {
            this.metrics.peekMiss();
            return null;
        }
        if (e.hasFreshData(this.clock)) {
            return e;
        }
        this.metrics.peekHitNotFresh();
        return null;
    }

    public boolean containsKey(K key) {
        Entry<K, V> e = this.lookupEntry(key);
        if (e != null) {
            this.metrics.heapHitButNoRead();
            return e.hasFreshData(this.clock);
        }
        return false;
    }

    public V peek(K key) {
        Entry<K, V> e = this.peekEntryInternal(key);
        if (e != null) {
            return this.returnValue(e);
        }
        return null;
    }

    public CacheEntry<K, V> peekEntry(K key) {
        return this.returnEntry(this.peekEntryInternal(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public V computeIfAbsent(K key, Function<? super K, ? extends V> function) {
        Entry<K, V> e;
        while (true) {
            if ((e = this.lookupOrNewEntry(key)).hasFreshData(this.clock)) {
                return this.returnValue(e);
            }
            Entry<K, V> entry = e;
            synchronized (entry) {
                e.waitForProcessing();
                if (e.hasFreshData(this.clock)) {
                    return this.returnValue(e);
                }
                if (!e.isGone()) break;
                this.metrics.goneSpin();
            }
        }
        {
            e.startProcessing(6, null);
        }
        this.metrics.peekMiss();
        boolean finished = false;
        long t = 0L;
        long t0 = 0L;
        try {
            V value;
            if (!this.isUpdateTimeNeeded()) {
                value = function.apply(key);
            } else {
                t0 = this.clock.ticks();
                value = function.apply(key);
                if (!this.metrics.isDisabled()) {
                    t = this.clock.ticks();
                }
            }
            Entry<K, V> entry = e;
            synchronized (entry) {
                this.insertOrUpdateAndCalculateExpiry(e, value, t0, t, t0, (byte)2);
                e.processingDone();
            }
            finished = true;
            return this.returnValue(e);
        }
        finally {
            e.ensureAbort(finished);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean putIfAbsent(K key, V value) {
        Entry<K, V> e;
        while (true) {
            Entry<K, V> entry = e = this.lookupOrNewEntry(key);
            synchronized (entry) {
                e.waitForProcessing();
                if (!e.isGone()) break;
                this.metrics.goneSpin();
            }
        }
        {
            if (e.hasFreshData(this.clock)) {
                return false;
            }
            this.metrics.peekMiss();
            this.putValue(e, value);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void put(K key, V value) {
        Entry<K, V> e;
        while (true) {
            Entry<K, V> entry = e = this.lookupOrNewEntry(key);
            synchronized (entry) {
                e.waitForProcessing();
                if (!e.isGone()) break;
                this.metrics.goneSpin();
            }
        }
        {
            if (!e.isVirgin()) {
                this.metrics.heapHitButNoRead();
            }
            this.putValue(e, value);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAndRemove(K key) {
        Entry<K, V> e = this.lookupEntryNoHitRecord(key);
        if (e == null) {
            return false;
        }
        Entry<K, V> entry = e;
        synchronized (entry) {
            e.waitForProcessing();
            if (e.isGone()) {
                return false;
            }
            boolean f = e.hasFreshData(this.clock);
            this.removeEntry(e);
            return f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeIfEquals(K key, V value) {
        Entry<K, V> e = this.lookupEntry(key);
        if (e == null) {
            this.metrics.peekMiss();
            return false;
        }
        Entry<K, V> entry = e;
        synchronized (entry) {
            e.waitForProcessing();
            if (e.isGone()) {
                this.metrics.peekMiss();
                return false;
            }
            boolean f = e.hasFreshData(this.clock);
            if (f) {
                if (!e.equalsValue((Object)value)) {
                    return false;
                }
            } else {
                this.metrics.peekHitNotFresh();
                return false;
            }
            this.removeEntry(e);
            return true;
        }
    }

    public void remove(K key) {
        this.containsAndRemove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V peekAndRemove(K key) {
        Entry<K, V> e = this.lookupEntry(key);
        if (e == null) {
            this.metrics.peekMiss();
            return null;
        }
        Entry<K, V> entry = e;
        synchronized (entry) {
            e.waitForProcessing();
            if (e.isGone()) {
                this.metrics.peekMiss();
                return null;
            }
            Object value = null;
            boolean f = e.hasFreshData(this.clock);
            if (f) {
                value = e.getValueOrException();
            } else {
                this.metrics.peekHitNotFresh();
            }
            this.removeEntry(e);
            return HeapCache.returnValue(value);
        }
    }

    public Executor getRefreshExecutor() {
        return this.refreshExecutor;
    }

    public CompletableFuture<Void> loadAll(Iterable<? extends K> keys) {
        this.checkLoaderPresent();
        Set<K> keysToLoad = this.checkAllPresent(keys);
        if (keysToLoad.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        OperationCompletion<K> completion = new OperationCompletion<K>(keysToLoad);
        for (K k : keysToLoad) {
            this.executeLoader(completion, k, () -> this.extractException(this.getEntryInternal(k)));
        }
        return completion.getFuture();
    }

    public CompletableFuture<Void> reloadAll(Iterable<? extends K> keys) {
        this.checkLoaderPresent();
        Set<K> keysToLoad = HeapCache.generateKeySet(keys);
        OperationCompletion<K> completion = new OperationCompletion<K>(keysToLoad);
        for (K k : keysToLoad) {
            this.executeLoader(completion, k, () -> this.extractException(this.loadAndReplace(k)));
        }
        return completion.getFuture();
    }

    Throwable extractException(Entry<K, V> e) {
        if (e != null) {
            return e.getException();
        }
        return null;
    }

    void executeLoader(OperationCompletion<K> completion, K key, Callable<Throwable> action) {
        Runnable r = () -> {
            Throwable exception;
            try {
                exception = (Throwable)action.call();
            }
            catch (CacheClosedException happens) {
                exception = happens;
            }
            catch (Throwable internalException) {
                this.getLog().warn("Loader exception", internalException);
                ++this.internalExceptionCnt;
                exception = internalException;
            }
            completion.complete(key, exception);
        };
        this.executeLoader(r);
    }

    public void executeLoader(Runnable r) {
        try {
            this.loaderExecutor.execute(r);
        }
        catch (RejectedExecutionException ex) {
            r.run();
        }
    }

    public static <K> Set<K> generateKeySet(Iterable<? extends K> keys) {
        if (keys instanceof Collection) {
            if (keys instanceof Set) {
                return (Set)keys;
            }
            return new HashSet((Collection)keys);
        }
        HashSet<K> keySet = new HashSet<K>();
        for (K k : keys) {
            keySet.add(k);
        }
        return keySet;
    }

    public Set<K> checkAllPresent(Iterable<? extends K> keys) {
        HashSet<K> keysToLoad = new HashSet<K>();
        for (K k : keys) {
            Entry<K, V> e = this.lookupEntryNoHitRecord(k);
            if (e != null && e.hasFreshData(this.clock)) continue;
            keysToLoad.add(k);
        }
        return keysToLoad;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Entry<K, V> loadAndReplace(K key) {
        Entry<K, V> e;
        while (true) {
            Entry<K, V> entry = e = this.lookupOrNewEntry(key);
            synchronized (entry) {
                e.waitForProcessing();
                if (!e.isGone()) break;
                this.metrics.goneSpin();
            }
        }
        {
            e.startProcessing(4, null);
        }
        boolean finished = false;
        try {
            this.load(e);
            finished = true;
            return e;
        }
        finally {
            e.ensureAbort(finished);
        }
    }

    protected Entry<K, V> lookupOrNewEntry(K key) {
        int hc = HeapCache.spreadHash(key.hashCode());
        return this.lookupOrNewEntry(key, hc, this.toStoredHashCodeOrKey(key, hc));
    }

    protected Entry<K, V> lookupOrNewEntry(K key, int hc, int val) {
        Entry<K, V> e = this.lookupEntry(key, hc, val);
        if (e == null) {
            return this.insertNewEntry(key, hc, val);
        }
        return e;
    }

    protected Entry<K, V> lookupOrNewEntryNoHitRecord(K key) {
        int hc = HeapCache.spreadHash(key.hashCode());
        Entry<K, V> e = this.lookupEntryNoHitRecord(key, hc, this.toStoredHashCodeOrKey(key, hc));
        if (e == null) {
            e = this.insertNewEntry(key, hc, this.toStoredHashCodeOrKey(key, hc));
        }
        return e;
    }

    public static <V> V returnValue(Object v) {
        if (v instanceof ExceptionWrapper) {
            throw ((ExceptionWrapper)v).generateExceptionToPropagate();
        }
        return (V)v;
    }

    protected V returnValue(Entry<K, V> e) {
        Object v = e.getValueOrException();
        if (v instanceof ExceptionWrapper) {
            throw ((ExceptionWrapper)v).generateExceptionToPropagate();
        }
        return (V)v;
    }

    protected Entry<K, V> lookupEntry(K key) {
        int hc = HeapCache.spreadHash(key.hashCode());
        return this.lookupEntry(key, hc, this.toStoredHashCodeOrKey(key, hc));
    }

    protected Entry<K, V> lookupEntryNoHitRecord(K key) {
        int hc = HeapCache.spreadHash(key.hashCode());
        return this.lookupEntryNoHitRecord(key, hc, this.toStoredHashCodeOrKey(key, hc));
    }

    protected final Entry<K, V> lookupEntry(K key, int hc, int val) {
        Entry<K, V> e = this.lookupEntryNoHitRecord(key, hc, val);
        if (e != null) {
            this.recordHit(e);
            return e;
        }
        return null;
    }

    protected final Entry<K, V> lookupEntryNoHitRecord(K key, int hc, int val) {
        return this.hash.lookup(this.toEntryKey(key), hc, val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Entry<K, V> insertNewEntry(K key, int hc, int val) {
        Entry<K, V> e2;
        Entry e = new Entry(this.toEntryKey(key), val);
        this.eviction.evictEventuallyBeforeInsertOnSegment(hc);
        StampedLock l = this.hash.getSegmentLock(hc);
        long stamp = l.writeLock();
        try {
            e2 = this.hash.insertWithinLock(e, hc, val);
            if (e == e2) {
                this.eviction.submitWithoutTriggeringEviction(e);
            }
        }
        finally {
            l.unlockWrite(stamp);
        }
        this.hash.checkExpand(hc);
        return e2;
    }

    @Override
    public Entry<K, V>[] getHashEntries() {
        return this.hash.getEntries();
    }

    @Override
    public void removeEntryForEviction(Entry<K, V> e) {
        boolean f = this.hash.remove(e);
        this.checkForHashCodeChange(e);
        this.timing.cancelExpiryTimer(e);
        e.setGone();
    }

    private void checkForHashCodeChange(Entry<K, V> e) {
        K key = this.keyObjFromEntry(e);
        if (this.toStoredHashCodeOrKey(key, HeapCache.spreadHash(key.hashCode())) != e.hashCode) {
            if (this.keyMutationCnt == 0L) {
                HeapCache.logKeyMutation(this.getLog(), e.getKey());
            }
            ++this.keyMutationCnt;
        }
    }

    static void logKeyMutation(Log log, Object key) {
        log.warn("Key mismatch! Key hashcode changed! keyClass=" + key.getClass().getName());
        try {
            String s = key.toString();
            if (s != null) {
                log.warn("Key mismatch! key.toString(): " + s);
            }
        }
        catch (Throwable t) {
            log.warn("Key mismatch! key.toString() threw exception", t);
        }
    }

    protected void load(Entry<K, V> e) {
        Object v;
        long t0;
        long refreshTime = t0 = !this.isUpdateTimeNeeded() ? 0L : this.clock.ticks();
        if (e.getNextRefreshTime() == 6L && this.entryInRefreshProbationAccessed(e, t0)) {
            return;
        }
        try {
            this.checkLoaderPresent();
            v = e.isVirgin() ? this.loader.load(this.keyObjFromEntry(e), t0, null) : this.loader.load(this.keyObjFromEntry(e), t0, e);
        }
        catch (Throwable ouch) {
            long t = t0;
            if (!this.metrics.isDisabled() && this.isUpdateTimeNeeded()) {
                t = this.clock.ticks();
            }
            this.loadGotException(e, t0, t, ouch);
            return;
        }
        long t = t0;
        if (!this.metrics.isDisabled() && this.isUpdateTimeNeeded()) {
            t = this.clock.ticks();
        }
        this.insertOrUpdateAndCalculateExpiry(e, v, t0, t, refreshTime, (byte)1);
    }

    private boolean entryInRefreshProbationAccessed(Entry<K, V> e, long now) {
        long nrt = e.getRefreshProbationNextRefreshTime();
        if (nrt > now) {
            this.reviveRefreshedEntry(e, nrt);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reviveRefreshedEntry(Entry<K, V> e, long nrt) {
        Entry<K, V> entry = e;
        synchronized (entry) {
            this.metrics.refreshedHit();
            this.finishLoadOrEviction(e, nrt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGotException(Entry<K, V> e, long t0, long t, Throwable wrappedException) {
        ExceptionWrapper<? super K, ? super V> value = new ExceptionWrapper<K, V>(this.keyObjFromEntry(e), wrappedException, t0, e, this.exceptionPropagator);
        long nextRefreshTime = 0L;
        boolean suppressException = false;
        try {
            if (e.isValidOrExpiredAndNoException()) {
                nextRefreshTime = this.timing.suppressExceptionUntil(e, value);
            }
            if (nextRefreshTime > t0) {
                suppressException = true;
            } else {
                nextRefreshTime = this.timing.cacheExceptionUntil(e, value);
            }
        }
        catch (Exception ex) {
            this.resiliencePolicyException(e, t0, t, (Throwable)((Object)new ResiliencePolicyException(ex)));
            return;
        }
        value = new ExceptionWrapper<K, V>(value, Math.abs(nextRefreshTime));
        Entry<K, V> entry = e;
        synchronized (entry) {
            this.insertUpdateStats(e, value, t0, t, (byte)1, nextRefreshTime, suppressException);
            if (suppressException) {
                e.setSuppressedLoadExceptionInformation(value);
            } else {
                if (this.isRecordRefreshTime()) {
                    e.setRefreshTime(t0);
                }
                e.setValueOrException(value);
            }
            this.finishLoadOrEviction(e, nextRefreshTime);
        }
    }

    private void resiliencePolicyException(Entry<K, V> e, long t0, long t, Throwable exception) {
        ExceptionWrapper<? super K, ? super V> value = new ExceptionWrapper<K, V>(this.keyObjFromEntry(e), exception, t0, e, this.exceptionPropagator);
        this.insert(e, value, t0, t, t0, (byte)1, 0L);
    }

    private void checkLoaderPresent() {
        if (!this.isLoaderPresent()) {
            throw new UnsupportedOperationException("loader not set");
        }
    }

    @Override
    public boolean isLoaderPresent() {
        return this.loader != null;
    }

    @Override
    public boolean isWeigherPresent() {
        return this.eviction.isWeigherPresent();
    }

    protected final void insertOrUpdateAndCalculateExpiry(Entry<K, V> e, V v, long t0, long t, long refreshTime, byte updateStatistics) {
        long nextRefreshTime;
        try {
            nextRefreshTime = this.timing.calculateNextRefreshTime(e, v, refreshTime);
        }
        catch (Exception ex) {
            ExpiryPolicyException wrappedException = new ExpiryPolicyException(ex);
            if (updateStatistics == 1) {
                this.loadGotException(e, t0, t, (Throwable)((Object)wrappedException));
                return;
            }
            this.insertUpdateStats(e, v, t0, t, updateStatistics, Long.MAX_VALUE, false);
            throw wrappedException;
        }
        this.insert(e, v, t0, t, refreshTime, updateStatistics, nextRefreshTime);
    }

    public RuntimeException returnNullValueDetectedException() {
        return new NullPointerException("Null values in the cache are not permitted.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void insert(Entry<K, V> e, V value, long t0, long t, long refreshTime, byte updateStatistics, long nextRefreshTime) {
        if (updateStatistics == 1) {
            if (value == null && this.isRejectNullValues() && nextRefreshTime != 0L) {
                this.loadGotException(e, t0, t, this.returnNullValueDetectedException());
                return;
            }
            Entry<K, V> entry = e;
            synchronized (entry) {
                if (this.isRecordRefreshTime()) {
                    e.setRefreshTime(refreshTime);
                }
                this.insertUpdateStats(e, value, t0, t, updateStatistics, nextRefreshTime, false);
                e.setValueOrException(value);
                e.resetSuppressedLoadExceptionInformation();
                this.finishLoadOrEviction(e, nextRefreshTime);
            }
        } else {
            if (value == null && this.isRejectNullValues()) {
                throw this.returnNullValueDetectedException();
            }
            if (this.isRecordRefreshTime()) {
                e.setRefreshTime(refreshTime);
            }
            e.setValueOrException(value);
            e.resetSuppressedLoadExceptionInformation();
            this.insertUpdateStats(e, value, t0, t, updateStatistics, nextRefreshTime, false);
            this.restartTimer(e, nextRefreshTime);
        }
    }

    private void insertUpdateStats(Entry<K, V> e, V value, long t0, long t, byte updateStatistics, long nextRefreshTime, boolean suppressException) {
        if (updateStatistics == 1) {
            if (suppressException) {
                this.metrics.suppressedException();
            } else if (value instanceof ExceptionWrapper) {
                this.metrics.loadException();
            }
            long millis = t - t0;
            if (e.isGettingRefresh()) {
                this.metrics.refresh(millis);
            } else if (e.isVirgin()) {
                this.metrics.readThrough(millis);
            } else {
                this.metrics.explicitLoad(millis);
            }
        } else if (nextRefreshTime != 0L) {
            this.metrics.putNewEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timerEventRefresh(Entry<K, V> e, Object task) {
        this.metrics.timerEvent();
        Entry<K, V> entry = e;
        synchronized (entry) {
            if (e.getTask() != task) {
                return;
            }
            try {
                this.refreshExecutor.execute(this.createFireAndForgetAction((Entry)e, Operations.SINGLETON.refresh));
            }
            catch (RejectedExecutionException ex) {
                this.metrics.refreshRejected();
                this.expireOrScheduleFinalExpireEvent(e);
            }
        }
    }

    public void startRefreshProbationTimer(Entry<K, V> e, long nextRefreshTime) {
        boolean expired = this.timing.startRefreshProbationTimer(e, nextRefreshTime);
        if (expired) {
            this.expireAndRemoveEventually(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timerEventProbationTerminated(Entry<K, V> e, Object task) {
        this.metrics.timerEvent();
        Entry<K, V> entry = e;
        synchronized (entry) {
            if (e.getTask() != task) {
                return;
            }
            this.expireEntry(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logAndCountInternalException(String text, Throwable exception) {
        Object object = this.lock;
        synchronized (object) {
            ++this.internalExceptionCnt;
        }
        this.getLog().warn(text, exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timerEventExpireEntry(Entry<K, V> e, Object task) {
        this.metrics.timerEvent();
        Entry<K, V> entry = e;
        synchronized (entry) {
            if (e.getTask() != task) {
                return;
            }
            this.expireOrScheduleFinalExpireEvent(e);
        }
    }

    private void expireOrScheduleFinalExpireEvent(Entry<K, V> e) {
        long nrt = e.getNextRefreshTime();
        long t = this.clock.ticks();
        if (t >= Math.abs(nrt)) {
            try {
                this.expireEntry(e);
            }
            catch (CacheClosedException cacheClosedException) {}
        } else {
            if (nrt < 0L) {
                return;
            }
            this.timing.scheduleFinalTimerForSharpExpiry(e);
            e.setNextRefreshTime(-nrt);
        }
    }

    protected void expireEntry(Entry<K, V> e) {
        if (e.isGone() || e.isExpiredState()) {
            return;
        }
        e.setNextRefreshTime(4L);
        this.expireAndRemoveEventually(e);
    }

    private void expireAndRemoveEventually(Entry<K, V> e) {
        if (this.isKeepAfterExpired() || e.isProcessing()) {
            this.metrics.expiredKept();
        } else {
            this.removeEntry(e);
        }
    }

    private void expireAndRemoveEventuallyAfterProcessing(Entry<K, V> e) {
        if (this.isKeepAfterExpired()) {
            this.metrics.expiredKept();
        } else {
            this.removeEntry(e);
        }
    }

    public final ConcurrentEntryIterator<K, V> iterateAllHeapEntries() {
        return new ConcurrentEntryIterator(this);
    }

    public Map<K, V> getAll(Iterable<? extends K> inputKeys) {
        HashMap<K, Object> map = new HashMap<K, Object>();
        for (K k : inputKeys) {
            Entry<K, V> e = this.getEntryInternal(k);
            if (e == null) continue;
            map.put(this.keyObjFromEntry(e), e.getValueOrException());
        }
        return this.convertValueMap(map);
    }

    public Map<K, V> convertValueMap(Map<K, Object> map) {
        return new MapValueConverterProxy<K, V, Object>(map){

            @Override
            protected V convert(Object v) {
                return HeapCache.returnValue(v);
            }
        };
    }

    public Map<K, V> convertCacheEntry2ValueMap(Map<K, CacheEntry<K, V>> map) {
        return new MapValueConverterProxy<K, V, CacheEntry<K, V>>(map){

            @Override
            protected V convert(CacheEntry<K, V> v) {
                return v.getValue();
            }
        };
    }

    public Map<K, V> peekAll(Iterable<? extends K> inputKeys) {
        HashMap<K, Object> map = new HashMap<K, Object>();
        for (K k : inputKeys) {
            Entry<K, V> e = this.peekEntryInternal(k);
            if (e == null) continue;
            map.put(k, e.getValueOrException());
        }
        return this.convertValueMap(map);
    }

    public void putAll(Map<? extends K, ? extends V> valueMap) {
        for (Map.Entry<K, V> e : valueMap.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    Operations<K, V> spec() {
        return Operations.SINGLETON;
    }

    @Override
    protected <R> EntryAction<K, V, R> createEntryAction(K key, Entry<K, V> e, Semantic<K, V, R> op) {
        return new MyEntryAction<R>(op, key, e);
    }

    protected <R> MyEntryAction<R> createFireAndForgetAction(Entry<K, V> e, Semantic<K, V, R> op) {
        return new MyEntryAction<R>(op, e.getKey(), e, EntryAction.NOOP_CALLBACK);
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public final long getTotalEntryCount() {
        return this.hash.getSize();
    }

    protected IntegrityState getIntegrityState() {
        EvictionMetrics em = this.eviction.getMetrics();
        IntegrityState is = new IntegrityState().checkEquals("hash.getSize() == hash.calcEntryCount()", this.hash.getSizeWithGlobalLock(), this.hash.calcEntryCount());
        if (em.getEvictionRunningCount() > 0) {
            is.check("eviction running: hash.getSize() == eviction.getSize()", true).check("eviction running: newEntryCnt == hash.getSize() + evictedCnt ....", true);
        } else {
            is.checkEquals("hash.getSize() == eviction.getSize()", this.hash.getSizeWithGlobalLock(), em.getSize()).checkEquals("newEntryCnt == hash.getSize() + evictedCnt + expiredRemoveCnt + removeCnt + clearedCnt + virginRemovedCnt", em.getNewEntryCount(), this.hash.getSizeWithGlobalLock() + em.getEvictedCount() + em.getExpiredRemovedCount() + em.getRemovedCount() + this.clearRemovedCnt + em.getVirginRemovedCount());
        }
        this.eviction.checkIntegrity(is);
        return is;
    }

    @Override
    public final void checkIntegrity() {
        this.checkIntegrity(this);
    }

    final void checkIntegrity(InternalCache userCache) {
        this.executeWithGlobalLock(() -> {
            IntegrityState is = this.getIntegrityState();
            HeapCache.throwErrorOnIntegrityFailure(is, this);
            return null;
        });
    }

    static void throwErrorOnIntegrityFailure(IntegrityState is, InternalCache userCache) {
        if (is.isFailure()) {
            throw new Error("cache2k integrity error: " + is.getFailingChecks() + ", " + userCache.getInfo());
        }
    }

    @Override
    public final InternalCacheInfo getInfo() {
        return this.getInfo(this);
    }

    @Override
    public final InternalCacheInfo getConsistentInfo() {
        return this.getConsistentInfo(this);
    }

    public final InternalCacheInfo getInfo(InternalCache userCache) {
        return this.generateInfoMaybeLocked(userCache);
    }

    public final InternalCacheInfo getConsistentInfo(InternalCache userCache) {
        return this.executeWithGlobalLock(() -> this.generateInfoMaybeLocked(userCache));
    }

    CacheBaseInfo generateInfoMaybeLocked(InternalCache userCache) {
        CacheBaseInfo info = new CacheBaseInfo(this, userCache, this.clock.ticks());
        return info;
    }

    @Override
    public CommonMetrics getCommonMetrics() {
        return this.metrics;
    }

    public <T> T executeWithGlobalLock(Supplier<T> job) {
        return this.executeWithGlobalLock(job, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T executeWithGlobalLock(Supplier<T> job, boolean checkClosed) {
        Object object = this.lock;
        synchronized (object) {
            if (checkClosed) {
                this.checkClosed();
            }
            Object result = this.hash.runTotalLocked(() -> this.eviction.runLocked(((Supplier)job)::get));
            return (T)result;
        }
    }

    @Override
    public final TimeReference getClock() {
        return this.clock;
    }

    @Override
    public final Eviction getEviction() {
        return this.eviction;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    public CacheManager getCacheManager() {
        return this.manager;
    }

    public static int spreadHash(int h) {
        return h ^ h >>> 16;
    }

    public int toStoredHashCodeOrKey(K key, int hc) {
        return hc;
    }

    public K toEntryKey(K key) {
        return key;
    }

    public int spreadHashFromEntry(Entry e) {
        return e.hashCode;
    }

    public K keyObjFromEntry(Entry<K, V> e) {
        return (K)e.getKeyObj();
    }

    public StampedHash<K, V> createHashTable() {
        return new StampedHash(this);
    }

    class MyEntryAction<R>
    extends EntryAction<K, V, R> {
        MyEntryAction(Semantic<K, V, R> op, K k, Entry<K, V> e) {
            super(HeapCache.this, HeapCache.this, op, k, e);
        }

        MyEntryAction(Semantic<K, V, R> op, K k, Entry<K, V> e, EntryAction.CompletedCallback cb) {
            super(HeapCache.this, HeapCache.this, op, k, e, cb);
        }

        @Override
        protected Timing<K, V> timing() {
            return HeapCache.this.timing;
        }

        public Executor getLoaderExecutor() {
            return null;
        }

        @Override
        protected Executor executor() {
            return HeapCache.this.executor;
        }

        @Override
        public ExceptionPropagator getExceptionPropagator() {
            return HeapCache.this.exceptionPropagator;
        }
    }

    static class IteratorFilterEntry2Entry<K, V>
    implements Iterator<CacheEntry<K, V>> {
        final HeapCache<K, V> cache;
        final Iterator<Entry<K, V>> iterator;
        Entry entry;
        CacheEntry<K, V> lastEntry;
        final boolean filter;

        IteratorFilterEntry2Entry(HeapCache<K, V> c, Iterator<Entry<K, V>> it, boolean filter) {
            this.cache = c;
            this.iterator = it;
            this.filter = filter;
        }

        @Override
        public boolean hasNext() {
            if (this.entry != null) {
                return true;
            }
            if (this.iterator == null) {
                return false;
            }
            while (this.iterator.hasNext()) {
                Entry<K, V> e = this.iterator.next();
                if (this.filter) {
                    if (!e.hasFreshData(this.cache.getClock())) continue;
                    this.entry = e;
                    return true;
                }
                this.entry = e;
                return true;
            }
            this.entry = null;
            return false;
        }

        @Override
        public CacheEntry<K, V> next() {
            if (this.entry == null && !this.hasNext()) {
                throw new NoSuchElementException("not available");
            }
            this.lastEntry = this.cache.returnEntry(this.entry);
            this.entry = null;
            return this.lastEntry;
        }

        @Override
        public void remove() {
            if (this.lastEntry == null) {
                throw new IllegalStateException("Unable to remove, hasNext() not called or previously removed");
            }
            this.cache.remove(this.lastEntry.getKey());
            this.lastEntry = null;
        }
    }

    private class LazyRefreshExecutor
    implements Executor {
        private LazyRefreshExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable command) {
            Object object = HeapCache.this.lock;
            synchronized (object) {
                HeapCache.this.checkClosed();
                HeapCache.this.loaderExecutor.execute(command);
                HeapCache.this.refreshExecutor = HeapCache.this.loaderExecutor;
            }
        }
    }

    private class LazyLoaderExecutor
    implements Executor {
        private LazyLoaderExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable command) {
            Object object = HeapCache.this.lock;
            synchronized (object) {
                HeapCache.this.checkClosed();
                if (HeapCache.this.loaderExecutor == this) {
                    int threadCount = Runtime.getRuntime().availableProcessors();
                    HeapCache.this.loaderExecutor = HeapCache.this.provideDefaultLoaderExecutor(threadCount);
                }
                HeapCache.this.loaderExecutor.execute(command);
            }
        }
    }
}

