/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.function.Supplier;
import org.cache2k.core.Entry;
import org.cache2k.core.IntegrityState;
import org.cache2k.core.api.InternalCacheCloseContext;
import org.cache2k.core.eviction.Eviction;
import org.cache2k.core.eviction.EvictionFactory;
import org.cache2k.core.eviction.EvictionMetrics;

public class SegmentedEviction
implements Eviction {
    private final Eviction[] segments;

    public SegmentedEviction(Eviction[] segments) {
        this.segments = segments;
    }

    @Override
    public long startNewIdleScanRound() {
        long sum = 0L;
        for (Eviction ev : this.segments) {
            sum += ev.startNewIdleScanRound();
        }
        return sum;
    }

    @Override
    public boolean updateWeight(Entry e) {
        int hc = e.hashCode;
        Eviction[] sgs = this.segments;
        int mask = sgs.length - 1;
        int idx = hc & mask;
        return sgs[idx].updateWeight(e);
    }

    @Override
    public boolean submitWithoutTriggeringEviction(Entry e) {
        int hc = e.hashCode;
        Eviction[] sgs = this.segments;
        int mask = sgs.length - 1;
        int idx = hc & mask;
        return sgs[idx].submitWithoutTriggeringEviction(e);
    }

    @Override
    public void evictEventuallyBeforeInsertOnSegment(int hashCodeHint) {
        Eviction[] sgs = this.segments;
        int mask = sgs.length - 1;
        int idx = hashCodeHint & mask;
        sgs[idx].evictEventuallyBeforeInsertOnSegment(hashCodeHint);
    }

    @Override
    public void evictEventuallyBeforeInsert() {
        for (Eviction ev : this.segments) {
            ev.evictEventuallyBeforeInsert();
        }
    }

    @Override
    public void evictEventually() {
        for (Eviction ev : this.segments) {
            ev.evictEventually();
        }
    }

    @Override
    public long evictIdleEntries(int maxScan) {
        int maxScanPerSegment = maxScan / this.segments.length + 1;
        long evictedCount = 0L;
        for (Eviction ev : this.segments) {
            evictedCount += ev.evictIdleEntries(maxScanPerSegment);
        }
        return evictedCount;
    }

    @Override
    public long removeAll() {
        long count = 0L;
        for (Eviction ev : this.segments) {
            count += ev.removeAll();
        }
        return count;
    }

    @Override
    public void close(InternalCacheCloseContext closeContext) {
        for (Eviction ev : this.segments) {
            ev.close(closeContext);
        }
    }

    @Override
    public <T> T runLocked(Supplier<T> j) {
        return this.runLocked(0, j);
    }

    private <T> T runLocked(int idx, Supplier<T> j) {
        if (idx == this.segments.length) {
            return j.get();
        }
        return (T)this.segments[idx].runLocked(() -> this.runLocked(idx + 1, j));
    }

    @Override
    public void checkIntegrity(IntegrityState integrityState) {
        for (int i = 0; i < this.segments.length; ++i) {
            integrityState.group("eviction" + i);
            this.segments[i].checkIntegrity(integrityState);
        }
    }

    @Override
    public EvictionMetrics getMetrics() {
        EvictionMetrics[] metrics = new EvictionMetrics[this.segments.length];
        for (int i = 0; i < metrics.length; ++i) {
            metrics[i] = this.segments[i].getMetrics();
        }
        long sum = 0L;
        for (EvictionMetrics m : metrics) {
            sum += m.getSize();
        }
        final long size = sum;
        sum = 0L;
        for (EvictionMetrics m : metrics) {
            sum += m.getNewEntryCount();
        }
        final long newEntryCount = sum;
        sum = 0L;
        for (EvictionMetrics m : metrics) {
            sum += m.getRemovedCount();
        }
        final long removedCnt = sum;
        sum = 0L;
        for (EvictionMetrics m : metrics) {
            sum += m.getVirginRemovedCount();
        }
        final long virginRemovedCnt = sum;
        sum = 0L;
        for (EvictionMetrics m : metrics) {
            sum += m.getExpiredRemovedCount();
        }
        final long expiredRemovedCnt = sum;
        sum = 0L;
        for (EvictionMetrics m : metrics) {
            sum += m.getEvictedCount();
        }
        final long evictedCount = sum;
        sum = 0L;
        for (EvictionMetrics m : metrics) {
            long v = m.getMaxSize();
            if (v == Long.MAX_VALUE) {
                sum = v;
                break;
            }
            sum += v;
        }
        final long maxSize = sum < -1L ? -1L : sum;
        sum = 0L;
        for (EvictionMetrics m : metrics) {
            long v = m.getMaxWeight();
            if (v == Long.MAX_VALUE) {
                sum = v;
                break;
            }
            sum += v;
        }
        final long maxWeight = sum < -1L ? -1L : sum;
        sum = 0L;
        for (EvictionMetrics m : metrics) {
            sum += m.getTotalWeight();
        }
        final long totalWeight = sum;
        sum = 0L;
        for (EvictionMetrics m : metrics) {
            sum += m.getEvictedWeight();
        }
        final long evictedWeight = sum;
        sum = 0L;
        for (EvictionMetrics m : metrics) {
            sum += m.getScanCount();
        }
        final long scanCount = sum;
        sum = 0L;
        for (EvictionMetrics m : metrics) {
            sum += (long)m.getEvictionRunningCount();
        }
        final int evictionRunningCount = (int)sum;
        sum = 0L;
        for (EvictionMetrics m : metrics) {
            sum += m.getIdleNonEvictDrainCount();
        }
        final long removeAfterScanCount = sum;
        return new EvictionMetrics(){

            @Override
            public long getSize() {
                return size;
            }

            @Override
            public long getNewEntryCount() {
                return newEntryCount;
            }

            @Override
            public long getRemovedCount() {
                return removedCnt;
            }

            @Override
            public long getVirginRemovedCount() {
                return virginRemovedCnt;
            }

            @Override
            public long getExpiredRemovedCount() {
                return expiredRemovedCnt;
            }

            @Override
            public long getEvictedCount() {
                return evictedCount;
            }

            @Override
            public long getMaxSize() {
                return maxSize;
            }

            @Override
            public long getMaxWeight() {
                return maxWeight;
            }

            @Override
            public long getTotalWeight() {
                return totalWeight;
            }

            @Override
            public long getEvictedWeight() {
                return evictedWeight;
            }

            @Override
            public int getEvictionRunningCount() {
                return evictionRunningCount;
            }

            @Override
            public long getScanCount() {
                return scanCount;
            }

            @Override
            public long getIdleNonEvictDrainCount() {
                return removeAfterScanCount;
            }
        };
    }

    @Override
    public boolean isWeigherPresent() {
        return this.segments[0].isWeigherPresent();
    }

    @Override
    public void changeCapacity(long entryCountOrWeight) {
        long limitPerSegment = this.isWeigherPresent() ? EvictionFactory.determineMaxWeight(entryCountOrWeight, this.segments.length) : EvictionFactory.determineMaxSize(entryCountOrWeight, this.segments.length);
        for (Eviction ev : this.segments) {
            ev.changeCapacity(limitPerSegment);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.segments.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("eviction").append(i).append("=(");
            sb.append(this.segments[i].toString());
            sb.append(')');
        }
        return sb.toString();
    }
}

