/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.eviction;

import java.util.function.Supplier;
import org.cache2k.core.Entry;
import org.cache2k.core.ExceptionWrapper;
import org.cache2k.core.IntegerTo16BitFloatingPoint;
import org.cache2k.core.api.InternalCacheCloseContext;
import org.cache2k.core.eviction.Eviction;
import org.cache2k.core.eviction.EvictionMetrics;
import org.cache2k.core.eviction.HeapCacheForEviction;
import org.cache2k.core.eviction.InternalEvictionListener;
import org.cache2k.operation.Weigher;

public abstract class AbstractEviction
implements Eviction {
    public static final int MINIMAL_CHUNK_SIZE = 4;
    public static final int MAXIMAL_CHUNK_SIZE = 64;
    public static final long MINIMUM_CAPACITY_FOR_CHUNKING = 1000L;
    private final Weigher weigher;
    protected final HeapCacheForEviction heapCache;
    protected final Object lock = new Object();
    private final InternalEvictionListener listener;
    private final boolean noListenerCall;
    private final boolean noChunking;
    private long estimatedEntryCapacity = 0L;
    private int chunkSize = 1;
    protected long maxSize;
    protected long maxWeight;
    private Entry[] evictChunkReuse = null;
    private int evictionRunningCount = 0;
    private long newEntryCounter;
    private long removedCnt;
    private long expiredRemovedCnt;
    private long virginRemovedCnt;
    private long evictedCount;
    private long totalWeight;
    private long evictedWeight;
    protected int idleScanRound;
    protected long idleNonEvictDrainCount;

    public AbstractEviction(HeapCacheForEviction heapCache, InternalEvictionListener listener, long maxSize, Weigher weigher, long maxWeight, boolean noChunking) {
        this.weigher = weigher;
        this.heapCache = heapCache;
        this.listener = listener;
        this.noListenerCall = listener == InternalEvictionListener.NO_OPERATION;
        this.noChunking = noChunking;
        this.maxSize = maxSize;
        this.maxWeight = maxWeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long startNewIdleScanRound() {
        Object object = this.lock;
        synchronized (object) {
            this.idleNonEvictDrainCount = 0L;
            this.idleScanRound = this.idleScanRound + 1 & 0xF;
            return this.getScanCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean submitWithoutTriggeringEviction(Entry e) {
        Object object = this.lock;
        synchronized (object) {
            if (e.isNotYetInsertedInReplacementList()) {
                this.insertIntoReplacementList(e);
                ++this.newEntryCounter;
            } else {
                this.removeEventually(e);
            }
            return this.isEvictionNeeded(1);
        }
    }

    private static int calculateChunkSize(boolean noChunking, long maxSize) {
        if (noChunking || maxSize < 1000L) {
            return 1;
        }
        return Math.min(64, 4 + Runtime.getRuntime().availableProcessors() - 1);
    }

    @Override
    public boolean isWeigherPresent() {
        return this.weigher != null;
    }

    private int calculateWeight(Entry e, Object v) {
        if (v instanceof ExceptionWrapper) {
            return 1;
        }
        int weight = this.weigher.weigh(e.getKey(), v);
        if (weight < 0) {
            throw new IllegalArgumentException("weight must be positive.");
        }
        return weight;
    }

    protected void updateTotalWeightForRemove(Entry e) {
        if (!this.isWeigherPresent()) {
            return;
        }
        int entryWeight = this.getWeightFromEntry(e);
        this.totalWeight -= (long)entryWeight;
        this.evictedWeight += (long)entryWeight;
    }

    private int getWeightFromEntry(Entry e) {
        return AbstractEviction.decompressWeight(e.getCompressedWeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateWeight(Entry e) {
        if (!this.isWeigherPresent()) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            this.updateAccumulatedWeightInLock(e);
            return this.isEvictionNeeded(0);
        }
    }

    protected void updateAccumulatedWeightInLock(Entry e) {
        Object v = e.getValueOrException();
        int requestedCompressedWeight = AbstractEviction.compressWeight(this.calculateWeight(e, v));
        if (e.getCompressedWeight() != requestedCompressedWeight) {
            long decompressedEntryWeight = AbstractEviction.decompressWeight(e.getCompressedWeight());
            long requestedWeightWithLostPrecision = AbstractEviction.decompressWeight(requestedCompressedWeight);
            this.totalWeight += requestedWeightWithLostPrecision - decompressedEntryWeight;
            e.setCompressedWeight(requestedCompressedWeight);
        }
    }

    private static int decompressWeight(int weight) {
        return IntegerTo16BitFloatingPoint.expand(weight);
    }

    private static int compressWeight(int weight) {
        return IntegerTo16BitFloatingPoint.compress(weight);
    }

    private void removeEventually(Entry e) {
        if (!e.isRemovedFromReplacementList()) {
            this.removeFromReplacementList(e);
            this.updateTotalWeightForRemove(e);
            long nrt = e.getNextRefreshTime();
            if (nrt == 12L) {
                ++this.expiredRemovedCnt;
            } else if (nrt == 8L) {
                ++this.virginRemovedCnt;
            } else {
                ++this.removedCnt;
            }
            if (e.getScanRound() != this.idleScanRound) {
                ++this.idleNonEvictDrainCount;
            }
        }
    }

    private boolean isEvictionNeeded(int spaceNeeded) {
        if (this.isWeigherPresent()) {
            return this.totalWeight + (long)spaceNeeded > this.maxWeight;
        }
        return this.getSize() + (long)spaceNeeded - (long)this.evictionRunningCount > this.maxSize;
    }

    @Override
    public void evictEventuallyBeforeInsert() {
        this.evictEventually(1);
    }

    @Override
    public void evictEventuallyBeforeInsertOnSegment(int hashCodeHint) {
        this.evictEventuallyBeforeInsert();
    }

    @Override
    public void evictEventually() {
        this.evictEventually(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictEventually(int spaceNeeded) {
        Object object;
        boolean needsEviction;
        Entry[] chunk;
        Object object2 = this.lock;
        synchronized (object2) {
            chunk = this.fillEvictionChunk(spaceNeeded);
        }
        if (chunk == null) {
            return;
        }
        boolean bl = needsEviction = (this.evictChunk(chunk, spaceNeeded) & 1) > 0;
        if (!needsEviction) {
            return;
        }
        long loop = 1L;
        if (this.weigher != null) {
            object = this.lock;
            synchronized (object) {
                loop = this.getSize();
            }
        }
        while (needsEviction && loop-- > 0L) {
            object = this.lock;
            synchronized (object) {
                chunk = this.fillEvictionChunk(spaceNeeded);
            }
            needsEviction = (this.evictChunk(chunk, spaceNeeded) & 1) > 0;
        }
    }

    private Entry[] fillEvictionChunk(int spaceNeeded) {
        if (!this.isEvictionNeeded(spaceNeeded)) {
            return null;
        }
        if (this.evictionRunningCount == 0 && this.estimatedEntryCapacity < this.getSize()) {
            this.updatesSizesAfterLimitReached();
        }
        Entry[] chunk = this.evictChunkReuse;
        this.evictChunkReuse = null;
        if (chunk == null) {
            chunk = new Entry[this.chunkSize];
        }
        this.evictionRunningCount += chunk.length;
        for (int i = 0; i < chunk.length; ++i) {
            chunk[i] = this.findEvictionCandidate();
        }
        return chunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int evictChunk(Entry[] chunk, int spaceNeeded) {
        if (chunk == null) {
            return 0;
        }
        int processCount = this.removeFromHash(chunk);
        Object object = this.lock;
        synchronized (object) {
            if (processCount > 0) {
                this.removeChunkFromReplacementListOnEvict(chunk);
            }
            this.evictionRunningCount -= chunk.length;
            this.evictChunkReuse = chunk;
            return (processCount << 1) + (this.isEvictionNeeded(spaceNeeded) ? 1 : 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long evictIdleEntries(int maxScan) {
        Entry[] chunk;
        long maxScanCount = 0L;
        long evictedCount = 0L;
        do {
            Object object = this.lock;
            synchronized (object) {
                long scanCount = this.getScanCount();
                if (scanCount >= maxScanCount) {
                    if (maxScanCount > 0L) {
                        break;
                    }
                    maxScanCount = scanCount + (long)maxScan;
                }
                chunk = this.fillEvictChunkWithIdlers(maxScan);
            }
            evictedCount += (long)(this.evictChunk(chunk, 0) >> 1);
        } while (chunk != null);
        return evictedCount;
    }

    private Entry[] fillEvictChunkWithIdlers(int maxScan) {
        int i;
        Entry[] chunk = this.evictChunkReuse;
        this.evictChunkReuse = null;
        if (chunk == null) {
            chunk = new Entry[this.chunkSize];
        }
        long stopScanCount = this.getScanCount() + (long)maxScan;
        for (i = 0; i < chunk.length && this.getScanCount() < stopScanCount; ++i) {
            chunk[i] = this.findIdleCandidate((int)(stopScanCount - this.getScanCount()));
            if (chunk[i] == null) break;
        }
        if (i > 0) {
            this.evictionRunningCount += chunk.length;
            return chunk;
        }
        this.evictChunkReuse = chunk;
        return null;
    }

    private void updatesSizesAfterLimitReached() {
        this.estimatedEntryCapacity = this.getSize();
        this.updateHotMax();
        this.resetChunkSize();
    }

    private void resetChunkSize() {
        int targetChunkSize = AbstractEviction.calculateChunkSize(this.noChunking, this.getSize());
        if (targetChunkSize != this.chunkSize) {
            this.chunkSize = targetChunkSize;
            this.evictChunkReuse = null;
        }
    }

    private int removeFromHash(Entry[] chunk) {
        if (this.noListenerCall) {
            return this.removeFromHashWithoutListener(chunk);
        }
        return this.removeFromHashWithListener(chunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeFromHashWithoutListener(Entry[] chunk) {
        int processCount = 0;
        for (int i = 0; i < chunk.length; ++i) {
            Entry e = chunk[i];
            if (e == null) continue;
            Entry entry = e;
            synchronized (entry) {
                if (e.isGone() || e.isProcessing()) {
                    chunk[i] = null;
                    continue;
                }
                this.heapCache.removeEntryForEviction(e);
            }
            ++processCount;
        }
        return processCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeFromHashWithListener(Entry[] chunk) {
        int processCount = 0;
        for (int i = 0; i < chunk.length; ++i) {
            Entry e;
            Entry entry = e = chunk[i];
            synchronized (entry) {
                if (e.isGone() || e.isProcessing()) {
                    chunk[i] = null;
                    continue;
                }
                e.startProcessing(16, null);
            }
            this.listener.onEvictionFromHeap(e);
            entry = e;
            synchronized (entry) {
                e.processingDone();
                this.heapCache.removeEntryForEviction(e);
            }
            ++processCount;
        }
        return processCount;
    }

    private void removeChunkFromReplacementListOnEvict(Entry[] chunk) {
        for (int i = 0; i < chunk.length; ++i) {
            Entry e = chunk[i];
            if (e == null) continue;
            if (!e.isRemovedFromReplacementList()) {
                this.removeFromReplacementListOnEvict(e);
                this.updateTotalWeightForRemove(e);
                ++this.evictedCount;
            }
            chunk[i] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EvictionMetrics getMetrics() {
        Object object = this.lock;
        synchronized (object) {
            final long size = this.getSize();
            final long newEntryCounter = this.newEntryCounter;
            final long removedCnt = this.removedCnt;
            final long virginRemovedCnt = this.virginRemovedCnt;
            final long expiredRemovedCnt = this.expiredRemovedCnt;
            final long evictedCount = this.evictedCount;
            final long maxSize = this.maxSize;
            final long maxWeight = this.maxWeight;
            final long totalWeight = this.totalWeight;
            final long evictedWeight = this.evictedWeight;
            final int evictionRunningCount = this.evictionRunningCount;
            final long scanCount = this.getScanCount();
            final long idleNonEvictDrainCount = this.idleNonEvictDrainCount;
            return new EvictionMetrics(){

                @Override
                public long getSize() {
                    return size;
                }

                @Override
                public long getNewEntryCount() {
                    return newEntryCounter;
                }

                @Override
                public long getRemovedCount() {
                    return removedCnt;
                }

                @Override
                public long getVirginRemovedCount() {
                    return virginRemovedCnt;
                }

                @Override
                public long getExpiredRemovedCount() {
                    return expiredRemovedCnt;
                }

                @Override
                public long getEvictedCount() {
                    return evictedCount;
                }

                @Override
                public long getMaxSize() {
                    return maxSize;
                }

                @Override
                public long getMaxWeight() {
                    return maxWeight;
                }

                @Override
                public long getTotalWeight() {
                    return totalWeight;
                }

                @Override
                public long getEvictedWeight() {
                    return evictedWeight;
                }

                @Override
                public int getEvictionRunningCount() {
                    return evictionRunningCount;
                }

                @Override
                public long getScanCount() {
                    return scanCount;
                }

                @Override
                public long getIdleNonEvictDrainCount() {
                    return idleNonEvictDrainCount;
                }
            };
        }
    }

    @Override
    public void close(InternalCacheCloseContext closeContext) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T runLocked(Supplier<T> j) {
        Object object = this.lock;
        synchronized (object) {
            return j.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            String s = "impl=" + this.getClass().getSimpleName() + ", chunkSize=" + this.chunkSize;
            s = this.isWeigherPresent() ? s + ", maxWeight=" + this.maxWeight + ", totalWeight=" + this.totalWeight : s + ", maxSize=" + this.maxSize;
            s = s + ", size=" + this.getSize();
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeCapacity(long entryCountOrWeight) {
        Entry[] chunk;
        if (entryCountOrWeight < 0L) {
            throw new IllegalArgumentException("Negative capacity or weight");
        }
        if (entryCountOrWeight <= 0L) {
            throw new IllegalArgumentException("Capacity or weight of 0 is not supported");
        }
        Object object = this.lock;
        synchronized (object) {
            this.modifyCapacityLimits(entryCountOrWeight);
            chunk = this.fillEvictionChunk(0);
        }
        while (chunk != null) {
            this.evictChunk(chunk, 0);
            object = this.lock;
            synchronized (object) {
                chunk = this.fillEvictionChunk(0);
                if (chunk == null) {
                    this.updatesSizesAfterLimitReached();
                }
            }
        }
    }

    private void modifyCapacityLimits(long entryCountOrWeight) {
        if (this.isWeigherPresent()) {
            this.maxWeight = entryCountOrWeight;
        } else {
            this.maxSize = entryCountOrWeight;
        }
    }

    @Override
    public final long removeAll() {
        long removedCount = this.removeAllFromReplacementList();
        this.totalWeight = 0L;
        return removedCount;
    }

    protected abstract long getSize();

    protected abstract long removeAllFromReplacementList();

    protected abstract void insertIntoReplacementList(Entry var1);

    protected abstract Entry findEvictionCandidate();

    protected abstract Entry findIdleCandidate(int var1);

    protected abstract void removeFromReplacementListOnEvict(Entry var1);

    protected abstract void removeFromReplacementList(Entry var1);

    protected abstract void updateHotMax();

    protected abstract long getScanCount();
}

