/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.timing;

import org.cache2k.CacheEntry;
import org.cache2k.config.Cache2kConfig;
import org.cache2k.core.Entry;
import org.cache2k.core.api.InternalCacheBuildContext;
import org.cache2k.core.api.InternalCacheCloseContext;
import org.cache2k.core.timing.StaticTiming;
import org.cache2k.expiry.ExpiryPolicy;
import org.cache2k.expiry.ValueWithExpiryTime;
import org.cache2k.io.ResiliencePolicy;

class DynamicTiming<K, V>
extends StaticTiming<K, V> {
    private final ExpiryPolicy<K, V> expiryPolicy;

    DynamicTiming(InternalCacheBuildContext<K, V> buildContext, ResiliencePolicy<K, V> resiliencePolicy) {
        super(buildContext, resiliencePolicy);
        this.expiryPolicy = DynamicTiming.constructPolicy(buildContext);
    }

    private static <K, V> ExpiryPolicy<K, V> constructPolicy(InternalCacheBuildContext<K, V> buildContext) {
        Cache2kConfig<K, V> cfg = buildContext.getConfig();
        if (cfg.getValueType() != null && ValueWithExpiryTime.class.isAssignableFrom(cfg.getValueType().getType()) && cfg.getExpiryPolicy() == null) {
            return ENTRY_EXPIRY_CALCULATOR_FROM_VALUE;
        }
        return (ExpiryPolicy)buildContext.createCustomization(cfg.getExpiryPolicy());
    }

    long calcNextRefreshTime(K key, V value, long now, CacheEntry<K, V> entry) {
        return DynamicTiming.calcNextRefreshTime(key, value, now, entry, this.expiryPolicy, this.expiryTicks, this.sharpExpiry);
    }

    @Override
    public long calculateNextRefreshTime(Entry<K, V> entry, V value, long loadTime) {
        if (entry.isDataAvailable() || entry.isExpiredState() || entry.getNextRefreshTime() == 5L) {
            return this.calcNextRefreshTime(entry.getKey(), value, loadTime, entry.getInspectionEntry());
        }
        return this.calcNextRefreshTime(entry.getKey(), value, loadTime, null);
    }

    @Override
    public synchronized void close(InternalCacheCloseContext closeContext) {
        super.close(closeContext);
        closeContext.closeCustomization(this.expiryPolicy, "expiryPolicy");
    }
}

