/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.cache2k.CacheException;
import org.cache2k.CacheManager;

public class Util {
    public static final String NAME_SEPARATOR = ":";

    public static String compactFullName(CacheManager mgr, String cacheName) {
        if (!"default".equals(mgr.getName())) {
            return mgr.getName() + NAME_SEPARATOR + cacheName;
        }
        return cacheName;
    }

    public static String formatTime(Instant t) {
        LocalDateTime ldt = t.atZone(ZoneId.systemDefault()).toLocalDateTime();
        return DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(ldt);
    }

    public static <T> T resolveSingleProvider(Class<T> spiClass, Supplier<T> fallback) {
        Iterator<T> it = ServiceLoader.load(spiClass).iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return fallback.get();
    }

    public static void waitFor(CompletableFuture<Void> future) {
        if (future == null) {
            return;
        }
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new CacheException((Throwable)e);
        }
    }
}

