/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.jcache.provider;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import javax.cache.CacheException;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.spi.CachingProvider;
import org.cache2k.Cache;
import org.cache2k.CacheManager;
import org.cache2k.core.CacheManagerImpl;
import org.cache2k.core.api.InternalCache;
import org.cache2k.jcache.provider.JCacheAdapter;
import org.cache2k.jcache.provider.JCacheBuilder;
import org.cache2k.jcache.provider.JCacheJmxSupport;
import org.cache2k.jcache.provider.JCacheProvider;
import org.cache2k.jcache.provider.TouchyJCacheAdapter;
import org.cache2k.jcache.provider.generic.storeByValueSimulation.CopyCacheProxy;

public class JCacheManagerAdapter
implements javax.cache.CacheManager {
    private static final JCacheJmxSupport JMX_SUPPORT = JCacheManagerAdapter.findJCacheJmxSupportInstance();
    private final CacheManager manager;
    private final JCacheProvider provider;
    private final Map<String, javax.cache.Cache> name2adapter = new HashMap<String, javax.cache.Cache>();
    private volatile Map<Cache, javax.cache.Cache> c2k2jCache = Collections.emptyMap();
    private final Set<String> configuredCacheNames;

    private static JCacheJmxSupport findJCacheJmxSupportInstance() {
        return JCacheJmxSupport.SINGLETON;
    }

    public JCacheManagerAdapter(JCacheProvider p, CacheManager cm) {
        this.manager = cm;
        this.provider = p;
        HashSet<String> names = new HashSet<String>();
        for (String s : this.manager.getConfiguredCacheNames()) {
            names.add(s);
        }
        this.configuredCacheNames = Collections.unmodifiableSet(names);
    }

    public CachingProvider getCachingProvider() {
        return this.provider;
    }

    public URI getURI() {
        return this.provider.name2Uri(this.manager.getName());
    }

    public ClassLoader getClassLoader() {
        return this.manager.getClassLoader();
    }

    public Properties getProperties() {
        return this.manager.getProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V, C extends Configuration<K, V>> javax.cache.Cache<K, V> createCache(String cacheName, C cfg) throws IllegalArgumentException {
        this.checkClosed();
        this.checkNonNullCacheName(cacheName);
        Object object = this.getLockObject();
        synchronized (object) {
            javax.cache.Cache jsr107cache = this.name2adapter.get(cacheName);
            if (jsr107cache != null && !jsr107cache.isClosed()) {
                throw new CacheException("cache already existing with name: " + cacheName);
            }
            Cache existingCache = this.manager.getCache(cacheName);
            if (existingCache != null && !existingCache.isClosed()) {
                throw new CacheException("A cache2k instance is already existing with name: " + cacheName);
            }
            JCacheBuilder builder = new JCacheBuilder(cacheName, this);
            builder.setConfiguration(cfg);
            javax.cache.Cache cache = builder.build();
            Cache cache2k = (Cache)cache.unwrap(Cache.class);
            WeakHashMap<Cache, javax.cache.Cache> cloneC2k2jCache = new WeakHashMap<Cache, javax.cache.Cache>(this.c2k2jCache);
            cloneC2k2jCache.put(cache2k, cache);
            this.c2k2jCache = cloneC2k2jCache;
            this.name2adapter.put(cache.getName(), cache);
            if (builder.isStatisticsEnabled()) {
                this.enableStatistics(cacheName, true);
            }
            if (builder.isManagementEnabled()) {
                this.enableManagement(cacheName, true);
            }
            return cache;
        }
    }

    private Object getLockObject() {
        return ((CacheManagerImpl)this.manager).getLockObject();
    }

    public <K, V> javax.cache.Cache<K, V> getCache(String cacheName, Class<K> keyType, Class<V> valueType) {
        if (keyType == null || valueType == null) {
            throw new NullPointerException();
        }
        javax.cache.Cache<K, V> c = this.getCache(cacheName);
        if (c == null) {
            return null;
        }
        Configuration cfg = c.getConfiguration(Configuration.class);
        if (!cfg.getKeyType().equals(keyType)) {
            throw new ClassCastException("key type mismatch, expected: " + cfg.getKeyType().getName());
        }
        if (!cfg.getValueType().equals(valueType)) {
            throw new ClassCastException("value type mismatch, expected: " + cfg.getValueType().getName());
        }
        return c;
    }

    private JCacheAdapter getAdapter(String name) {
        javax.cache.Cache ca = this.name2adapter.get(name);
        if (ca instanceof CopyCacheProxy) {
            ca = ((CopyCacheProxy)ca).getWrappedCache();
        }
        if (ca instanceof TouchyJCacheAdapter) {
            return ((TouchyJCacheAdapter)ca).cache;
        }
        return (JCacheAdapter)ca;
    }

    private void checkNonNullCacheName(String cacheName) {
        if (cacheName == null) {
            throw new NullPointerException("cache name is null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> javax.cache.Cache<K, V> getCache(String cacheName) {
        this.checkClosed();
        this.checkNonNullCacheName(cacheName);
        Object object = this.getLockObject();
        synchronized (object) {
            javax.cache.Cache c = this.name2adapter.get(cacheName);
            if (c != null && this.manager.getCache(cacheName) == c.unwrap(Cache.class) && !c.isClosed()) {
                return c;
            }
            if (this.configuredCacheNames.contains(cacheName)) {
                return this.createCache(cacheName, new MutableConfiguration());
            }
        }
        return null;
    }

    public Iterable<String> getCacheNames() {
        this.checkClosed();
        HashSet<String> names = new HashSet<String>();
        for (Cache c : this.manager.getActiveCaches()) {
            names.add(c.getName());
        }
        names.addAll(this.configuredCacheNames);
        return Collections.unmodifiableSet(names);
    }

    public void destroyCache(String cacheName) {
        this.checkClosed();
        this.checkNonNullCacheName(cacheName);
        Cache c = this.manager.getCache(cacheName);
        if (c != null) {
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableManagement(String cacheName, boolean enabled) {
        this.checkClosed();
        this.checkNonNullCacheName(cacheName);
        Object object = this.getLockObject();
        synchronized (object) {
            JCacheAdapter ca = this.getAdapter(cacheName);
            if (ca == null) {
                return;
            }
            javax.cache.Cache c = this.name2adapter.get(cacheName);
            if (enabled) {
                if (!ca.jmxEnabled) {
                    JMX_SUPPORT.enableJmx((Cache)ca.cache, c);
                    ca.jmxEnabled = true;
                }
            } else if (ca.jmxEnabled) {
                JMX_SUPPORT.disableJmx((Cache)ca.cache);
                ca.jmxEnabled = false;
            }
        }
    }

    private void checkClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("cache manager is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableStatistics(String cacheName, boolean enabled) {
        this.checkClosed();
        this.checkNonNullCacheName(cacheName);
        Object object = this.getLockObject();
        synchronized (object) {
            if (enabled) {
                JCacheAdapter ca = this.getAdapter(cacheName);
                if (ca != null) {
                    InternalCache internalCache = ca.cache;
                    synchronized (internalCache) {
                        if (!ca.jmxStatisticsEnabled) {
                            JMX_SUPPORT.enableStatistics(ca);
                            ca.jmxStatisticsEnabled = true;
                        }
                    }
                }
            } else {
                JCacheAdapter ca = this.getAdapter(cacheName);
                if (ca != null) {
                    InternalCache internalCache = ca.cache;
                    synchronized (internalCache) {
                        if (ca.jmxStatisticsEnabled) {
                            JMX_SUPPORT.disableStatistics((Cache)ca.cache);
                            ca.jmxStatisticsEnabled = false;
                        }
                    }
                }
            }
        }
    }

    public void close() {
        this.manager.close();
    }

    public boolean isClosed() {
        return this.manager.isClosed();
    }

    public <T> T unwrap(Class<T> type) {
        if (CacheManager.class.isAssignableFrom(type)) {
            return (T)this.manager;
        }
        throw new IllegalArgumentException("requested unwrap class not available");
    }

    public CacheManager getCache2kManager() {
        return this.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public javax.cache.Cache resolveCacheWrapper(Cache c2kCache) {
        Object object = this.getLockObject();
        synchronized (object) {
            return this.c2k2jCache.get(c2kCache);
        }
    }
}

