/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.jcache.provider.event;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import javax.cache.CacheException;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.EventType;
import org.cache2k.Cache;
import org.cache2k.CacheEntry;
import org.cache2k.annotation.Nullable;
import org.cache2k.config.Cache2kConfig;
import org.cache2k.config.CustomizationReferenceSupplier;
import org.cache2k.event.CacheClosedListener;
import org.cache2k.event.CacheEntryCreatedListener;
import org.cache2k.event.CacheEntryExpiredListener;
import org.cache2k.event.CacheEntryRemovedListener;
import org.cache2k.event.CacheEntryUpdatedListener;
import org.cache2k.jcache.provider.JCacheManagerAdapter;
import org.cache2k.jcache.provider.event.AsyncDispatcher;
import org.cache2k.jcache.provider.event.EntryEvent;
import org.cache2k.jcache.provider.event.EntryEventWithOldValue;
import org.cache2k.jcache.provider.event.EventHandling;
import org.cache2k.jcache.provider.event.Listener;

public class EventHandlingImpl<K, V>
implements EventHandling<K, V>,
CacheClosedListener {
    private javax.cache.Cache resolvedJCache;
    private final List<Listener.Created<K, V>> createdListener = new CopyOnWriteArrayList<Listener.Created<K, V>>();
    private final List<Listener.Updated<K, V>> updatedListener = new CopyOnWriteArrayList<Listener.Updated<K, V>>();
    private final List<Listener.Removed<K, V>> removedListener = new CopyOnWriteArrayList<Listener.Removed<K, V>>();
    private final List<Listener.Expired<K, V>> expiredListener = new CopyOnWriteArrayList<Listener.Expired<K, V>>();
    private final AsyncDispatcher<K, V> asyncDispatcher;
    private final JCacheManagerAdapter manager;

    public EventHandlingImpl(JCacheManagerAdapter m, Executor ex) {
        this.asyncDispatcher = new AsyncDispatcher(ex);
        this.manager = m;
    }

    void addAsyncListener(Listener<K, V> l) {
        this.asyncDispatcher.addAsyncListener(l);
    }

    static <T extends Listener<K, V>, K, V> boolean removeCfgMatch(CacheEntryListenerConfiguration<K, V> cfg, List<T> listenerList) {
        for (Listener l : listenerList) {
            if (!l.config.equals(cfg)) continue;
            listenerList.remove(l);
            EventHandlingImpl.removeCfgMatch(cfg, listenerList);
            return true;
        }
        return false;
    }

    @Override
    public boolean deregisterListener(CacheEntryListenerConfiguration<K, V> cfg) {
        return EventHandlingImpl.removeCfgMatch(cfg, this.createdListener) | EventHandlingImpl.removeCfgMatch(cfg, this.updatedListener) | EventHandlingImpl.removeCfgMatch(cfg, this.removedListener) | EventHandlingImpl.removeCfgMatch(cfg, this.expiredListener) | this.asyncDispatcher.removeAsyncListener(cfg);
    }

    @Override
    public Collection<CacheEntryListenerConfiguration<K, V>> getAllListenerConfigurations() {
        Collection<Listener<K, V>> l = this.getAllListeners();
        HashSet<CacheEntryListenerConfiguration<K, V>> cfgs = new HashSet<CacheEntryListenerConfiguration<K, V>>();
        for (Listener<K, V> li : l) {
            cfgs.add(li.config);
        }
        return cfgs;
    }

    private Collection<Listener<K, V>> getAllListeners() {
        ArrayList l = new ArrayList();
        l.addAll(this.createdListener);
        l.addAll(this.updatedListener);
        l.addAll(this.removedListener);
        l.addAll(this.expiredListener);
        this.asyncDispatcher.collectListeners(l);
        return l;
    }

    @Nullable
    public CompletableFuture<Void> onCacheClosed(Cache cache) {
        HashSet ls = new HashSet();
        for (Listener<K, V> listener : this.getAllListeners()) {
            ls.add(listener.entryListener);
        }
        for (CacheEntryListener cacheEntryListener : ls) {
            if (!(cacheEntryListener instanceof Closeable)) continue;
            try {
                ((Closeable)cacheEntryListener).close();
            }
            catch (Exception e) {
                throw new CacheException("closing listener", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(CacheEntryListenerConfiguration<K, V> cfg) {
        Listener l;
        AsyncDispatcher<K, V> asyncDispatcher = this.asyncDispatcher;
        synchronized (asyncDispatcher) {
            if (this.getAllListenerConfigurations().contains(cfg)) {
                throw new IllegalArgumentException("configuration already registered");
            }
        }
        Factory filterFactory = cfg.getCacheEntryEventFilterFactory();
        Factory listenerFactory = cfg.getCacheEntryListenerFactory();
        if (listenerFactory == null) {
            throw new IllegalArgumentException("listener factory missing");
        }
        CacheEntryEventFilter filter = null;
        if (filterFactory != null) {
            filter = (CacheEntryEventFilter)filterFactory.create();
        }
        Object listener = listenerFactory.create();
        boolean synchronous = cfg.isSynchronous();
        if (listener instanceof javax.cache.event.CacheEntryCreatedListener) {
            l = new Listener.Created<K, V>(cfg, filter, (javax.cache.event.CacheEntryCreatedListener)listener);
            if (synchronous) {
                this.createdListener.add((Listener.Created<K, V>)l);
            } else {
                this.addAsyncListener(l);
            }
        }
        if (listener instanceof javax.cache.event.CacheEntryUpdatedListener) {
            l = new Listener.Updated<K, V>(cfg, filter, (javax.cache.event.CacheEntryUpdatedListener)listener);
            if (synchronous) {
                this.updatedListener.add((Listener.Updated<K, V>)l);
            } else {
                this.addAsyncListener(l);
            }
        }
        if (listener instanceof javax.cache.event.CacheEntryRemovedListener) {
            l = new Listener.Removed<K, V>(cfg, filter, (javax.cache.event.CacheEntryRemovedListener)listener);
            if (synchronous) {
                this.removedListener.add((Listener.Removed<K, V>)l);
            } else {
                this.addAsyncListener(l);
            }
        }
        if (listener instanceof javax.cache.event.CacheEntryExpiredListener) {
            l = new Listener.Expired<K, V>(cfg, filter, (javax.cache.event.CacheEntryExpiredListener)listener);
            if (synchronous) {
                this.expiredListener.add((Listener.Expired<K, V>)l);
            } else {
                this.addAsyncListener(l);
            }
        }
    }

    @Override
    public void addInternalListenersToCache2kConfiguration(Cache2kConfig<K, V> cfg) {
        Collection listeners = cfg.getListeners();
        listeners.add(new CustomizationReferenceSupplier((Object)new CreatedListenerAdapter()));
        listeners.add(new CustomizationReferenceSupplier((Object)new UpdatedListenerAdapter()));
        listeners.add(new CustomizationReferenceSupplier((Object)new RemovedListenerAdapter()));
        listeners.add(new CustomizationReferenceSupplier((Object)new ExpiredListenerAdapter()));
    }

    private V extractValue(V value) {
        return value;
    }

    private void fireCreated(javax.cache.Cache<K, V> jCache, CacheEntry<K, V> e) {
        EntryEvent<Object, Object> cee = new EntryEvent<Object, Object>(jCache, EventType.CREATED, e.getKey(), this.extractValue(e.getValue()));
        this.asyncDispatcher.deliverAsyncEvent(cee);
        for (Listener listener : this.createdListener) {
            listener.fire(cee);
        }
    }

    private javax.cache.Cache getCache(Cache<K, V> c) {
        if (this.resolvedJCache != null) {
            return this.resolvedJCache;
        }
        this.resolvedJCache = this.manager.resolveCacheWrapper(c);
        return this.resolvedJCache;
    }

    class ExpiredListenerAdapter
    implements CacheEntryExpiredListener<K, V> {
        ExpiredListenerAdapter() {
        }

        public void onEntryExpired(Cache<K, V> c, CacheEntry<K, V> e) {
            if (e.getException() != null) {
                return;
            }
            javax.cache.Cache jCache = EventHandlingImpl.this.getCache(c);
            EntryEvent<Object, Object> cee = new EntryEvent<Object, Object>(jCache, EventType.EXPIRED, e.getKey(), EventHandlingImpl.this.extractValue(e.getValue()));
            EventHandlingImpl.this.asyncDispatcher.deliverAsyncEvent(cee);
            for (Listener t : EventHandlingImpl.this.expiredListener) {
                t.fire(cee);
            }
        }
    }

    class RemovedListenerAdapter
    implements CacheEntryRemovedListener<K, V> {
        RemovedListenerAdapter() {
        }

        public void onEntryRemoved(Cache<K, V> c, CacheEntry<K, V> e) {
            if (e.getException() != null) {
                return;
            }
            javax.cache.Cache jCache = EventHandlingImpl.this.getCache(c);
            Object val = EventHandlingImpl.this.extractValue(e.getValue());
            EntryEventWithOldValue<Object, Object> cee = new EntryEventWithOldValue<Object, Object>(jCache, EventType.REMOVED, e.getKey(), val, val);
            EventHandlingImpl.this.asyncDispatcher.deliverAsyncEvent(cee);
            for (Listener t : EventHandlingImpl.this.removedListener) {
                t.fire(cee);
            }
        }
    }

    class UpdatedListenerAdapter
    implements CacheEntryUpdatedListener<K, V> {
        UpdatedListenerAdapter() {
        }

        public void onEntryUpdated(Cache<K, V> c, CacheEntry<K, V> currentEntry, CacheEntry<K, V> newEntry) {
            javax.cache.Cache jCache = EventHandlingImpl.this.getCache(c);
            if (newEntry.getException() != null) {
                if (currentEntry.getException() != null) {
                    return;
                }
                EntryEvent<Object, Object> cee = new EntryEvent<Object, Object>(jCache, EventType.REMOVED, newEntry.getKey(), EventHandlingImpl.this.extractValue(currentEntry.getValue()));
                EventHandlingImpl.this.asyncDispatcher.deliverAsyncEvent(cee);
                for (Listener t : EventHandlingImpl.this.removedListener) {
                    t.fire(cee);
                }
                return;
            }
            if (currentEntry.getException() != null) {
                EventHandlingImpl.this.fireCreated(jCache, newEntry);
                return;
            }
            Object v0 = currentEntry.getValue();
            Object v1 = newEntry.getValue();
            EntryEventWithOldValue<Object, Object> cee = new EntryEventWithOldValue<Object, Object>(jCache, EventType.UPDATED, newEntry.getKey(), EventHandlingImpl.this.extractValue(v1), EventHandlingImpl.this.extractValue(v0));
            EventHandlingImpl.this.asyncDispatcher.deliverAsyncEvent(cee);
            for (Listener t : EventHandlingImpl.this.updatedListener) {
                t.fire(cee);
            }
        }
    }

    class CreatedListenerAdapter
    implements CacheEntryCreatedListener<K, V> {
        CreatedListenerAdapter() {
        }

        public void onEntryCreated(Cache<K, V> c, CacheEntry<K, V> e) {
            if (e.getException() != null) {
                return;
            }
            javax.cache.Cache jCache = EventHandlingImpl.this.getCache(c);
            EventHandlingImpl.this.fireCreated(jCache, e);
        }
    }
}

