/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.jcache.provider.event;

import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;
import org.cache2k.jcache.provider.event.EntryEvent;

abstract class Listener<K, V> {
    CacheEntryListenerConfiguration<K, V> config;
    CacheEntryEventFilter<K, V> filter;
    CacheEntryListener<K, V> entryListener;

    Listener(CacheEntryListenerConfiguration<K, V> config, CacheEntryEventFilter<K, V> filter, CacheEntryListener<K, V> entryListener) {
        this.config = config;
        this.filter = filter;
        this.entryListener = entryListener;
    }

    public abstract EventType getEventType();

    public abstract void fire(EntryEvent<K, V> var1);

    static class Expired<K, V>
    extends Listener<K, V> {
        CacheEntryExpiredListener<K, V> listener;

        Expired(CacheEntryListenerConfiguration<K, V> config, CacheEntryEventFilter<K, V> filter, CacheEntryExpiredListener<K, V> listener) {
            super(config, filter, listener);
            this.listener = listener;
        }

        @Override
        public EventType getEventType() {
            return EventType.EXPIRED;
        }

        @Override
        public void fire(EntryEvent<K, V> e) {
            if (this.filter != null && !this.filter.evaluate(e)) {
                return;
            }
            this.listener.onExpired(e);
        }
    }

    static class Removed<K, V>
    extends Listener<K, V> {
        CacheEntryRemovedListener<K, V> listener;

        Removed(CacheEntryListenerConfiguration<K, V> config, CacheEntryEventFilter<K, V> filter, CacheEntryRemovedListener<K, V> listener) {
            super(config, filter, listener);
            this.listener = listener;
        }

        @Override
        public EventType getEventType() {
            return EventType.REMOVED;
        }

        @Override
        public void fire(EntryEvent<K, V> e) {
            if (this.filter != null && !this.filter.evaluate(e)) {
                return;
            }
            this.listener.onRemoved(e);
        }
    }

    static class Updated<K, V>
    extends Listener<K, V> {
        CacheEntryUpdatedListener<K, V> listener;

        Updated(CacheEntryListenerConfiguration<K, V> config, CacheEntryEventFilter<K, V> filter, CacheEntryUpdatedListener<K, V> listener) {
            super(config, filter, listener);
            this.listener = listener;
        }

        @Override
        public EventType getEventType() {
            return EventType.UPDATED;
        }

        @Override
        public void fire(EntryEvent<K, V> e) {
            if (this.filter != null && !this.filter.evaluate(e)) {
                return;
            }
            this.listener.onUpdated(e);
        }
    }

    static class Created<K, V>
    extends Listener<K, V> {
        CacheEntryCreatedListener<K, V> listener;

        Created(CacheEntryListenerConfiguration<K, V> config, CacheEntryEventFilter<K, V> filter, CacheEntryCreatedListener<K, V> listener) {
            super(config, filter, listener);
            this.listener = listener;
        }

        @Override
        public EventType getEventType() {
            return EventType.CREATED;
        }

        @Override
        public void fire(EntryEvent<K, V> e) {
            if (this.filter != null && !this.filter.evaluate(e)) {
                return;
            }
            this.listener.onCreated(e);
        }
    }
}

