/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricTaskInstanceReport;
import org.camunda.bpm.engine.history.HistoricTaskInstanceReportResult;
import org.camunda.bpm.engine.rest.dto.AbstractReportDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.converter.DateConverter;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;

public class HistoricTaskInstanceReportQueryDto
extends AbstractReportDto<HistoricTaskInstanceReport> {
    public static final String PROCESS_DEFINITION = "processDefinition";
    public static final String TASK_NAME = "taskName";
    protected Date completedBefore;
    protected Date completedAfter;
    protected String groupby;

    public HistoricTaskInstanceReportQueryDto() {
    }

    public HistoricTaskInstanceReportQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    public Date getCompletedBefore() {
        return this.completedBefore;
    }

    public Date getCompletedAfter() {
        return this.completedAfter;
    }

    public String getGroupBy() {
        return this.groupby;
    }

    @CamundaQueryParam(value="completedAfter", converter=DateConverter.class)
    public void setCompletedAfter(Date completedAfter) {
        this.completedAfter = completedAfter;
    }

    @CamundaQueryParam(value="completedBefore", converter=DateConverter.class)
    public void setCompletedBefore(Date completedBefore) {
        this.completedBefore = completedBefore;
    }

    @CamundaQueryParam(value="groupBy")
    public void setGroupBy(String groupby) {
        this.groupby = groupby;
    }

    @Override
    protected void applyFilters(HistoricTaskInstanceReport reportQuery) {
        if (this.completedBefore != null) {
            reportQuery.completedBefore(this.completedBefore);
        }
        if (this.completedAfter != null) {
            reportQuery.completedAfter(this.completedAfter);
        }
        if ("duration".equals(this.reportType) && this.periodUnit == null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "periodUnit is null");
        }
    }

    @Override
    protected HistoricTaskInstanceReport createNewReportQuery(ProcessEngine engine) {
        return engine.getHistoryService().createHistoricTaskInstanceReport();
    }

    public List<HistoricTaskInstanceReportResult> executeCompletedReport(ProcessEngine engine) {
        HistoricTaskInstanceReport reportQuery = this.createNewReportQuery(engine);
        this.applyFilters(reportQuery);
        if (PROCESS_DEFINITION.equals(this.groupby)) {
            return reportQuery.countByProcessDefinitionKey();
        }
        if (TASK_NAME.equals(this.groupby)) {
            return reportQuery.countByTaskName();
        }
        throw new InvalidRequestException(Response.Status.BAD_REQUEST, "groupBy parameter has invalid value: " + this.groupby);
    }
}

