/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.runtime;

import jakarta.ws.rs.core.Response;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.rest.dto.SuspensionStateDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricProcessInstanceQueryDto;
import org.camunda.bpm.engine.rest.dto.runtime.ProcessInstanceQueryDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.runtime.UpdateProcessInstanceSuspensionStateSelectBuilder;
import org.camunda.bpm.engine.runtime.UpdateProcessInstancesSuspensionStateBuilder;

public class ProcessInstanceSuspensionStateAsyncDto
extends SuspensionStateDto {
    protected List<String> processInstanceIds;
    protected ProcessInstanceQueryDto processInstanceQuery;
    protected HistoricProcessInstanceQueryDto historicProcessInstanceQuery;

    public List<String> getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    public void setProcessInstanceIds(List<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
    }

    public ProcessInstanceQueryDto getProcessInstanceQuery() {
        return this.processInstanceQuery;
    }

    public void setProcessInstanceQuery(ProcessInstanceQueryDto processInstanceQuery) {
        this.processInstanceQuery = processInstanceQuery;
    }

    public void setHistoricProcessInstanceQuery(HistoricProcessInstanceQueryDto historicProcessInstanceQuery) {
        this.historicProcessInstanceQuery = historicProcessInstanceQuery;
    }

    public HistoricProcessInstanceQueryDto getHistoricProcessInstanceQuery() {
        return this.historicProcessInstanceQuery;
    }

    public Batch updateSuspensionStateAsync(ProcessEngine engine) {
        int params = this.parameterCount(this.processInstanceIds, this.processInstanceQuery, this.historicProcessInstanceQuery);
        if (params == 0) {
            String message = "Either processInstanceIds, processInstanceQuery or historicProcessInstanceQuery should be set to update the suspension state.";
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, message);
        }
        UpdateProcessInstancesSuspensionStateBuilder updateSuspensionStateBuilder = this.createUpdateSuspensionStateGroupBuilder(engine);
        if (this.getSuspended()) {
            return updateSuspensionStateBuilder.suspendAsync();
        }
        return updateSuspensionStateBuilder.activateAsync();
    }

    protected UpdateProcessInstancesSuspensionStateBuilder createUpdateSuspensionStateGroupBuilder(ProcessEngine engine) {
        UpdateProcessInstanceSuspensionStateSelectBuilder selectBuilder = engine.getRuntimeService().updateProcessInstanceSuspensionState();
        UpdateProcessInstancesSuspensionStateBuilder groupBuilder = null;
        if (this.processInstanceIds != null) {
            groupBuilder = selectBuilder.byProcessInstanceIds(this.processInstanceIds);
        }
        if (this.processInstanceQuery != null) {
            if (groupBuilder == null) {
                groupBuilder = selectBuilder.byProcessInstanceQuery((ProcessInstanceQuery)this.processInstanceQuery.toQuery(engine));
            } else {
                groupBuilder.byProcessInstanceQuery((ProcessInstanceQuery)this.processInstanceQuery.toQuery(engine));
            }
        }
        if (this.historicProcessInstanceQuery != null) {
            if (groupBuilder == null) {
                groupBuilder = selectBuilder.byHistoricProcessInstanceQuery((HistoricProcessInstanceQuery)this.historicProcessInstanceQuery.toQuery(engine));
            } else {
                groupBuilder.byHistoricProcessInstanceQuery((HistoricProcessInstanceQuery)this.historicProcessInstanceQuery.toQuery(engine));
            }
        }
        return groupBuilder;
    }

    protected int parameterCount(Object ... o) {
        int count = 0;
        for (Object o1 : o) {
            count += o1 != null ? 1 : 0;
        }
        return count;
    }
}

