/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.hal;

import jakarta.ws.rs.core.MediaType;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.rest.CaseDefinitionRestService;
import org.camunda.bpm.engine.rest.GroupRestService;
import org.camunda.bpm.engine.rest.IdentityRestService;
import org.camunda.bpm.engine.rest.ProcessDefinitionRestService;
import org.camunda.bpm.engine.rest.UserRestService;
import org.camunda.bpm.engine.rest.cache.Cache;
import org.camunda.bpm.engine.rest.hal.HalLinkResolver;
import org.camunda.bpm.engine.rest.hal.HalLinker;
import org.camunda.bpm.engine.rest.hal.HalResource;
import org.camunda.bpm.engine.rest.hal.caseDefinition.HalCaseDefinitionResolver;
import org.camunda.bpm.engine.rest.hal.group.HalGroupResolver;
import org.camunda.bpm.engine.rest.hal.identitylink.HalIdentityLinkResolver;
import org.camunda.bpm.engine.rest.hal.processDefinition.HalProcessDefinitionResolver;
import org.camunda.bpm.engine.rest.hal.user.HalUserResolver;

public class Hal {
    public static final String APPLICATION_HAL_JSON = "application/hal+json";
    public static final MediaType APPLICATION_HAL_JSON_TYPE = new MediaType("application", "hal+json");
    public static Hal instance = new Hal();
    protected Map<Class<?>, HalLinkResolver> halLinkResolvers = new HashMap();
    protected Map<Class<?>, Cache> halRelationCaches = new HashMap();

    public Hal() {
        this.halLinkResolvers.put(UserRestService.class, new HalUserResolver());
        this.halLinkResolvers.put(GroupRestService.class, new HalGroupResolver());
        this.halLinkResolvers.put(ProcessDefinitionRestService.class, new HalProcessDefinitionResolver());
        this.halLinkResolvers.put(CaseDefinitionRestService.class, new HalCaseDefinitionResolver());
        this.halLinkResolvers.put(IdentityRestService.class, new HalIdentityLinkResolver());
    }

    public static Hal getInstance() {
        return instance;
    }

    public HalLinker createLinker(HalResource<?> resource) {
        return new HalLinker(this, resource);
    }

    public HalLinkResolver getLinkResolver(Class<?> resourceClass) {
        return this.halLinkResolvers.get(resourceClass);
    }

    public void registerHalRelationCache(Class<?> entityClass, Cache cache) {
        this.halRelationCaches.put(entityClass, cache);
    }

    public Cache getHalRelationCache(Class<?> resourceClass) {
        return this.halRelationCaches.get(resourceClass);
    }

    public void destroyHalRelationCaches() {
        for (Cache cache : this.halRelationCaches.values()) {
            cache.destroy();
        }
        this.halRelationCaches.clear();
    }
}

