/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.repository.DeploymentWithDefinitions;
import org.camunda.bpm.engine.rest.DeploymentRestService;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.repository.DeploymentDto;
import org.camunda.bpm.engine.rest.dto.repository.DeploymentQueryDto;
import org.camunda.bpm.engine.rest.dto.repository.DeploymentWithDefinitionsDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.camunda.bpm.engine.rest.mapper.MultipartFormData;
import org.camunda.bpm.engine.rest.sub.repository.DeploymentResource;
import org.camunda.bpm.engine.rest.sub.repository.impl.DeploymentResourceImpl;
import org.camunda.bpm.engine.rest.util.QueryUtil;

public class DeploymentRestServiceImpl
extends AbstractRestProcessEngineAware
implements DeploymentRestService {
    public static final String DEPLOYMENT_NAME = "deployment-name";
    public static final String DEPLOYMENT_ACTIVATION_TIME = "deployment-activation-time";
    public static final String ENABLE_DUPLICATE_FILTERING = "enable-duplicate-filtering";
    public static final String DEPLOY_CHANGED_ONLY = "deploy-changed-only";
    public static final String DEPLOYMENT_SOURCE = "deployment-source";
    public static final String TENANT_ID = "tenant-id";
    protected static final Set<String> RESERVED_KEYWORDS = new HashSet<String>();

    public DeploymentRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public DeploymentResource getDeployment(String deploymentId) {
        return new DeploymentResourceImpl(this.getProcessEngine().getName(), deploymentId, this.relativeRootResourcePath, this.getObjectMapper());
    }

    @Override
    public List<DeploymentDto> getDeployments(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        DeploymentQueryDto queryDto = new DeploymentQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        ProcessEngine engine = this.getProcessEngine();
        DeploymentQuery query = (DeploymentQuery)queryDto.toQuery(engine);
        List<Deployment> matchingDeployments = QueryUtil.list(query, firstResult, maxResults);
        ArrayList<DeploymentDto> deployments = new ArrayList<DeploymentDto>();
        for (Deployment deployment : matchingDeployments) {
            DeploymentDto def = DeploymentDto.fromDeployment(deployment);
            deployments.add(def);
        }
        return deployments;
    }

    @Override
    public DeploymentWithDefinitionsDto createDeployment(UriInfo uriInfo, MultipartFormData payload) {
        DeploymentBuilder deploymentBuilder = this.extractDeploymentInformation(payload);
        if (!deploymentBuilder.getResourceNames().isEmpty()) {
            DeploymentWithDefinitions deployment = deploymentBuilder.deployWithResult();
            DeploymentWithDefinitionsDto deploymentDto = DeploymentWithDefinitionsDto.fromDeployment(deployment);
            URI uri = uriInfo.getBaseUriBuilder().path(this.relativeRootResourcePath).path("/deployment").path(deployment.getId()).build(new Object[0]);
            deploymentDto.addReflexiveLink(uri, "GET", "self");
            return deploymentDto;
        }
        throw new InvalidRequestException(Response.Status.BAD_REQUEST, "No deployment resources contained in the form upload.");
    }

    private DeploymentBuilder extractDeploymentInformation(MultipartFormData payload) {
        MultipartFormData.FormPart deploymentTenantId;
        MultipartFormData.FormPart deploymentSource;
        MultipartFormData.FormPart deploymentActivationTime;
        DeploymentBuilder deploymentBuilder = this.getProcessEngine().getRepositoryService().createDeployment();
        Set<String> partNames = payload.getPartNames();
        for (String name : partNames) {
            MultipartFormData.FormPart part = payload.getNamedPart(name);
            if (RESERVED_KEYWORDS.contains(name)) continue;
            String fileName = part.getFileName();
            if (fileName != null) {
                deploymentBuilder.addInputStream(part.getFileName(), (InputStream)new ByteArrayInputStream(part.getBinaryContent()));
                continue;
            }
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "No file name found in the deployment resource described by form parameter '" + fileName + "'.");
        }
        MultipartFormData.FormPart deploymentName = payload.getNamedPart(DEPLOYMENT_NAME);
        if (deploymentName != null) {
            deploymentBuilder.name(deploymentName.getTextContent());
        }
        if ((deploymentActivationTime = payload.getNamedPart(DEPLOYMENT_ACTIVATION_TIME)) != null && !deploymentActivationTime.getTextContent().isEmpty()) {
            deploymentBuilder.activateProcessDefinitionsOn(DateTimeUtil.parseDate((String)deploymentActivationTime.getTextContent()));
        }
        if ((deploymentSource = payload.getNamedPart(DEPLOYMENT_SOURCE)) != null) {
            deploymentBuilder.source(deploymentSource.getTextContent());
        }
        if ((deploymentTenantId = payload.getNamedPart(TENANT_ID)) != null) {
            deploymentBuilder.tenantId(deploymentTenantId.getTextContent());
        }
        this.extractDuplicateFilteringForDeployment(payload, deploymentBuilder);
        return deploymentBuilder;
    }

    private void extractDuplicateFilteringForDeployment(MultipartFormData payload, DeploymentBuilder deploymentBuilder) {
        MultipartFormData.FormPart deploymentDeployChangedOnly;
        boolean enableDuplicateFiltering = false;
        boolean deployChangedOnly = false;
        MultipartFormData.FormPart deploymentEnableDuplicateFiltering = payload.getNamedPart(ENABLE_DUPLICATE_FILTERING);
        if (deploymentEnableDuplicateFiltering != null) {
            enableDuplicateFiltering = Boolean.parseBoolean(deploymentEnableDuplicateFiltering.getTextContent());
        }
        if ((deploymentDeployChangedOnly = payload.getNamedPart(DEPLOY_CHANGED_ONLY)) != null) {
            deployChangedOnly = Boolean.parseBoolean(deploymentDeployChangedOnly.getTextContent());
        }
        if (deployChangedOnly) {
            deploymentBuilder.enableDuplicateFiltering(true);
        } else if (enableDuplicateFiltering) {
            deploymentBuilder.enableDuplicateFiltering(false);
        }
    }

    @Override
    public CountResultDto getDeploymentsCount(UriInfo uriInfo) {
        DeploymentQueryDto queryDto = new DeploymentQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        ProcessEngine engine = this.getProcessEngine();
        DeploymentQuery query = (DeploymentQuery)queryDto.toQuery(engine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }

    @Override
    public Set<String> getRegisteredDeployments(UriInfo uriInfo) {
        return this.getProcessEngine().getManagementService().getRegisteredDeployments();
    }

    static {
        RESERVED_KEYWORDS.add(DEPLOYMENT_NAME);
        RESERVED_KEYWORDS.add(DEPLOYMENT_ACTIVATION_TIME);
        RESERVED_KEYWORDS.add(ENABLE_DUPLICATE_FILTERING);
        RESERVED_KEYWORDS.add(DEPLOY_CHANGED_ONLY);
        RESERVED_KEYWORDS.add(DEPLOYMENT_SOURCE);
        RESERVED_KEYWORDS.add(TENANT_ID);
    }
}

