/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.core.Variant;
import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.rest.TaskRestService;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.task.TaskDto;
import org.camunda.bpm.engine.rest.dto.task.TaskQueryDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.hal.Hal;
import org.camunda.bpm.engine.rest.hal.task.HalTaskList;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.camunda.bpm.engine.rest.sub.task.TaskReportResource;
import org.camunda.bpm.engine.rest.sub.task.TaskResource;
import org.camunda.bpm.engine.rest.sub.task.impl.TaskReportResourceImpl;
import org.camunda.bpm.engine.rest.sub.task.impl.TaskResourceImpl;
import org.camunda.bpm.engine.rest.util.QueryUtil;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;

public class TaskRestServiceImpl
extends AbstractRestProcessEngineAware
implements TaskRestService {
    public static final List<Variant> VARIANTS = Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON_TYPE, Hal.APPLICATION_HAL_JSON_TYPE}).add().build();

    public TaskRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public Object getTasks(Request request, UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        Variant variant = request.selectVariant(VARIANTS);
        if (variant != null) {
            if (MediaType.APPLICATION_JSON_TYPE.equals((Object)variant.getMediaType())) {
                return this.getJsonTasks(uriInfo, firstResult, maxResults);
            }
            if (Hal.APPLICATION_HAL_JSON_TYPE.equals((Object)variant.getMediaType())) {
                return this.getHalTasks(uriInfo, firstResult, maxResults);
            }
        }
        throw new InvalidRequestException(Response.Status.NOT_ACCEPTABLE, "No acceptable content-type found");
    }

    public List<TaskDto> getJsonTasks(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        TaskQueryDto queryDto = new TaskQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryTasks(queryDto, firstResult, maxResults);
    }

    public HalTaskList getHalTasks(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        TaskQueryDto queryDto = new TaskQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        ProcessEngine engine = this.getProcessEngine();
        TaskQuery query = (TaskQuery)queryDto.toQuery(engine);
        List<Task> matchingTasks = this.executeTaskQuery(firstResult, maxResults, query);
        long count = query.count();
        return HalTaskList.generate(matchingTasks, count, engine);
    }

    @Override
    public List<TaskDto> queryTasks(TaskQueryDto queryDto, Integer firstResult, Integer maxResults) {
        ProcessEngine engine = this.getProcessEngine();
        queryDto.setObjectMapper(this.getObjectMapper());
        TaskQuery query = (TaskQuery)queryDto.toQuery(engine);
        List<Task> matchingTasks = this.executeTaskQuery(firstResult, maxResults, query);
        ArrayList<TaskDto> tasks = new ArrayList<TaskDto>();
        for (Task task : matchingTasks) {
            TaskDto returnTask = TaskDto.fromEntity(task);
            tasks.add(returnTask);
        }
        return tasks;
    }

    protected List<Task> executeTaskQuery(Integer firstResult, Integer maxResults, TaskQuery query) {
        query.initializeFormKeys();
        return QueryUtil.list(query, firstResult, maxResults);
    }

    @Override
    public CountResultDto getTasksCount(UriInfo uriInfo) {
        TaskQueryDto queryDto = new TaskQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryTasksCount(queryDto);
    }

    @Override
    public CountResultDto queryTasksCount(TaskQueryDto queryDto) {
        ProcessEngine engine = this.getProcessEngine();
        queryDto.setObjectMapper(this.getObjectMapper());
        TaskQuery query = (TaskQuery)queryDto.toQuery(engine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }

    @Override
    public TaskResource getTask(String id) {
        return new TaskResourceImpl(this.getProcessEngine(), id, this.relativeRootResourcePath, this.getObjectMapper());
    }

    @Override
    public void createTask(TaskDto taskDto) {
        ProcessEngine engine = this.getProcessEngine();
        TaskService taskService = engine.getTaskService();
        Task newTask = taskService.newTask(taskDto.getId());
        taskDto.updateTask(newTask);
        try {
            taskService.saveTask(newTask);
        }
        catch (NotValidException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), "Could not save task: " + e.getMessage());
        }
    }

    @Override
    public TaskReportResource getTaskReportResource() {
        return new TaskReportResourceImpl(this.getProcessEngine());
    }
}

