/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.List;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.identity.Tenant;
import org.camunda.bpm.engine.identity.TenantQuery;
import org.camunda.bpm.engine.rest.TenantRestService;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.ResourceOptionsDto;
import org.camunda.bpm.engine.rest.dto.identity.TenantDto;
import org.camunda.bpm.engine.rest.dto.identity.TenantQueryDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.impl.AbstractAuthorizedRestResource;
import org.camunda.bpm.engine.rest.sub.identity.TenantResource;
import org.camunda.bpm.engine.rest.sub.identity.impl.TenantResourceImpl;
import org.camunda.bpm.engine.rest.util.PathUtil;
import org.camunda.bpm.engine.rest.util.QueryUtil;

public class TenantRestServiceImpl
extends AbstractAuthorizedRestResource
implements TenantRestService {
    public TenantRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, (Resource)Resources.TENANT, "*", objectMapper);
    }

    @Override
    public TenantResource getTenant(String id) {
        id = PathUtil.decodePathParam(id);
        return new TenantResourceImpl(this.getProcessEngine().getName(), id, this.relativeRootResourcePath, this.getObjectMapper());
    }

    @Override
    public List<TenantDto> queryTenants(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        TenantQueryDto queryDto = new TenantQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        TenantQuery query = (TenantQuery)queryDto.toQuery(this.getProcessEngine());
        List<Tenant> tenants = QueryUtil.list(query, firstResult, maxResults);
        return TenantDto.fromTenantList(tenants);
    }

    @Override
    public CountResultDto getTenantCount(UriInfo uriInfo) {
        TenantQueryDto queryDto = new TenantQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        TenantQuery query = (TenantQuery)queryDto.toQuery(this.getProcessEngine());
        long count = query.count();
        return new CountResultDto(count);
    }

    @Override
    public void createTenant(TenantDto dto) {
        if (this.getIdentityService().isReadOnly()) {
            throw new InvalidRequestException(Response.Status.FORBIDDEN, "Identity service implementation is read-only.");
        }
        Tenant newTenant = this.getIdentityService().newTenant(dto.getId());
        dto.update(newTenant);
        this.getIdentityService().saveTenant(newTenant);
    }

    @Override
    public ResourceOptionsDto availableOperations(UriInfo context) {
        UriBuilder baseUriBuilder = context.getBaseUriBuilder().path(this.relativeRootResourcePath).path("/tenant");
        ResourceOptionsDto resourceOptionsDto = new ResourceOptionsDto();
        URI baseUri = baseUriBuilder.build(new Object[0]);
        resourceOptionsDto.addReflexiveLink(baseUri, "GET", "list");
        URI countUri = baseUriBuilder.clone().path("/count").build(new Object[0]);
        resourceOptionsDto.addReflexiveLink(countUri, "GET", "count");
        if (!this.getIdentityService().isReadOnly() && this.isAuthorized((Permission)Permissions.CREATE)) {
            URI createUri = baseUriBuilder.clone().path("/create").build(new Object[0]);
            resourceOptionsDto.addReflexiveLink(createUri, "POST", "create");
        }
        return resourceOptionsDto;
    }

    protected IdentityService getIdentityService() {
        return this.getProcessEngine().getIdentityService();
    }
}

