/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricIdentityLinkLog;
import org.camunda.bpm.engine.history.HistoricIdentityLinkLogQuery;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricIdentityLinkLogDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricIdentityLinkLogQueryDto;
import org.camunda.bpm.engine.rest.history.HistoricIdentityLinkLogRestService;
import org.camunda.bpm.engine.rest.util.QueryUtil;

public class HistoricIdentityLinkLogRestServiceImpl
implements HistoricIdentityLinkLogRestService {
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public HistoricIdentityLinkLogRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    @Override
    public List<HistoricIdentityLinkLogDto> getHistoricIdentityLinks(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        HistoricIdentityLinkLogQueryDto queryDto = new HistoricIdentityLinkLogQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        HistoricIdentityLinkLogQuery query = (HistoricIdentityLinkLogQuery)queryDto.toQuery(this.processEngine);
        List<HistoricIdentityLinkLog> queryResult = QueryUtil.list(query, firstResult, maxResults);
        ArrayList<HistoricIdentityLinkLogDto> result = new ArrayList<HistoricIdentityLinkLogDto>();
        for (HistoricIdentityLinkLog historicIdentityLink : queryResult) {
            HistoricIdentityLinkLogDto dto = HistoricIdentityLinkLogDto.fromHistoricIdentityLink(historicIdentityLink);
            result.add(dto);
        }
        return result;
    }

    @Override
    public CountResultDto getHistoricIdentityLinksCount(UriInfo uriInfo) {
        HistoricIdentityLinkLogQueryDto queryDto = new HistoricIdentityLinkLogQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        HistoricIdentityLinkLogQuery query = (HistoricIdentityLinkLogQuery)queryDto.toQuery(this.processEngine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

