/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.mapper;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.RequestContext;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.mapper.MultipartFormData;

@Provider
@Consumes(value={"multipart/form-data"})
public class MultipartPayloadProvider
implements MessageBodyReader<MultipartFormData> {
    public static final String TYPE_NAME = "multipart";
    public static final String SUB_TYPE_NAME = "form-data";

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return TYPE_NAME.equals(mediaType.getType().toLowerCase()) && SUB_TYPE_NAME.equals(mediaType.getSubtype().toLowerCase());
    }

    public MultipartFormData readFrom(Class<MultipartFormData> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        MultipartFormData multipartFormData = this.createMultipartFormDataInstance();
        FileUpload fileUpload = this.createFileUploadInstance();
        String contentType = (String)httpHeaders.getFirst((Object)"content-type");
        RestMultipartRequestContext requestContext = this.createRequestContext(entityStream, contentType);
        this.parseRequest(multipartFormData, fileUpload, requestContext);
        return multipartFormData;
    }

    protected FileUpload createFileUploadInstance() {
        return new FileUpload();
    }

    protected MultipartFormData createMultipartFormDataInstance() {
        return new MultipartFormData();
    }

    protected void parseRequest(MultipartFormData multipartFormData, FileUpload fileUpload, RestMultipartRequestContext requestContext) {
        try {
            FileItemIterator itemIterator = fileUpload.getItemIterator((RequestContext)requestContext);
            while (itemIterator.hasNext()) {
                FileItemStream stream = itemIterator.next();
                multipartFormData.addPart(new MultipartFormData.FormPart(stream));
            }
        }
        catch (Exception e) {
            throw new RestException(Response.Status.BAD_REQUEST, e, "multipart/form-data cannot be processed");
        }
    }

    protected RestMultipartRequestContext createRequestContext(InputStream entityStream, String contentType) {
        return new RestMultipartRequestContext(entityStream, contentType);
    }

    static class RestMultipartRequestContext
    implements RequestContext {
        protected InputStream inputStream;
        protected String contentType;

        public RestMultipartRequestContext(InputStream inputStream, String contentType) {
            this.inputStream = inputStream;
            this.contentType = contentType;
        }

        public String getCharacterEncoding() {
            return null;
        }

        public String getContentType() {
            return this.contentType;
        }

        public int getContentLength() {
            return -1;
        }

        public InputStream getInputStream() throws IOException {
            return this.inputStream;
        }
    }
}

