/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricDetailQuery;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricDetailDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricDetailQueryDto;
import org.camunda.bpm.engine.rest.history.HistoricDetailRestService;
import org.camunda.bpm.engine.rest.sub.history.HistoricDetailResource;
import org.camunda.bpm.engine.rest.sub.history.impl.HistoricDetailResourceImpl;

public class HistoricDetailRestServiceImpl
implements HistoricDetailRestService {
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public HistoricDetailRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    @Override
    public HistoricDetailResource historicDetail(String detailId) {
        return new HistoricDetailResourceImpl(detailId, this.processEngine);
    }

    @Override
    public List<HistoricDetailDto> getHistoricDetails(UriInfo uriInfo, Integer firstResult, Integer maxResults, boolean deserializeObjectValues) {
        HistoricDetailQueryDto queryDto = new HistoricDetailQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        HistoricDetailQuery query = (HistoricDetailQuery)queryDto.toQuery(this.processEngine);
        return this.executeHistoricDetailQuery(query, firstResult, maxResults, deserializeObjectValues);
    }

    @Override
    public List<HistoricDetailDto> queryHistoricDetails(HistoricDetailQueryDto queryDto, Integer firstResult, Integer maxResults, boolean deserializeObjectValues) {
        HistoricDetailQuery query = (HistoricDetailQuery)queryDto.toQuery(this.processEngine);
        return this.executeHistoricDetailQuery(query, firstResult, maxResults, deserializeObjectValues);
    }

    @Override
    public CountResultDto getHistoricDetailsCount(UriInfo uriInfo) {
        HistoricDetailQueryDto queryDto = new HistoricDetailQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        HistoricDetailQuery query = (HistoricDetailQuery)queryDto.toQuery(this.processEngine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }

    private List<HistoricDetailDto> executeHistoricDetailQuery(HistoricDetailQuery query, Integer firstResult, Integer maxResults, boolean deserializeObjectValues) {
        query.disableBinaryFetching();
        if (!deserializeObjectValues) {
            query.disableCustomObjectDeserialization();
        }
        List<HistoricDetail> queryResult = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        ArrayList<HistoricDetailDto> result = new ArrayList<HistoricDetailDto>();
        for (HistoricDetail historicDetail : queryResult) {
            HistoricDetailDto dto = HistoricDetailDto.fromHistoricDetail(historicDetail);
            result.add(dto);
        }
        return result;
    }

    private List<HistoricDetail> executePaginatedQuery(HistoricDetailQuery query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }
}

