/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.history.ReportResult;
import org.camunda.bpm.engine.query.PeriodUnit;
import org.camunda.bpm.engine.query.Report;
import org.camunda.bpm.engine.rest.dto.AbstractSearchQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.converter.PeriodUnitConverter;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;

public abstract class AbstractReportDto<T extends Report>
extends AbstractSearchQueryDto {
    protected PeriodUnit periodUnit;
    protected String reportType;
    public static final String REPORT_TYPE_DURATION = "duration";
    public static final String REPORT_TYPE_COUNT = "count";
    public static final List<String> VALID_REPORT_TYPE_VALUES = new ArrayList<String>();

    public AbstractReportDto() {
    }

    public AbstractReportDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    protected PeriodUnit getPeriodUnit() {
        return this.periodUnit;
    }

    public String getReportType() {
        return this.reportType;
    }

    @CamundaQueryParam(value="reportType")
    public void setReportType(String reportType) {
        if (!VALID_REPORT_TYPE_VALUES.contains(reportType)) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "reportType parameter has invalid value: " + reportType);
        }
        this.reportType = reportType;
    }

    @CamundaQueryParam(value="periodUnit", converter=PeriodUnitConverter.class)
    public void setPeriodUnit(PeriodUnit periodUnit) {
        this.periodUnit = periodUnit;
    }

    protected List<? extends ReportResult> executeReportQuery(T report) {
        return report.duration(this.periodUnit);
    }

    public List<? extends ReportResult> executeReport(ProcessEngine engine) {
        T reportQuery = this.createNewReportQuery(engine);
        this.applyFilters(reportQuery);
        try {
            return this.executeReportQuery(reportQuery);
        }
        catch (NotValidException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), e.getMessage());
        }
    }

    protected abstract T createNewReportQuery(ProcessEngine var1);

    protected abstract void applyFilters(T var1);

    static {
        VALID_REPORT_TYPE_VALUES.add(REPORT_TYPE_DURATION);
        VALID_REPORT_TYPE_VALUES.add(REPORT_TYPE_COUNT);
    }
}

