/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.runtime.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.identity.Authentication;
import org.camunda.bpm.engine.rest.dto.task.CommentDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.sub.runtime.ProcessInstanceCommentResource;
import org.camunda.bpm.engine.task.Comment;

public class ProcessInstanceCommentResourceImpl
implements ProcessInstanceCommentResource {
    private ProcessEngine engine;
    private String processInstanceId;

    public ProcessInstanceCommentResourceImpl(ProcessEngine engine, String processInstanceId) {
        this.engine = engine;
        this.processInstanceId = processInstanceId;
    }

    @Override
    public List<CommentDto> getComments() {
        if (!this.isHistoryEnabled()) {
            return Collections.emptyList();
        }
        this.ensureProcessInstanceExists(Response.Status.NOT_FOUND);
        List processInstanceComments = this.engine.getTaskService().getProcessInstanceComments(this.processInstanceId);
        ArrayList<CommentDto> comments = new ArrayList<CommentDto>();
        for (Comment comment : processInstanceComments) {
            comments.add(CommentDto.fromComment(comment));
        }
        return comments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isHistoryEnabled() {
        IdentityService identityService = this.engine.getIdentityService();
        Authentication currentAuthentication = identityService.getCurrentAuthentication();
        try {
            identityService.clearAuthentication();
            int historyLevel = this.engine.getManagementService().getHistoryLevel();
            boolean bl = historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE;
            return bl;
        }
        finally {
            identityService.setAuthentication(currentAuthentication);
        }
    }

    private void ensureProcessInstanceExists(Response.Status status) {
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.engine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(this.processInstanceId).singleResult();
        if (historicProcessInstance == null) {
            throw new InvalidRequestException(status, "No process instance found for id " + this.processInstanceId);
        }
    }
}

